/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.DependencyPathsRenderer;
import classycle.dependency.Result;
import classycle.graph.AtomicVertex;
import classycle.graph.Vertex;
import classycle.util.StringPattern;

public class DependencyResult
implements Result {
    static final String OK = "\tOK";
    static final String DEPENDENCIES_FOUND = "\n  Unexpected dependencies found:";
    private final StringPattern _startSet;
    private final StringPattern _finalSet;
    private final String _statement;
    private final AtomicVertex[] _paths;
    private final boolean _ok;

    public DependencyResult(StringPattern startSet, StringPattern finalSet, String statement, AtomicVertex[] paths) {
        this._startSet = startSet;
        this._finalSet = finalSet;
        this._statement = statement;
        this._paths = paths;
        this._ok = paths.length == 0;
    }

    public boolean isOk() {
        return this._ok;
    }

    public String getStatement() {
        return this._statement;
    }

    public StringPattern getFinalSet() {
        return this._finalSet;
    }

    public AtomicVertex[] getPaths() {
        return this._paths;
    }

    public StringPattern getStartSet() {
        return this._startSet;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this._statement);
        if (this._ok) {
            buffer.append(OK);
        } else {
            DependencyPathsRenderer renderer = new DependencyPathsRenderer((Vertex[])this._paths, this._startSet, this._finalSet);
            buffer.append(DEPENDENCIES_FOUND).append(renderer.renderGraph("  "));
        }
        return new String(buffer.append('\n'));
    }
}

