/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.repo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.ivy.osgi.repo.AbstractFSManifestIterable;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.util.ResolverHelper;

public class RepositoryManifestIterable
extends AbstractFSManifestIterable {
    private final Repository repo;

    public RepositoryManifestIterable(Repository repository) {
        super("");
        this.repo = repository;
    }

    @Override
    protected URI buildBundleURI(Object object) throws IOException {
        Resource resource = this.repo.getResource((String)object);
        try {
            return new URI(resource.getName());
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(resource.getName()).toURI();
        }
    }

    @Override
    protected InputStream getInputStream(Object object) throws IOException {
        return this.repo.getResource((String)object).openStream();
    }

    @Override
    protected List listBundleFiles(Object object) throws IOException {
        return this.asList(ResolverHelper.listAll(this.repo, (String)object));
    }

    @Override
    protected List listDirs(Object object) throws IOException {
        return this.asList(ResolverHelper.listAll(this.repo, (String)object));
    }

    private List asList(String[] stringArray) {
        return stringArray == null ? Collections.EMPTY_LIST : Arrays.asList(stringArray);
    }
}

