/*
 * Decompiled with CFR 0.152.
 */
package util.programmouseevent;

import compat.VersionCompat;
import devplugin.ActionMenu;
import devplugin.ContextMenuIf;
import devplugin.Plugin;
import devplugin.Program;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import javax.swing.SwingUtilities;
import tvbrowser.core.contextmenu.ContextMenuManager;
import util.programmouseevent.ProgramContextMenuListener;
import util.programmouseevent.ProgramMouseActionListener;
import util.programmouseevent.ProgramMouseAndContextMenuListener;

public class ProgramMouseEventHandler
extends MouseAdapter {
    private ProgramMouseAndContextMenuListener mContextMenuListener;
    private ContextMenuIf mOwner;
    private Thread mSingleClickThread;
    private boolean mPerformingSingleClick = false;

    public ProgramMouseEventHandler(ProgramMouseAndContextMenuListener listener, ContextMenuIf owner) {
        this.mContextMenuListener = listener;
        this.mOwner = owner;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.mContextMenuListener instanceof ProgramMouseActionListener) {
            Program prog = this.mContextMenuListener.getProgramForMouseEvent(e);
            if (e.getClickCount() == 1) {
                this.performSingleClick(prog, e);
            } else if (e.getClickCount() == 2) {
                this.performDoubleClick(prog, e);
            }
        }
    }

    private void performSingleClick(final Program prog, final MouseEvent e) {
        this.mSingleClickThread = new Thread("Single click"){

            @Override
            public void run() {
                try {
                    ProgramMouseEventHandler.this.mPerformingSingleClick = false;
                    1.sleep(Plugin.SINGLE_CLICK_WAITING_TIME);
                    ProgramMouseEventHandler.this.mPerformingSingleClick = true;
                    ProgramMouseEventHandler.handleProgramClick(prog, ProgramMouseEventHandler.this.mOwner, true, e);
                    ProgramMouseEventHandler.this.mPerformingSingleClick = false;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this.mSingleClickThread.setPriority(1);
        this.mSingleClickThread.start();
    }

    private void performDoubleClick(Program prog, MouseEvent e) {
        if (!this.mPerformingSingleClick && this.mSingleClickThread != null && this.mSingleClickThread.isAlive()) {
            this.mSingleClickThread.interrupt();
        }
        if (!this.mPerformingSingleClick) {
            ProgramMouseEventHandler.handleProgramClick(prog, this.mOwner, false, e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.testAndHandleContextMenuEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.testAndHandleContextMenuEvent(e);
    }

    private void testAndHandleContextMenuEvent(MouseEvent e) {
        if (this.mContextMenuListener instanceof ProgramContextMenuListener && e.isPopupTrigger()) {
            this.mContextMenuListener.showContextMenu(e);
        }
    }

    public static void handleProgramClick(Program program, ContextMenuIf caller, boolean singleClick, MouseEvent e) {
        if (program == null || e == null) {
            return;
        }
        ContextMenuIf menuIf = null;
        int actionId = -1;
        if (VersionCompat.isExtendedMouseActionSupported()) {
            try {
                Method m = ContextMenuManager.class.getDeclaredMethod(singleClick ? "getContextMenuForSingleClick" : "getContextMenuForDoubleClick", MouseEvent.class);
                Object contextMenu = m.invoke((Object)ContextMenuManager.getInstance(), e);
                if (contextMenu == null) {
                    return;
                }
                if (contextMenu instanceof ContextMenuIf) {
                    menuIf = (ContextMenuIf)contextMenu;
                } else if (contextMenu.getClass().getCanonicalName().equals("tvbrowser.core.contextmenu.ContextMenuManager.ContextMenuAction")) {
                    Method getContextMenuIf = contextMenu.getClass().getDeclaredMethod("getContextMenuIf", new Class[0]);
                    menuIf = (ContextMenuIf)getContextMenuIf.invoke(contextMenu, new Object[0]);
                    Method getContextMenuActionId = contextMenu.getClass().getDeclaredMethod("getContextMenuActionId", new Class[0]);
                    actionId = (Integer)getContextMenuActionId.invoke(contextMenu, new Object[0]);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            menuIf = singleClick ? ((e.getModifiersEx() & 0x80) == 128 ? ContextMenuManager.getInstance().getLeftSingleCtrlClickIf() : ContextMenuManager.getInstance().getLeftSingleClickIf()) : ContextMenuManager.getInstance().getDefaultContextMenuIf();
        } else if (SwingUtilities.isMiddleMouseButton(e)) {
            ContextMenuIf contextMenuIf = menuIf = singleClick ? ContextMenuManager.getInstance().getMiddleClickIf() : ContextMenuManager.getInstance().getMiddleDoubleClickIf();
        }
        if (menuIf == null || caller != null && menuIf.getId().equals(caller.getId())) {
            return;
        }
        ActionMenu actionMenu = menuIf.getContextMenuActions(program);
        ProgramMouseEventHandler.handleAction(program, actionMenu, actionId);
    }

    public static void handleAction(Program program, ActionMenu menu) {
        ProgramMouseEventHandler.handleAction(program, menu, -1);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void handleAction(Program program, ActionMenu menu, int actionId) {
        block11: {
            action = null;
            loadActionMenu = null;
            if (actionId != -1 && VersionCompat.isAtLeastTvBrowser4()) {
                try {
                    loadActionMenu = ContextMenuManager.class.getDeclaredMethod("loadActionMenu", new Class[]{ActionMenu.class, Integer.TYPE});
                }
                catch (Exception var5_5) {
                    // empty catch block
                }
            }
            if (actionId == -1 || loadActionMenu == null) ** GOTO lbl21
            actionMenu = null;
            try {
                actionMenu = (ActionMenu)loadActionMenu.invoke(null, new Object[]{menu /* !! */ , actionId});
            }
            catch (Exception var6_7) {
                // empty catch block
            }
            if (actionMenu == null) break block11;
            action = actionMenu.getAction();
            break block11;
lbl-1000:
            // 1 sources

            {
                subItems = menu /* !! */ .getSubItems();
                menu /* !! */  = subItems.length > 0 ? subItems[0] : null;
lbl21:
                // 2 sources

                ** while (menu /* !! */  != null && menu /* !! */ .hasSubItems())
            }
lbl22:
            // 1 sources

            if (menu /* !! */  == null) {
                return;
            }
            action = menu /* !! */ .getAction();
        }
        if (action != null) {
            evt = new ActionEvent(program, 0, (String)action.getValue("ActionCommandKey"));
            action.actionPerformed(evt);
        }
    }
}

