/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.plugin;

import devplugin.ActionMenu;
import devplugin.Channel;
import devplugin.ChannelDayProgram;
import devplugin.ContextMenuIf;
import devplugin.FilterManager;
import devplugin.Plugin;
import devplugin.PluginAccess;
import devplugin.PluginManager;
import devplugin.PluginProgramInformation;
import devplugin.Program;
import devplugin.ProgramFieldType;
import devplugin.ProgramRatingIf;
import devplugin.ProgramReceiveIf;
import devplugin.ProgramReceiveTarget;
import devplugin.ProgramSearcher;
import devplugin.ProgressMonitorExtended;
import devplugin.ThemeIcon;
import devplugin.TvBrowserSettings;
import devplugin.TvBrowserSettingsImpl;
import devplugin.Version;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import tvbrowser.TVBrowser;
import tvbrowser.core.ChannelList;
import tvbrowser.core.Settings;
import tvbrowser.core.TvDataBase;
import tvbrowser.core.contextmenu.ContextMenuManager;
import tvbrowser.core.filters.FilterManagerImpl;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.ButtonActionIf;
import tvbrowser.core.plugin.JavaPluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.plugin.programformating.GlobalPluginProgramFormatingManager;
import tvbrowser.core.search.booleansearch.BooleanSearcher;
import tvbrowser.core.search.booleansearch.ParserException;
import tvbrowser.core.search.regexsearch.RegexSearcher;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.settings.SettingsDialog;
import tvbrowser.ui.settings.ToolBarDragAndDropSettings;
import tvdataservice.MarkedProgramsMap;
import tvdataservice.MutableProgram;
import util.exc.TvBrowserException;
import util.program.AbstractPluginProgramFormating;
import util.settings.ContextMenuMouseActionSetting;

public class PluginManagerImpl
implements PluginManager {
    private Program mExampleProgram;
    private static final Logger LOG = Logger.getLogger(PluginManagerImpl.class.getName());
    private static final Iterator<Program> EMPTY_ITERATOR = new Iterator<Program>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Program next() {
            return null;
        }

        @Override
        public void remove() {
        }
    };
    private static PluginManagerImpl INSTANCE;
    private boolean mTvBrowserStartFinished = false;
    private TvBrowserSettingsImpl mTvBrowserSettings;

    private PluginManagerImpl() {
        try {
            this.mTvBrowserSettings = new TvBrowserSettingsImpl(this);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static PluginManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PluginManagerImpl();
        }
        return INSTANCE;
    }

    private boolean checkChannelAccess(Channel ch) {
        if (ch != null && ch.isAccessControl() && Settings.Plugins.ACCESS_CONTROL.getStringArray().length > 0) {
            StackTraceElement[] stackTace = Thread.currentThread().getStackTrace();
            String[] values = Settings.Plugins.ACCESS_CONTROL.getStringArray();
            for (int i = 0; i < Math.min(5, stackTace.length); ++i) {
                for (String testValue : values) {
                    String className = stackTace[i].getClassName();
                    if (!className.substring(0, className.indexOf(".")).equals(testValue)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public Program getProgram(devplugin.Date date, String progID) {
        Channel ch = this.getChannelFromProgId(progID);
        if (this.checkChannelAccess(ch)) {
            devplugin.Date cutoff = devplugin.Date.getCurrentDate().addDays(-1);
            ChannelDayProgram dayProg = this.getDayProgram(date, progID, ch);
            if (dayProg != null) {
                Program prog = dayProg.getProgram(progID);
                if (prog != null) {
                    return prog;
                }
                if (date.compareTo(cutoff) >= 0) {
                    LOG.warning("could not find program with id '" + progID + "' (date: " + date + ")");
                }
            } else if (date.compareTo(cutoff) >= 0) {
                LOG.warning("day program not found: " + progID + "; " + date);
            }
        }
        return null;
    }

    private ChannelDayProgram getDayProgram(devplugin.Date date, String progID, Channel ch) {
        TvDataBase db = TvDataBase.getInstance();
        if (ch != null && ChannelList.isSubscribedChannel(ch)) {
            int index = progID.lastIndexOf(95);
            String timeString = progID.substring(index + 1);
            String[] hourMinute = timeString.split(":");
            int milliSeconds = Integer.parseInt(hourMinute[0]) * 60 * 60 * 1000 + Integer.parseInt(hourMinute[1]) * 60 * 1000;
            int diff = Math.abs(ch.getTimeZone().getOffset(date.getCalendar().getTimeInMillis() + (long)milliSeconds) - TimeZone.getDefault().getOffset(date.getCalendar().getTimeInMillis() + (long)milliSeconds));
            if (ch.getTimeZone().getOffset(date.getCalendar().getTimeInMillis() + (long)milliSeconds) < TimeZone.getDefault().getOffset(date.getCalendar().getTimeInMillis() + (long)milliSeconds)) {
                if (milliSeconds < diff) {
                    date = date.addDays(-1);
                }
            } else if (milliSeconds + diff >= 86400000) {
                date = date.addDays(1);
            }
            return db.getDayProgram(date, ch);
        }
        LOG.warning("channel for program '" + progID + "' not found or not a subscribed channel");
        return null;
    }

    @Override
    public Program[] getPrograms(devplugin.Date date, String progID) {
        Channel ch = this.getChannelFromProgId(progID);
        if (this.checkChannelAccess(ch)) {
            ChannelDayProgram dayProg = this.getDayProgram(date, progID, ch);
            if (dayProg != null) {
                Program[] progs = dayProg.getPrograms(progID);
                if (progs != null) {
                    return progs;
                }
                LOG.warning("could not find program with id '" + progID + "' (date: " + date + ")");
            } else {
                LOG.warning("day program not found: " + progID + "; " + date);
            }
        }
        return null;
    }

    @Override
    public Program getProgram(String uniqueID) {
        if (uniqueID != null && uniqueID.trim().length() > 0) {
            Object[] values = this.getDateAndProgIDforUniqueID(uniqueID);
            return values != null ? this.getProgram((devplugin.Date)values[0], (String)values[1]) : null;
        }
        return null;
    }

    private Object[] getDateAndProgIDforUniqueID(String uniqueID) {
        devplugin.Date progDate;
        String[] id = uniqueID.split("_");
        StringBuilder channelName = new StringBuilder();
        try {
            for (int i = 3; i < 3 + id.length - 5; ++i) {
                channelName.append(id[i]).append("_");
            }
            if (channelName.length() > 0) {
                channelName.delete(channelName.length() - 1, channelName.length());
            }
            Date date = new SimpleDateFormat("yyyy-MM-dd").parse(id[id.length - 2]);
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(date.getTime());
            progDate = new devplugin.Date(cal);
        }
        catch (ParseException e) {
            LOG.severe("Couldn't parse date from unique ID: " + uniqueID);
            return null;
        }
        return new Object[]{progDate, id[0] + '_' + id[1] + '_' + id[2] + '_' + channelName.toString() + '_' + id[id.length - 1]};
    }

    @Override
    public Program[] getPrograms(String uniqueID) {
        Object[] values = this.getDateAndProgIDforUniqueID(uniqueID);
        return values != null ? this.getPrograms((devplugin.Date)values[0], (String)values[1]) : null;
    }

    private Channel getChannelFromProgId(String progId) {
        Channel channel;
        int strLen = progId.length();
        int count = 0;
        int lastSeparator = 0;
        for (int i = 0; i < strLen; ++i) {
            if (progId.charAt(i) != '_') continue;
            ++count;
            lastSeparator = i;
        }
        if (count == 4 && (channel = ChannelList.getChannel(progId.substring(0, lastSeparator))) != null) {
            return channel;
        }
        String[] s = progId.split("_");
        if (s.length < 4) {
            return ChannelList.getChannel(null, null, null, s[0]);
        }
        if (s.length == 4) {
            return ChannelList.getChannel(s[0], s[1], null, s[2]);
        }
        return ChannelList.getChannel(s[0], s[1], s[2], s[3]);
    }

    @Override
    public Channel[] getSubscribedChannels() {
        if (Settings.Plugins.ACCESS_CONTROL.getStringArray().length > 0) {
            StackTraceElement[] stackTace = Thread.currentThread().getStackTrace();
            String[] values = Settings.Plugins.ACCESS_CONTROL.getStringArray();
            boolean isAccessControl = false;
            block0: for (int i = 0; i < Math.min(5, stackTace.length); ++i) {
                for (String testValue : values) {
                    String className = stackTace[i].getClassName();
                    if (!className.substring(0, className.indexOf(".")).equals(testValue)) continue;
                    isAccessControl = true;
                    continue block0;
                }
            }
            Channel[] channels = ChannelList.getSubscribedChannels();
            if (isAccessControl) {
                ArrayList<Channel> accessChannels = new ArrayList<Channel>();
                for (Channel ch : channels) {
                    if (ch.isAccessControl()) continue;
                    accessChannels.add(ch);
                }
                return accessChannels.toArray(new Channel[accessChannels.size()]);
            }
            return channels;
        }
        return ChannelList.getSubscribedChannels();
    }

    @Override
    public Iterator<Program> getChannelDayProgram(devplugin.Date date, Channel channel) {
        if (this.checkChannelAccess(channel)) {
            ChannelDayProgram channelDayProgram = TvDataBase.getInstance().getDayProgram(date, channel);
            if (channelDayProgram == null) {
                return EMPTY_ITERATOR;
            }
            if (!channel.getTimeZone().equals(TimeZone.getDefault())) {
                int i;
                ArrayList<Program> newList = new ArrayList<Program>();
                ChannelDayProgram yesterday = TvDataBase.getInstance().getDayProgram(date.addDays(-1), channel);
                if (yesterday != null) {
                    for (i = yesterday.getProgramCount() - 1; i >= 0 && yesterday.getProgramAt(i).getDate().equals(date); --i) {
                        newList.add(0, yesterday.getProgramAt(i));
                    }
                }
                for (i = 0; i < channelDayProgram.getProgramCount(); ++i) {
                    if (!channelDayProgram.getProgramAt(i).getDate().equals(date)) continue;
                    newList.add(channelDayProgram.getProgramAt(i));
                }
                ChannelDayProgram tomorrow = TvDataBase.getInstance().getDayProgram(date.addDays(1), channel);
                if (tomorrow != null) {
                    for (int i2 = 0; i2 < tomorrow.getProgramCount() && tomorrow.getProgramAt(i2).getDate().equals(date); ++i2) {
                        newList.add(tomorrow.getProgramAt(i2));
                    }
                }
                return newList.iterator();
            }
            return channelDayProgram.getPrograms();
        }
        return EMPTY_ITERATOR;
    }

    @Override
    public ProgramSearcher createProgramSearcher(int type, String searchTerm, boolean caseSensitive) throws TvBrowserException {
        switch (type) {
            case 1: {
                String regex = RegexSearcher.searchTextToRegex(searchTerm, 0);
                return new RegexSearcher(regex, caseSensitive, searchTerm);
            }
            case 5: {
                String regex = RegexSearcher.searchTextToRegex(searchTerm, 2);
                return new RegexSearcher(regex, caseSensitive, searchTerm);
            }
            case 2: {
                searchTerm = searchTerm.trim();
                String regex = RegexSearcher.searchTextToRegex(searchTerm, 1);
                return new RegexSearcher(regex, caseSensitive, searchTerm);
            }
            case 3: {
                return new RegexSearcher(searchTerm, caseSensitive);
            }
            case 4: {
                try {
                    return new BooleanSearcher(searchTerm, caseSensitive);
                }
                catch (ParserException e) {
                    throw new TvBrowserException(PluginManagerImpl.class, "parser.error", "Invalid input: {0}", e.getLocalizedMessage());
                }
            }
        }
        throw new IllegalArgumentException("Unknown searcher type: " + type);
    }

    @Override
    public PluginAccess[] getActivatedPlugins() {
        return PluginProxyManager.getInstance().getActivatedPlugins();
    }

    @Override
    public String getJavaPluginId(Plugin javaPlugin) {
        return JavaPluginProxy.getJavaPluginId(javaPlugin);
    }

    @Override
    public PluginAccess getActivatedPluginForId(String pluginId) {
        return PluginProxyManager.getInstance().getActivatedPluginForId(pluginId);
    }

    @Override
    public TvDataServiceProxy getDataServiceProxy(String id) {
        return TvDataServiceProxyManager.getInstance().findDataServiceById(id);
    }

    @Override
    public JPopupMenu createPluginContextMenu(Program program, ContextMenuIf caller) {
        return this.createPluginContextMenu(program, caller, null);
    }

    @Override
    public JPopupMenu createPluginContextMenu(Program program, ContextMenuIf caller, ActionMenu callerMenu) {
        return PluginProxyManager.createPluginContextMenu(program, caller, callerMenu);
    }

    @Override
    public Program getExampleProgram() {
        if (this.mExampleProgram == null) {
            Channel exampleChannel = new Channel(null, "Channel 1", TimeZone.getDefault(), "de", "");
            MutableProgram prog = new MutableProgram(exampleChannel, devplugin.Date.getCurrentDate(), 14, 45, true);
            prog.setTitle("Die Waltons");
            prog.setShortInfo("Die Verfilmung der Kindheits- und Jugenderinnerungen des Romanschriftstellers Earl Hamner jr.");
            prog.setDescription("Olivia ist schon seit einigen Tagen niedergeschlagen, obwohl ihr Geburtstag bevorsteht. Ihre einzige Freude scheint das Postflugzeug zu sein, dem sie allabendlich von der Haust\u00fcr aus sehnsuchtsvoll hinterhersieht.");
            prog.setTextField(ProgramFieldType.ACTOR_LIST_TYPE, "Ralph Waite (Vater John Walton), Mary McDonough (Erin Walton), Michael Learned (Mutter Olivia Walton), Kami Cotler (Elisabeth Walton), Jon Walmsley (Jason Walton), Ellen Corby (Gro\u00dfmutter Ester Walton), David Harper (Jim Bob Walton), Judy Taylor (Mary Ellen Walton), Richard Thomas (John-Boy Walton)");
            prog.setIntField(ProgramFieldType.AGE_LIMIT_TYPE, 6);
            prog.setTextField(ProgramFieldType.EPISODE_TYPE, "Der Postflieger");
            prog.setTextField(ProgramFieldType.GENRE_TYPE, "Familie");
            prog.setTextField(ProgramFieldType.ORIGINAL_EPISODE_TYPE, "Air Mail Man");
            prog.setTextField(ProgramFieldType.ORIGINAL_TITLE_TYPE, "The Waltons");
            prog.setTextField(ProgramFieldType.ORIGIN_TYPE, "USA");
            prog.setIntField(ProgramFieldType.PRODUCTION_YEAR_TYPE, 1972);
            prog.setTextField(ProgramFieldType.REPETITION_OF_TYPE, "Wh von gestern, 8:00");
            prog.setIntField(ProgramFieldType.NET_PLAYING_TIME_TYPE, 45);
            prog.setTimeField(ProgramFieldType.END_TIME_TYPE, 945);
            prog.setTextField(ProgramFieldType.URL_TYPE, "http://www.thewaltons.com");
            prog.setTimeField(ProgramFieldType.VPS_TYPE, 885);
            prog.setInfo(768);
            prog.setIntField(ProgramFieldType.EPISODE_NUMBER_TYPE, 13);
            prog.setIntField(ProgramFieldType.EPISODE_TOTAL_NUMBER_TYPE, 24);
            prog.setIntField(ProgramFieldType.SEASON_NUMBER_TYPE, 2);
            prog.setTextField(ProgramFieldType.PRODUCTION_COMPANY_TYPE, "Lorimar Television");
            prog.setTextField(ProgramFieldType.CAMERA_TYPE, "Jon Doe");
            prog.setTextField(ProgramFieldType.CUTTER_TYPE, "Jon Doe");
            prog.setIntField(ProgramFieldType.RATING_TYPE, 70);
            this.mExampleProgram = prog;
        }
        return this.mExampleProgram;
    }

    @Override
    @Deprecated(since="3.3.1")
    public void handleProgramSingleClick(Program program) {
        this.handleProgramSingleClick(program, null);
    }

    @Override
    @Deprecated(since="3.3.1")
    public void handleProgramSingleClick(Program program, ContextMenuIf caller) {
        ContextMenuMouseActionSetting[] leftSingleSetting = Settings.Mouse.LEFT_SINGLE_CLICK_IF_ARRAY.getContextMenuMouseActionArray();
        if (program == null || leftSingleSetting == null || leftSingleSetting.length == 0) {
            return;
        }
        ContextMenuManager.ContextMenuAction action = ContextMenuManager.getInstance().getContextMenuArrayForModifierEx(leftSingleSetting[0].getModifiersEx(), true, true);
        if (action == null) {
            return;
        }
        ContextMenuIf leftSingleClickIf = action.getContextMenuIf();
        if (leftSingleClickIf == null) {
            return;
        }
        if (caller != null && leftSingleClickIf.getId().equals(caller.getId())) {
            return;
        }
        this.handleAction(program, leftSingleClickIf.getContextMenuActions(program));
    }

    @Override
    @Deprecated(since="3.3.1")
    public void handleProgramSingleCtrlClick(Program program, ContextMenuIf caller) {
        ContextMenuMouseActionSetting[] leftSingleSetting = Settings.Mouse.LEFT_SINGLE_CLICK_IF_ARRAY.getContextMenuMouseActionArray();
        if (program == null || leftSingleSetting == null || leftSingleSetting.length < 2) {
            return;
        }
        ContextMenuManager.ContextMenuAction action = ContextMenuManager.getInstance().getContextMenuArrayForModifierEx(leftSingleSetting[1].getModifiersEx(), true, true);
        if (action == null) {
            return;
        }
        ContextMenuIf clickInterface = action.getContextMenuIf();
        if (clickInterface == null) {
            return;
        }
        if (caller != null && clickInterface.getId().equals(caller.getId())) {
            return;
        }
        this.handleAction(program, clickInterface.getContextMenuActions(program));
    }

    @Override
    @Deprecated(since="3.3.1")
    public void handleProgramDoubleClick(Program program) {
        this.handleProgramDoubleClick(program, null);
    }

    @Override
    @Deprecated(since="3.3.1")
    public void handleProgramDoubleClick(Program program, ContextMenuIf caller) {
        ContextMenuMouseActionSetting[] leftDoubleSetting = Settings.Mouse.LEFT_DOUBLE_CLICK_IF_ARRAY.getContextMenuMouseActionArray();
        if (program == null || leftDoubleSetting == null || leftDoubleSetting.length == 0) {
            return;
        }
        ContextMenuManager.ContextMenuAction action = ContextMenuManager.getInstance().getContextMenuArrayForModifierEx(leftDoubleSetting[0].getModifiersEx(), true, false);
        if (action == null) {
            return;
        }
        ContextMenuIf defaultContextMenuIf = action.getContextMenuIf();
        if (defaultContextMenuIf == null) {
            return;
        }
        if (caller != null && defaultContextMenuIf.getId().equals(caller.getId())) {
            return;
        }
        this.handleAction(program, defaultContextMenuIf.getContextMenuActions(program));
    }

    @Override
    @Deprecated(since="3.3.1")
    public void handleProgramMiddleClick(Program program) {
        this.handleProgramMiddleClick(program, null);
    }

    @Override
    @Deprecated(since="3.3.1")
    public void handleProgramMiddleClick(Program program, ContextMenuIf caller) {
        ContextMenuMouseActionSetting[] middleLeftSetting = Settings.Mouse.MIDDLE_SINGLE_CLICK_IF_ARRAY.getContextMenuMouseActionArray();
        if (program == null || middleLeftSetting == null || middleLeftSetting.length == 0) {
            return;
        }
        ContextMenuManager.ContextMenuAction action = ContextMenuManager.getInstance().getContextMenuArrayForModifierEx(middleLeftSetting[0].getModifiersEx(), false, true);
        if (action == null) {
            return;
        }
        ContextMenuIf middleClickIf = action.getContextMenuIf();
        if (middleClickIf == null) {
            return;
        }
        if (caller != null && middleClickIf.getId().equals(caller.getId())) {
            return;
        }
        this.handleAction(program, middleClickIf.getContextMenuActions(program));
    }

    @Override
    @Deprecated(since="3.3.1")
    public void handleProgramMiddleDoubleClick(Program program) {
        this.handleProgramMiddleDoubleClick(program, null);
    }

    @Override
    @Deprecated(since="3.3.1")
    public void handleProgramMiddleDoubleClick(Program program, ContextMenuIf caller) {
        ContextMenuMouseActionSetting[] middleDoubleSetting = Settings.Mouse.MIDDLE_DOUBLE_CLICK_IF_ARRAY.getContextMenuMouseActionArray();
        if (program == null || middleDoubleSetting == null || middleDoubleSetting.length == 0) {
            return;
        }
        ContextMenuManager.ContextMenuAction action = ContextMenuManager.getInstance().getContextMenuArrayForModifierEx(middleDoubleSetting[0].getModifiersEx(), false, false);
        if (action == null) {
            return;
        }
        ContextMenuIf middleDoubleClickIf = action.getContextMenuIf();
        if (middleDoubleClickIf == null) {
            return;
        }
        if (caller != null && middleDoubleClickIf.getId().equals(caller.getId())) {
            return;
        }
        this.handleAction(program, middleDoubleClickIf.getContextMenuActions(program));
    }

    private void handleAction(Program program, ActionMenu menu) {
        while (menu != null && menu.hasSubItems()) {
            ActionMenu[] subItems = menu.getSubItems();
            if (subItems.length > 0) {
                menu = subItems[0];
                continue;
            }
            menu = null;
        }
        if (menu == null) {
            return;
        }
        Action action = menu.getAction();
        if (action != null) {
            ActionEvent evt = new ActionEvent(program, 0, (String)action.getValue("ActionCommandKey"));
            action.actionPerformed(evt);
        }
    }

    public PluginAccess getDefaultContextMenuPlugin() {
        return null;
    }

    @Override
    public TvBrowserSettings getTvBrowserSettings() {
        return this.mTvBrowserSettings;
    }

    @Override
    public ImageIcon getIconFromTheme(Plugin plugin, String category, String iconName, int size) {
        return IconLoader.getInstance().getIconFromTheme(plugin, category, iconName, size);
    }

    @Override
    public ImageIcon getIconFromTheme(Plugin plugin, ThemeIcon icon) {
        return IconLoader.getInstance().getIconFromTheme(plugin, icon);
    }

    @Override
    public void showSettings(Plugin plugin) {
        if (SettingsDialog.getInstance() == null) {
            MainFrame.getInstance().showSettingsDialog(plugin);
        } else {
            SettingsDialog.getInstance().showSettingsTab(plugin.getId());
        }
    }

    @Override
    public void showSettings(String settingsItem) {
        if (settingsItem.equals("#toolbar")) {
            if (SettingsDialog.getInstance() != null) {
                SettingsDialog.getInstance().close();
            }
            new ToolBarDragAndDropSettings();
        } else if (SettingsDialog.getInstance() == null) {
            MainFrame.getInstance().showSettingsDialog(settingsItem);
        } else {
            SettingsDialog.getInstance().showSettingsTab(settingsItem);
        }
    }

    @Override
    public Program[] getMarkedPrograms() {
        return MarkedProgramsMap.getInstance().getMarkedPrograms();
    }

    @Override
    public ProgramReceiveIf[] getReceiveIfs() {
        return this.getReceiveIfs(null, null);
    }

    @Override
    public ProgramReceiveIf[] getReceiveIfs(ProgramReceiveIf caller, ProgramReceiveTarget callerTarget) {
        PluginAccess[] plugins = this.getActivatedPlugins();
        ArrayList<ButtonActionIf> receiveIfs = new ArrayList<ButtonActionIf>();
        if (caller == null || caller.getId().compareTo(ReminderPluginProxy.getInstance().getId()) != 0) {
            receiveIfs.add(ReminderPluginProxy.getInstance());
        }
        for (PluginAccess plugin : plugins) {
            if (!plugin.canReceiveProgramsWithTarget() || plugin.getProgramReceiveTargets() == null || plugin.getProgramReceiveTargets().length <= 0 || caller != null && plugin.getId().compareTo(caller.getId()) == 0 && (plugin.getId().compareTo(caller.getId()) != 0 || callerTarget == null || plugin.getProgramReceiveTargets().length == 1 && plugin.getProgramReceiveTargets()[0].equals(callerTarget))) continue;
            receiveIfs.add(plugin);
        }
        Collections.sort(receiveIfs);
        return receiveIfs.toArray(new ProgramReceiveIf[receiveIfs.size()]);
    }

    @Override
    public ProgramReceiveIf getReceiceIfForId(String id) {
        ProgramReceiveIf[] receiveIfs;
        for (ProgramReceiveIf receiveIf : receiveIfs = this.getReceiveIfs()) {
            if (receiveIf.getId().compareTo(id) != 0) continue;
            return receiveIf;
        }
        return null;
    }

    @Override
    public void scrollToProgram(Program program) {
        if (program != null) {
            MainFrame.getInstance().scrollToProgram(program);
            MainFrame.getInstance().showProgramTableTabIfAvailable();
        }
    }

    @Override
    public void selectProgram(Program program) {
        if (program != null) {
            MainFrame.getInstance().selectProgram(program, true);
            MainFrame.getInstance().showProgramTableTabIfAvailable();
        }
    }

    @Override
    public void scrollToTime(int time) {
        MainFrame.getInstance().scrollToTime(time, true);
        MainFrame.getInstance().showProgramTableTabIfAvailable();
    }

    @Override
    public void scrollToTime(int time, boolean highlight) {
        MainFrame.getInstance().scrollToTime(time, highlight);
        MainFrame.getInstance().showProgramTableTabIfAvailable();
    }

    @Override
    public void scrollToChannel(Channel channel) {
        MainFrame.getInstance().getProgramTableScrollPane().scrollToChannel(channel);
        MainFrame.getInstance().showProgramTableTabIfAvailable();
    }

    @Override
    public void goToDate(devplugin.Date date) {
        if (TvDataBase.getInstance().dataAvailable(date)) {
            MainFrame.getInstance().goTo(date);
            MainFrame.getInstance().showProgramTableTabIfAvailable();
        }
    }

    @Override
    public FilterManager getFilterManager() {
        return FilterManagerImpl.getInstance();
    }

    protected void handleTvBrowserStartFinished() {
        this.mTvBrowserStartFinished = true;
    }

    @Override
    public AbstractPluginProgramFormating[] getAvailableGlobalPuginProgramFormatings() {
        return GlobalPluginProgramFormatingManager.getInstance().getAvailableGlobalPluginProgramFormatings();
    }

    @Override
    public devplugin.Date getCurrentDate() {
        return MainFrame.getInstance().getCurrentSelectedDate();
    }

    @Override
    public ProgramRatingIf[] getAllProgramRatingIfs() {
        ArrayList<ProgramRatingIf> ratingArray = new ArrayList<ProgramRatingIf>();
        ratingArray.add(new RatingFieldRating());
        for (PluginAccess access : this.getActivatedPlugins()) {
            ProgramRatingIf[] ratings = access.getProgramRatingIfs();
            if (ratings == null) continue;
            ratingArray.addAll(Arrays.asList(ratings));
        }
        return ratingArray.toArray(new ProgramRatingIf[ratingArray.size()]);
    }

    @Override
    public void deleteFileOnNextStart(String path) {
        Settings.Plugins.DELETE_FILES_AT_START.addItem(path);
    }

    @Override
    public boolean isDataAvailable(devplugin.Date date) {
        return TvDataBase.getInstance().dataAvailable(date);
    }

    @Override
    public boolean showBalloonTip(String caption, String message, TrayIcon.MessageType messageType) {
        return TVBrowser.showBalloonTip(caption, message, messageType);
    }

    @Override
    public Version getTVBrowserVersion() {
        return TVBrowser.VERSION;
    }

    @Override
    public JPopupMenu createRemovedProgramContextMenu(Program program) {
        return ContextMenuManager.getInstance().createRemovedProgramContextMenu(program);
    }

    @Override
    public boolean isTvBrowserStartFinished() {
        return this.mTvBrowserStartFinished;
    }

    @Override
    public ProgressMonitorExtended createProgressMonitor() {
        return (ProgressMonitorExtended)MainFrame.getInstance().createProgressMonitor();
    }

    @Override
    public JMenuItem getPluginContextMenu(Program program, String id) {
        return ContextMenuManager.getInstance().getPluginContextMenu(program, id);
    }

    @Override
    public PluginProgramInformation[] getProgramInformation(String informationKey, Program program) {
        PluginAccess[] plugins;
        ArrayList<PluginProgramInformation> result = new ArrayList<PluginProgramInformation>();
        for (PluginAccess plugin : plugins = this.getActivatedPlugins()) {
            try {
                PluginProgramInformation info = plugin.getProgramInformation(program, informationKey);
                if (info == null) continue;
                result.add(info);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Plugin with ID '" + plugin.getId() + "' caused error at getting ProgramInformation.", t);
            }
        }
        return result.toArray(new PluginProgramInformation[0]);
    }

    @Override
    public PluginProgramInformation getProgramInformationForPlugin(String pluginId, String informationKey, Program program) {
        PluginAccess plugin = this.getActivatedPluginForId(pluginId);
        PluginProgramInformation info = null;
        if (plugin != null) {
            try {
                info = plugin.getProgramInformation(program, informationKey);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Plugin with ID '" + plugin.getId() + "' caused error at getting ProgramInformation.", t);
            }
        }
        return info;
    }

    public static class RatingFieldRating
    implements ProgramRatingIf {
        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public Icon getIconForProgram(Program program) {
            return null;
        }

        @Override
        public String getName() {
            return "TV data rating";
        }

        @Override
        public int getRatingForProgram(Program program) {
            int rating = program.getIntField(ProgramFieldType.RATING_TYPE);
            if (rating >= 0) {
                return rating;
            }
            return 0;
        }

        @Override
        public boolean hasDetailsDialog() {
            return false;
        }

        @Override
        public void showDetailsFor(Program p) {
        }
    }
}

