/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.plugin;

import devplugin.CancelableSettingsTab;
import devplugin.SettingsTab;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JPanel;
import util.ui.FixedSizeIcon;

public class SettingsTabProxy {
    private static final Logger LOG = Logger.getLogger(SettingsTabProxy.class.getName());
    private SettingsTab mSettingsTab;

    public SettingsTabProxy(SettingsTab tab) {
        this.mSettingsTab = tab;
    }

    public JPanel createSettingsPanel() {
        try {
            return this.mSettingsTab.createSettingsPanel();
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Could not get settings panel", t);
            return null;
        }
    }

    public void saveSettings() {
        this.mSettingsTab.saveSettings();
    }

    public Icon getIcon() {
        try {
            Icon icon = this.mSettingsTab.getIcon();
            if (icon != null) {
                return new FixedSizeIcon(16, 16, icon);
            }
            return icon;
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Could not get settings icon", t);
            return null;
        }
    }

    public String getTitle() {
        try {
            return this.mSettingsTab.getTitle();
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Could not get settings panel title", t);
            return "";
        }
    }

    public void cancel() {
        try {
            if (this.mSettingsTab instanceof CancelableSettingsTab) {
                ((CancelableSettingsTab)this.mSettingsTab).cancel();
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Could not inform about closing", t);
        }
    }
}

