/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.ProgramReceiveIf;
import devplugin.ProgramReceiveTarget;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.dlgs.ExclusionPanel;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteTreeModel;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.ui.DefaultMarkingPrioritySelectionPanel;
import util.ui.EnhancedPanelBuilder;
import util.ui.PluginChooserDlg;
import util.ui.UiUtilities;

public class FavoritesSettingTab
implements SettingsTab {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(FavoritesSettingTab.class);
    private ProgramReceiveTarget[] mClientPluginTargets;
    private ProgramReceiveTarget[] mCurrentClientPluginTargets;
    private JLabel mPluginLabel;
    private JCheckBox mExpertMode;
    private JCheckBox mShowTypeSelection;
    private JCheckBox mShowRepetitions;
    private JCheckBox mAutoSelectRemider;
    private JCheckBox mProvideTab;
    private JCheckBox mShowDateSeparators;
    private JRadioButton mScrollTimeNext;
    private JRadioButton mScrollTimeDay;
    private JRadioButton mFilterStartAll;
    private JRadioButton mFilterStartDefault;
    private JRadioButton mFilterStartCurrent;
    private JRadioButton mFilterStartLast;
    private JCheckBox mFilterReactOnChange;
    private DefaultMarkingPrioritySelectionPanel mMarkingsPanel;
    private ExclusionPanel mExclusionPanel;

    @Override
    public JPanel createSettingsPanel() {
        EnhancedPanelBuilder builder = new EnhancedPanelBuilder(new FormLayout("5dlu,min(150dlu;pref):grow,5dlu,pref,5dlu"));
        builder.border(Borders.DIALOG);
        this.mPluginLabel = new JLabel();
        JButton choose = new JButton(LOCALIZER.msg("selectPlugins", "Choose Plugins"));
        this.mExpertMode = new JCheckBox(LOCALIZER.msg("expertMode", "Always show advanced favorite edit dialog"), FavoritesPlugin.getInstance().isUsingExpertMode());
        this.mShowTypeSelection = new JCheckBox(LOCALIZER.msg("showTypeSelection", "Show selection for creation of filter favorite"), FavoritesPlugin.getInstance().showTypeSelection());
        this.mShowTypeSelection.setEnabled(this.mExpertMode.isSelected());
        this.mShowRepetitions = new JCheckBox(LOCALIZER.msg("showRepetitions", "Show repetitions in context menu of a favorite program"), FavoritesPlugin.getInstance().isShowingRepetitions());
        this.mAutoSelectRemider = new JCheckBox(LOCALIZER.msg("autoSelectReminder", "Automatically remind of new favorite programs"), FavoritesPlugin.getInstance().isAutoSelectingReminder());
        this.mShowDateSeparators = new JCheckBox(LOCALIZER.msg("showDateSeparator", "Show date separator in found programs list"), FavoritesPlugin.getInstance().showDateSeparators());
        this.mProvideTab = new JCheckBox(LOCALIZER.msg("provideTab", "Provide tab in TV-Browser main window"), FavoritesPlugin.getInstance().provideTab());
        ProgramReceiveTarget[] targetsArr = FavoritesPlugin.getInstance().getClientPluginTargetIds();
        ArrayList<ProgramReceiveTarget> clientPlugins = new ArrayList<ProgramReceiveTarget>();
        for (ProgramReceiveTarget target : targetsArr) {
            ProgramReceiveIf plugin = target.getReceifeIfForIdOfTarget();
            if (plugin == null) continue;
            clientPlugins.add(target);
        }
        this.mClientPluginTargets = clientPlugins.toArray(new ProgramReceiveTarget[clientPlugins.size()]);
        this.mCurrentClientPluginTargets = this.mClientPluginTargets;
        this.mExpertMode.addItemListener(e -> this.mShowTypeSelection.setEnabled(e.getStateChange() == 1));
        this.handlePluginSelection();
        choose.addActionListener(e -> {
            Window parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
            PluginChooserDlg chooser = null;
            chooser = new PluginChooserDlg(parent, this.mClientPluginTargets, null, (ProgramReceiveIf)ReminderPluginProxy.getInstance());
            chooser.setVisible(true);
            if (chooser.getReceiveTargets() != null) {
                this.mClientPluginTargets = chooser.getReceiveTargets();
            }
            this.handlePluginSelection();
        });
        EnhancedPanelBuilder timeButtonSettings = new EnhancedPanelBuilder(new FormLayout("10dlu,default:grow"));
        JLabel timeButtonBehaviour = new JLabel(LOCALIZER.msg("timeButtonBehaviour", "Time buttons behaviour:"));
        this.mScrollTimeNext = new JRadioButton(LOCALIZER.msg("timeButtonScrollNext", "Scroll to next occurence of time from shown programs onward"), FavoritesPlugin.getInstance().timeButtonsScrollToNextTimeInTab());
        this.mScrollTimeDay = new JRadioButton(LOCALIZER.msg("timeButtonScrollDay", "Scroll to occurence of time on shown day in list"), !this.mScrollTimeNext.isSelected());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.mScrollTimeDay);
        bg.add(this.mScrollTimeNext);
        timeButtonBehaviour.setEnabled(this.mProvideTab.isSelected());
        this.mScrollTimeDay.setEnabled(this.mProvideTab.isSelected());
        this.mScrollTimeNext.setEnabled(this.mProvideTab.isSelected());
        this.mProvideTab.addItemListener(e -> {
            timeButtonBehaviour.setEnabled(e.getStateChange() == 1);
            this.mScrollTimeDay.setEnabled(timeButtonBehaviour.isEnabled());
            this.mScrollTimeNext.setEnabled(timeButtonBehaviour.isEnabled());
        });
        timeButtonSettings.addRow(timeButtonBehaviour, 2);
        timeButtonSettings.addRow(this.mScrollTimeNext, 2);
        timeButtonSettings.addRow(this.mScrollTimeDay, 2);
        int filterStartType = FavoritesPlugin.getInstance().getFilterStartType();
        EnhancedPanelBuilder filterSettingsPanel = new EnhancedPanelBuilder(new FormLayout("10dlu,default:grow"));
        this.mFilterStartAll = new JRadioButton(LOCALIZER.msg("filterStartAll", "Show all filter"), filterStartType == 0);
        this.mFilterStartDefault = new JRadioButton(LOCALIZER.msg("filterStartDefault", "Default filter"), filterStartType == 1);
        this.mFilterStartCurrent = new JRadioButton(LOCALIZER.msg("filterStartCurrent", "Current TV-Browser filter"), filterStartType == 2);
        this.mFilterStartLast = new JRadioButton(LOCALIZER.msg("filterStartLast", "Last used filter"), filterStartType == -1);
        ButtonGroup filterStartGroup = new ButtonGroup();
        filterStartGroup.add(this.mFilterStartAll);
        filterStartGroup.add(this.mFilterStartDefault);
        filterStartGroup.add(this.mFilterStartCurrent);
        filterStartGroup.add(this.mFilterStartLast);
        this.mFilterReactOnChange = new JCheckBox(LOCALIZER.msg("filterReactOnChange", "React on changes of selected filter of TV-Browser"), FavoritesPlugin.getInstance().reactOnFilterChange());
        filterSettingsPanel.addLabelRowFull(false, LOCALIZER.msg("filterStart", "Start with:"));
        filterSettingsPanel.addRow("2dlu,default", (Component)this.mFilterStartAll, 2);
        filterSettingsPanel.addRow("1dlu,default", (Component)this.mFilterStartDefault, 2);
        filterSettingsPanel.addRow("1dlu,default", (Component)this.mFilterStartCurrent, 2);
        filterSettingsPanel.addRow("1dlu,default", (Component)this.mFilterStartLast, 2);
        filterSettingsPanel.addRowFull("3dlu,default", (Component)this.mFilterReactOnChange);
        builder.addSeparatorRowFull(false, LOCALIZER.msg("passTo", "Pass favorite programs to"));
        builder.addRow(this.mPluginLabel, 2);
        builder.add(choose, 4);
        builder.addParagraph(LOCALIZER.msg("expertSettings", "Expert mode"));
        builder.addRowFull(this.mExpertMode, 2);
        builder.addRowFull(false, (Component)this.mShowTypeSelection, 2);
        builder.addParagraph(LOCALIZER.msg("repetitionSettings", "Repetitions"));
        builder.addRowFull(this.mShowRepetitions, 2);
        builder.addParagraph(LOCALIZER.msg("reminderSettings", "Automatic reminder"));
        builder.addRowFull(this.mAutoSelectRemider, 2);
        builder.addParagraph(LOCALIZER.msg("exclusions", "Global exclusion criterions"));
        this.mExclusionPanel = new ExclusionPanel(FavoritesPlugin.getInstance().getGlobalExclusions(), UiUtilities.getLastModalChildOf(MainFrame.getInstance()), null);
        builder.addRowFull(this.mExclusionPanel, 2);
        builder.addParagraph(LOCALIZER.msg("miscSettings", "Miscellaneous"));
        builder.addRowFull(this.mShowDateSeparators, 2);
        builder.addRowFull(false, (Component)this.mProvideTab, 2);
        builder.addRowFull(false, (Component)timeButtonSettings.getPanel(), 2);
        builder.addParagraph(LOCALIZER.msg("filter", "Program Filter"));
        builder.addRowFull(filterSettingsPanel.getPanel(), 2);
        builder.addParagraph(DefaultMarkingPrioritySelectionPanel.getTitle());
        this.mMarkingsPanel = DefaultMarkingPrioritySelectionPanel.createPanel(FavoritesPlugin.getInstance().getMarkPriority(), false, false);
        builder.addRowFull(this.mMarkingsPanel, 2);
        return builder.getPanel();
    }

    private void handlePluginSelection() {
        ArrayList<ProgramReceiveIf> plugins = new ArrayList<ProgramReceiveIf>();
        if (this.mClientPluginTargets != null) {
            for (ProgramReceiveTarget element : this.mClientPluginTargets) {
                if (plugins.contains(element.getReceifeIfForIdOfTarget())) continue;
                plugins.add(element.getReceifeIfForIdOfTarget());
            }
            ProgramReceiveIf[] mClientPlugins = plugins.toArray(new ProgramReceiveIf[plugins.size()]);
            if (mClientPlugins.length > 0) {
                this.mPluginLabel.setText(mClientPlugins[0].toString());
                this.mPluginLabel.setEnabled(true);
            } else {
                this.mPluginLabel.setText(LOCALIZER.msg("noPlugins", "No Plugins choosen"));
                this.mPluginLabel.setEnabled(false);
            }
            for (int i = 1; i < (mClientPlugins.length > 4 ? 3 : mClientPlugins.length); ++i) {
                this.mPluginLabel.setText(this.mPluginLabel.getText() + ", " + mClientPlugins[i]);
            }
            if (mClientPlugins.length > 4) {
                this.mPluginLabel.setText(this.mPluginLabel.getText() + " (" + (mClientPlugins.length - 3) + " " + LOCALIZER.ellipsisMsg("otherPlugins", "others") + ")");
            }
        }
    }

    @Override
    public void saveSettings() {
        if (!Arrays.equals(this.mCurrentClientPluginTargets, this.mClientPluginTargets)) {
            Favorite[] favoriteArr;
            FavoritesPlugin.getInstance().setClientPluginTargets(this.mClientPluginTargets);
            for (Favorite favorite : favoriteArr = FavoriteTreeModel.getInstance().getFavoriteArr()) {
                favorite.handleNewGlobalReceiveTargets(this.mCurrentClientPluginTargets);
            }
        }
        FavoritesPlugin.getInstance().setIsUsingExpertMode(this.mExpertMode.isSelected());
        FavoritesPlugin.getInstance().setShowTypeSelection(this.mShowTypeSelection.isSelected());
        FavoritesPlugin.getInstance().setShowRepetitions(this.mShowRepetitions.isSelected());
        FavoritesPlugin.getInstance().setAutoSelectingReminder(this.mAutoSelectRemider.isSelected());
        FavoritesPlugin.getInstance().setMarkPriority(this.mMarkingsPanel.getSelectedPriority());
        FavoritesPlugin.getInstance().setShowDateSeparators(this.mShowDateSeparators.isSelected());
        FavoritesPlugin.getInstance().setProvideTab(this.mProvideTab.isSelected());
        FavoritesPlugin.getInstance().setTimeButtonsScrollToNextTimeInTab(this.mScrollTimeNext.isSelected());
        FavoritesPlugin.getInstance().setReactOnFilterChange(this.mFilterReactOnChange.isSelected());
        if (this.mFilterStartAll.isSelected()) {
            FavoritesPlugin.getInstance().setFilterStartType(0);
        } else if (this.mFilterStartDefault.isSelected()) {
            FavoritesPlugin.getInstance().setFilterStartType(1);
        } else if (this.mFilterStartCurrent.isSelected()) {
            FavoritesPlugin.getInstance().setFilterStartType(2);
        } else if (this.mFilterStartLast.isSelected()) {
            FavoritesPlugin.getInstance().setFilterStartType(-1);
        }
        if (this.mExclusionPanel.wasChanged()) {
            FavoritesPlugin.getInstance().setGlobalExclusions(this.mExclusionPanel.getExclusions(), this.mExclusionPanel.wasAdded() && !this.mExclusionPanel.wasEditedOrDeleted());
        } else {
            FavoritesPlugin.getInstance().saveFavorites();
        }
    }

    @Override
    public Icon getIcon() {
        return FavoritesPlugin.getFavoritesIcon(16);
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("name", "Favorite programs");
    }
}

