/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.programinfo;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import com.l2fprod.common.swing.plaf.LookAndFeelAddons;
import devplugin.Plugin;
import devplugin.PluginAccess;
import devplugin.ProgramReceiveTarget;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.extras.programinfo.ProgramInfo;
import tvbrowser.extras.programinfo.ProgramInfoDialog;
import tvbrowser.extras.programinfo.ProgramInfoSettings;
import tvbrowser.ui.settings.util.ColorButton;
import tvbrowser.ui.settings.util.ColorLabel;
import util.i18n.Localizer;
import util.program.ProgramTextCreator;
import util.ui.EnhancedPanelBuilder;
import util.ui.FontChooserPanel;
import util.ui.OrderChooser;
import util.ui.PluginsPictureSettingsPanel;
import util.ui.ScrollableJPanel;

public class ProgramInfoSettingsTab
implements SettingsTab {
    private OrderChooser<Object> mList;
    private Object[] mOldOrder;
    private JCheckBox mShowShortDescriptionOnlyWhenNoDescription;
    private boolean mOldSetupState;
    private PluginsPictureSettingsPanel mPictureSettings;
    private JCheckBox mZoomEnabled;
    private JSpinner mZoomValue;
    private JCheckBox mUserFont;
    private JCheckBox mAntiAliasing;
    private FontChooserPanel mTitleFont;
    private FontChooserPanel mBodyFont;
    private String mOldTitleFont;
    private String mOldBodyFont;
    private int mOldTitleFontSize;
    private int mOldBodyFontSize;
    private boolean mOldUserFontSelected;
    private boolean mOldAntiAliasingSelected;
    private boolean mOldShowFunctions;
    private String mOldLook;
    private JComboBox<String> mLook;
    private static int mCurrentTab = 0;
    private JTabbedPane mTabbedPane;
    private String[] mLf = new String[]{"com.l2fprod.common.swing.plaf.aqua.AquaLookAndFeelAddons", "com.l2fprod.common.swing.plaf.metal.MetalLookAndFeelAddons", "com.l2fprod.common.swing.plaf.motif.MotifLookAndFeelAddons", "com.l2fprod.common.swing.plaf.windows.WindowsLookAndFeelAddons", "com.l2fprod.common.swing.plaf.windows.WindowsClassicLookAndFeelAddons"};
    private JCheckBox mShowFunctions;
    private JCheckBox mShowTextSearchButton;
    private ButtonGroup mAvailableTargetGroup;
    private JCheckBox mPersonSearchCB;
    private JCheckBox mHighlight;
    private ColorLabel mHighlightColorLb;
    private ColorButton mHighlightButton;
    private int mOldTitleStyle;
    private int mOldBodyStyle;

    @Override
    public JPanel createSettingsPanel() {
        ProgramReceiveTarget[] targets;
        ProgramInfoSettings settings = ProgramInfo.getInstance().getSettings();
        this.mOldAntiAliasingSelected = settings.getAntialiasing();
        this.mOldUserFontSelected = settings.getUserFont();
        this.mOldTitleFontSize = settings.getTitleFontSize();
        this.mOldBodyFontSize = settings.getBodyFontSize();
        this.mOldTitleFont = settings.getTitleFontName();
        this.mOldBodyFont = settings.getBodyFontName();
        this.mOldTitleStyle = settings.getTitleFontStyle();
        this.mOldBodyStyle = settings.getBodyFontStyle();
        this.mAntiAliasing = new JCheckBox(ProgramInfo.LOCALIZER.msg("antialiasing", "Antialiasing"));
        this.mAntiAliasing.setSelected(this.mOldAntiAliasingSelected);
        this.mUserFont = new JCheckBox(ProgramInfo.LOCALIZER.msg("userfont", "Use user fonts"));
        this.mUserFont.setSelected(this.mOldUserFontSelected);
        this.mTitleFont = new FontChooserPanel(null, new Font(this.mOldTitleFont, this.mOldTitleStyle, this.mOldTitleFontSize), true);
        this.mTitleFont.setBorder(BorderFactory.createEmptyBorder());
        this.mTitleFont.setAlignmentX(0.0f);
        this.mBodyFont = new FontChooserPanel(null, new Font(this.mOldBodyFont, this.mOldBodyStyle, this.mOldBodyFontSize), true);
        this.mBodyFont.setBorder(BorderFactory.createEmptyBorder());
        this.mBodyFont.setAlignmentX(0.0f);
        this.mTitleFont.setEnabled(this.mUserFont.isSelected());
        this.mBodyFont.setEnabled(this.mUserFont.isSelected());
        this.mOldLook = settings.getLook();
        String[] lf = new String[]{"Aqua", "Metal", "Motif", "Windows XP", "Windows Classic"};
        this.mLook = new JComboBox<String>(lf);
        String look = this.mOldLook.length() > 0 ? this.mOldLook : LookAndFeelAddons.getBestMatchAddonClassName();
        for (int i = 0; i < this.mLf.length; ++i) {
            if (look.toLowerCase().indexOf(this.mLf[i].toLowerCase()) == -1) continue;
            this.mLook.setSelectedIndex(i);
            break;
        }
        this.mOldShowFunctions = settings.getShowFunctions();
        this.mShowFunctions = new JCheckBox(ProgramInfo.LOCALIZER.msg("showFunctions", "Show Functions"), settings.getShowFunctions());
        this.mShowTextSearchButton = new JCheckBox(ProgramInfo.LOCALIZER.msg("showTextSearchButton", "Show \"Search in program\""), ProgramInfo.getInstance().getSettings().getShowSearchButton());
        this.mShowTextSearchButton.setEnabled(this.mShowFunctions.isSelected());
        this.mShowFunctions.addActionListener(e -> this.mShowTextSearchButton.setEnabled(this.mShowFunctions.isSelected()));
        this.mHighlight = new JCheckBox(ProgramInfoDialog.mLocalizer.msg("highlight", "Highlight favorite matches"), settings.getHighlightFavorite());
        this.mHighlight.addActionListener(e -> {
            this.mHighlightColorLb.setEnabled(this.mHighlight.isSelected());
            this.mHighlightButton.setEnabled(this.mHighlight.isSelected());
        });
        EnhancedPanelBuilder formatPanel = new EnhancedPanelBuilder(new FormLayout("5dlu,10dlu,pref,pref,5dlu,default:grow,pref,5dlu"));
        formatPanel.border(Borders.DIALOG);
        formatPanel.addParagraph(ProgramInfo.LOCALIZER.msg("font", "Font settings"));
        formatPanel.addRowFull(this.mAntiAliasing, 2);
        formatPanel.addRowFull(this.mUserFont, 2);
        JLabel titleLabel = formatPanel.addLabelRow(ProgramInfo.LOCALIZER.msg("title", "Title font"), 3);
        formatPanel.add(this.mTitleFont, 6, 2);
        JLabel bodyLabel = formatPanel.addLabelRow(ProgramInfo.LOCALIZER.msg("body", "Description font"), 3);
        formatPanel.add(this.mBodyFont, 6, 2);
        this.mUserFont.addChangeListener(e -> {
            this.mTitleFont.setEnabled(this.mUserFont.isSelected());
            this.mBodyFont.setEnabled(this.mUserFont.isSelected());
            titleLabel.setEnabled(this.mUserFont.isSelected());
            bodyLabel.setEnabled(this.mUserFont.isSelected());
        });
        this.mTitleFont.setEnabled(this.mUserFont.isSelected());
        this.mBodyFont.setEnabled(this.mUserFont.isSelected());
        titleLabel.setEnabled(this.mUserFont.isSelected());
        bodyLabel.setEnabled(this.mUserFont.isSelected());
        formatPanel.addParagraph(ProgramInfo.LOCALIZER.msg("design", "Design"));
        formatPanel.addRow(this.mLook, 2, 2);
        formatPanel.addParagraph(ProgramInfoDialog.mLocalizer.msg("functions", "Functions"));
        formatPanel.addRow(this.mShowFunctions, 2, formatPanel.getColumnCount() - 2);
        formatPanel.addRow(this.mShowTextSearchButton, 3, formatPanel.getColumnCount() - 3);
        formatPanel.addParagraph(ProgramInfo.LOCALIZER.msg("favorites", "Favorites"));
        formatPanel.addRow(this.mHighlight, 2, 5);
        JPanel panel = new JPanel(new FlowLayout());
        this.mHighlightColorLb = new ColorLabel(settings.getHighlightColor());
        panel.add(this.mHighlightColorLb);
        this.mHighlightColorLb.setStandardColor(settings.getHighlightColor());
        this.mHighlightButton = new ColorButton(this.mHighlightColorLb);
        panel.add(this.mHighlightButton);
        this.mHighlight.getActionListeners()[0].actionPerformed(null);
        formatPanel.add(panel, 7);
        this.mOldOrder = settings.getFieldOrder();
        this.mOldSetupState = ProgramInfo.getInstance().getSettings().getSetupwasdone();
        this.mList = new OrderChooser<Object>(this.mOldOrder, ProgramTextCreator.getDefaultOrderWithActivatedPluginInfo(), true);
        this.mShowShortDescriptionOnlyWhenNoDescription = new JCheckBox(ProgramInfo.LOCALIZER.msg("showShortDescriptionOnlyWhenNoDescription", "Show short description only, if no long description exists"), settings.getShowShortDescriptionOnlyWithoutDescription());
        JButton previewBtn = new JButton(ProgramInfo.LOCALIZER.msg("preview", "Preview"));
        previewBtn.addActionListener(e -> {
            this.saveSettings();
            ProgramInfo.getInstance().showProgramInformation(Plugin.getPluginManager().getExampleProgram(), false);
            this.restoreSettings();
        });
        JButton defaultBtn = new JButton(ProgramInfo.LOCALIZER.msg("default", "Default"));
        defaultBtn.addActionListener(e -> this.resetSettings());
        EnhancedPanelBuilder orderPanel = new EnhancedPanelBuilder("default:grow");
        orderPanel.border(Borders.DIALOG);
        orderPanel.addRowFull(this.mShowShortDescriptionOnlyWhenNoDescription);
        orderPanel.addGrowingRowFull(this.mList);
        EnhancedPanelBuilder picturePanel = new EnhancedPanelBuilder("default:grow");
        picturePanel.border(Borders.DIALOG);
        this.mPictureSettings = new PluginsPictureSettingsPanel(ProgramInfo.getInstance().getPictureSettings(), false);
        picturePanel.addRowFull(this.mPictureSettings);
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("default,2dlu,default,5dlu,default", "default"));
        this.mZoomEnabled = new JCheckBox(ProgramInfo.LOCALIZER.msg("scaleImage", "Scale picture:"), ProgramInfo.getInstance().getSettings().getZoomEnabled());
        pb.add(this.mZoomEnabled, 1);
        this.mZoomValue = new JSpinner(new SpinnerNumberModel(ProgramInfo.getInstance().getSettings().getZoomValue(), 50, 300, 1));
        pb.add(this.mZoomValue, 3);
        JLabel label = pb.labelAdd("%", 5);
        this.mZoomEnabled.addItemListener(e -> {
            this.mZoomValue.setEnabled(this.mZoomEnabled.isSelected());
            label.setEnabled(this.mZoomEnabled.isSelected());
        });
        this.mZoomValue.setEnabled(this.mZoomEnabled.isSelected());
        label.setEnabled(this.mZoomEnabled.isSelected());
        picturePanel.addRowFull(pb.getPanel());
        PluginAccess webPlugin = PluginManagerImpl.getInstance().getActivatedPluginForId("java.webplugin.WebPlugin");
        this.mAvailableTargetGroup = new ButtonGroup();
        ArrayList<InternalRadioButton<Object>> availableDefaultTargets = new ArrayList<InternalRadioButton<Object>>();
        availableDefaultTargets.add(new InternalRadioButton<String>(ProgramInfoDialog.mLocalizer.msg("searchTvBrowser", "Search in TV-Browser")));
        this.mAvailableTargetGroup.add((AbstractButton)availableDefaultTargets.get(0));
        availableDefaultTargets.add(new InternalRadioButton<String>(ProgramInfoDialog.mLocalizer.msg("searchWikipedia", "Search in Wikipedia")));
        this.mAvailableTargetGroup.add((AbstractButton)availableDefaultTargets.get(1));
        String currentValue = settings.getActorSearch();
        int selectedIndex = -1;
        if (webPlugin != null && webPlugin.canReceiveProgramsWithTarget() && (targets = webPlugin.getProgramReceiveTargets()) != null) {
            for (ProgramReceiveTarget target : targets) {
                availableDefaultTargets.add(new InternalRadioButton<ProgramReceiveTarget>(target));
                this.mAvailableTargetGroup.add((AbstractButton)availableDefaultTargets.get(availableDefaultTargets.size() - 1));
                if (!currentValue.equals(target.getReceiveIfId() + "#_#_#" + target.getTargetId())) continue;
                selectedIndex = availableDefaultTargets.size() - 1;
            }
        }
        if (selectedIndex == -1) {
            selectedIndex = currentValue.equals("internalSearch") ? 0 : 1;
        }
        ((InternalRadioButton)availableDefaultTargets.get(selectedIndex)).setSelected(true);
        ScrollableJPanel buttonPanel = new ScrollableJPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.setOpaque(false);
        for (InternalRadioButton internalRadioButton : availableDefaultTargets) {
            buttonPanel.add(internalRadioButton);
        }
        JScrollPane scrollPane = new JScrollPane(buttonPanel);
        scrollPane.setBackground(UIManager.getDefaults().getColor("List.background"));
        scrollPane.getViewport().setBackground(UIManager.getDefaults().getColor("List.background"));
        EnhancedPanelBuilder enhancedPanelBuilder = new EnhancedPanelBuilder(new FormLayout("default:grow"));
        enhancedPanelBuilder.border(Borders.DIALOG);
        this.mPersonSearchCB = new JCheckBox(ProgramInfo.LOCALIZER.msg("enableSearch", "Show person names as links to person search"));
        enhancedPanelBuilder.addRowFull(this.mPersonSearchCB);
        JLabel searchLabel = enhancedPanelBuilder.addLabelRow("3dlu,default", ProgramInfo.LOCALIZER.msg("defaultActorSearchMethod", "Default search method:"));
        enhancedPanelBuilder.addRowFull("1dlu,fill:default:grow", (Component)scrollPane);
        this.mPersonSearchCB.addActionListener(e -> {
            scrollPane.setEnabled(this.mPersonSearchCB.isSelected());
            searchLabel.setEnabled(this.mPersonSearchCB.isSelected());
            for (InternalRadioButton button : availableDefaultTargets) {
                button.setEnabled(this.mPersonSearchCB.isSelected());
            }
        });
        this.mPersonSearchCB.setSelected(settings.getEnableSearch());
        this.mPersonSearchCB.getActionListeners()[0].actionPerformed(null);
        this.mTabbedPane = new JTabbedPane();
        this.mTabbedPane.add(ProgramInfo.LOCALIZER.msg("look", "Look"), formatPanel.getPanel());
        this.mTabbedPane.add(ProgramInfo.LOCALIZER.msg("fields", "Fields"), orderPanel.getPanel());
        this.mTabbedPane.add(Localizer.getLocalization("i18n_pictures"), picturePanel.getPanel());
        this.mTabbedPane.add(ProgramInfo.LOCALIZER.msg("actorSearch", "Actor search"), enhancedPanelBuilder.getPanel());
        this.mTabbedPane.setSelectedIndex(mCurrentTab);
        formatPanel.getPanel().setOpaque(true);
        orderPanel.getPanel().setOpaque(true);
        picturePanel.getPanel().setOpaque(true);
        enhancedPanelBuilder.getPanel().setOpaque(true);
        FormLayout layout = new FormLayout("default,default:grow,default", "pref");
        layout.setColumnGroups((int[][])new int[][]{{1, 3}});
        JPanel buttonPn = new JPanel((LayoutManager)layout);
        buttonPn.add((Component)previewBtn, CC.xy((int)3, (int)1));
        buttonPn.add((Component)defaultBtn, CC.xy((int)1, (int)1));
        JPanel base = new JPanel((LayoutManager)new FormLayout("default:grow", "fill:default:grow,10dlu,default"));
        base.setBorder(Borders.DIALOG);
        base.add((Component)this.mTabbedPane, CC.xy((int)1, (int)1));
        base.add((Component)buttonPn, CC.xy((int)1, (int)3));
        return base;
    }

    private void resetSettings() {
        this.mList.setOrder((Object[])ProgramTextCreator.getDefaultOrderWithActivatedPluginInfo(), (Object[])ProgramTextCreator.getDefaultOrderWithActivatedPluginInfo());
        this.mAntiAliasing.setSelected(false);
        this.mUserFont.setSelected(false);
        this.mZoomEnabled.setSelected(false);
        this.mZoomValue.setValue(100);
        String look = LookAndFeelAddons.getBestMatchAddonClassName();
        for (int i = 0; i < this.mLf.length; ++i) {
            if (look.toLowerCase().indexOf(this.mLf[i].toLowerCase()) == -1) continue;
            this.mLook.setSelectedIndex(i);
            break;
        }
    }

    @Override
    public void saveSettings() {
        mCurrentTab = this.mTabbedPane.getSelectedIndex();
        try {
            ProgramInfoSettings settings = ProgramInfo.getInstance().getSettings();
            settings.setZoomEnabled(this.mZoomEnabled.isSelected());
            settings.setZoomValue((Integer)this.mZoomValue.getValue());
            settings.setShowShortDescriptionOnlyWithoutDescription(this.mShowShortDescriptionOnlyWhenNoDescription.isSelected());
            List<Object> order = this.mList.getOrderList();
            settings.setFieldOrder(order.toArray(new Object[order.size()]));
            settings.setSetupwasdone(true);
            settings.setPictureSettings(this.mPictureSettings.getSettings().getType());
            ProgramInfo.getInstance().setOrder();
            settings.setAntialiasing(this.mAntiAliasing.isSelected());
            settings.setUserFont(this.mUserFont.isSelected());
            Font f = this.mTitleFont.getChosenFont();
            settings.setTitleFontName(f.getFamily());
            settings.setTitleFontSize(f.getSize());
            settings.setTitleFontStyle(f.getStyle());
            f = this.mBodyFont.getChosenFont();
            settings.setBodyFontName(f.getFamily());
            settings.setBodyFontSize(f.getSize());
            settings.setBodyFontStyle(f.getStyle());
            settings.setLook(this.mLf[this.mLook.getSelectedIndex()]);
            ProgramInfo.getInstance().setLook();
            if (this.mShowFunctions != null) {
                settings.setShowFunctions(this.mShowFunctions.isSelected());
                if (this.mShowFunctions.isSelected() != this.mOldShowFunctions) {
                    ProgramInfoDialog.recreateInstance();
                }
            }
            if (this.mShowTextSearchButton != null) {
                settings.setShowSearchButton(this.mShowTextSearchButton.isSelected());
            }
            settings.setHighlightFavorite(this.mHighlight.isSelected());
            settings.setHighlightColor(this.mHighlightColorLb.getColor());
            Enumeration<AbstractButton> actorSearchDefault = this.mAvailableTargetGroup.getElements();
            while (actorSearchDefault.hasMoreElements()) {
                AbstractButton button = actorSearchDefault.nextElement();
                if (!button.isSelected()) continue;
                settings.setActorSearch(((InternalRadioButton)button).getValue());
                break;
            }
            settings.setEnableSearch(this.mPersonSearchCB.isSelected());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void restoreSettings() {
        ProgramInfoSettings settings = ProgramInfo.getInstance().getSettings();
        settings.setSetupwasdone(this.mOldSetupState);
        settings.setFieldOrder(this.mOldOrder);
        ProgramInfo.getInstance().setOrder();
        settings.setAntialiasing(this.mOldAntiAliasingSelected);
        settings.setUserFont(this.mOldUserFontSelected);
        settings.setTitleFontName(this.mOldTitleFont);
        settings.setTitleFontSize(this.mOldTitleFontSize);
        settings.setBodyFontName(this.mOldBodyFont);
        settings.setBodyFontSize(this.mOldBodyFontSize);
        settings.setTitleFontStyle(this.mOldTitleStyle);
        settings.setBodyFontStyle(this.mOldBodyStyle);
        settings.setLook(this.mOldLook);
        ProgramInfo.getInstance().setLook();
        settings.setShowFunctions(this.mOldShowFunctions);
        ProgramInfoDialog.recreateInstance();
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("actions", "edit-find", 16);
    }

    @Override
    public String getTitle() {
        return ProgramInfo.getInstance().toString();
    }

    private static class InternalRadioButton<T>
    extends JRadioButton {
        private T mValue;

        protected InternalRadioButton(T value) {
            super(value.toString());
            this.mValue = value;
            this.setOpaque(false);
        }

        protected String getValue() {
            if (this.mValue instanceof String) {
                if (this.mValue.equals(ProgramInfoDialog.mLocalizer.msg("searchTvBrowser", "Search in TV-Browser"))) {
                    return "internalSearch";
                }
                return "internalWikipedia";
            }
            if (this.mValue instanceof ProgramReceiveTarget) {
                ProgramReceiveTarget target = (ProgramReceiveTarget)this.mValue;
                return target.getReceiveIfId() + "#_#_#" + target.getTargetId();
            }
            return "internalWikipedia";
        }
    }
}

