/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.configassistant;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tvbrowser.core.ChannelList;
import tvbrowser.core.tvdataservice.ChannelGroupManager;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import tvbrowser.ui.configassistant.AbstractCardPanel;
import tvbrowser.ui.configassistant.PrevNextButtons;
import tvbrowser.ui.configassistant.StatusPanel;
import tvbrowser.ui.mainframe.MainFrame;
import tvdataservice.SettingsPanel;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;
import util.ui.ScrollableJPanel;
import util.ui.UiUtilities;
import util.ui.progress.Progress;
import util.ui.progress.ProgressWindow;

class AuthenticationChannelCardPanel
extends AbstractCardPanel {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(AuthenticationChannelCardPanel.class);
    private JPanel mContent;
    private ArrayList<SettingsPanel> mSettingsPanelList;
    private JScrollPane mScrollPane;

    public AuthenticationChannelCardPanel(PrevNextButtons btns) {
        super(btns);
    }

    public void createPanel() {
        TvDataServiceProxy[] tvDataServices;
        this.mSettingsPanelList = new ArrayList(0);
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("5dlu,default:grow,5dlu"), (JPanel)new ScrollableJPanel());
        for (TvDataServiceProxy dataService : tvDataServices = TvDataServiceProxyManager.getInstance().getDataServices()) {
            SettingsPanel panel = dataService.getAuthenticationPanel();
            if (panel == null) continue;
            this.mSettingsPanelList.add(panel);
            JComponent x = pb.addParagraph(dataService.getInfo().getName());
            try {
                Method getFont = x.getComponent(0).getClass().getMethod("getFont", new Class[0]);
                Method setFont = x.getComponent(0).getClass().getMethod("setFont", Font.class);
                Font f = (Font)getFont.invoke((Object)x.getComponent(0), new Object[0]);
                f = f.deriveFont(1);
                setFont.invoke((Object)x.getComponent(0), f);
            }
            catch (Exception exception) {
                // empty catch block
            }
            pb.addGrowingRow(panel, 2);
        }
        this.mContent = new JPanel((LayoutManager)new FormLayout("15dlu,default:grow,15dlu", "default,15dlu,default,5dlu,fill:0dlu:grow,5dlu,default,15dlu"));
        this.mContent.add((Component)new StatusPanel(1), CC.xyw((int)1, (int)1, (int)3));
        this.mContent.add((Component)UiUtilities.createHtmlHelpTextArea(mLocalizer.msg("info1", "<div style=\"font-weight:bold;\">Some TV data sources need authentication. You need to enter the authentication data if you want to get TV data for the channels of the shown TV data sources.</div>")), CC.xy((int)2, (int)3));
        this.mScrollPane = new JScrollPane(pb.getPanel());
        this.mScrollPane.setBorder(null);
        this.mScrollPane.setViewportBorder(null);
        this.mScrollPane.getViewport().setOpaque(false);
        this.mContent.add((Component)this.mScrollPane, CC.xy((int)2, (int)5));
        this.mContent.add((Component)UiUtilities.createHtmlHelpTextArea(mLocalizer.msg("info2", "<div style=\"color:green;font-weight:bold;font-size:medium;\">If you don't need the channels of the listed TV data sources you can skip to the next step.</div>")), CC.xy((int)2, (int)7));
    }

    @Override
    public JPanel getPanel() {
        return this.mContent;
    }

    @Override
    public boolean onNext() {
        for (SettingsPanel panel : this.mSettingsPanelList) {
            panel.ok();
        }
        final ProgressWindow win = new ProgressWindow(MainFrame.getInstance());
        win.run(new Progress(){

            @Override
            public void run() {
                ChannelGroupManager.getInstance().checkForAvailableGroupsAndChannels(win);
            }
        });
        ChannelList.reload();
        ChannelList.initSubscribedChannels();
        return true;
    }

    @Override
    public boolean onPrev() {
        for (SettingsPanel panel : this.mSettingsPanelList) {
            panel.ok();
        }
        return true;
    }

    @Override
    public void onShow() {
        super.onShow();
        this.mScrollPane.getVerticalScrollBar().setValue(0);
    }

    public boolean isNeeded() {
        return !this.mSettingsPanelList.isEmpty();
    }
}

