/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.CancelableSettingsTab;
import devplugin.Marker;
import devplugin.Plugin;
import devplugin.PluginAccess;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.HyperlinkEvent;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.GenericFilterMap;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.core.plugin.ButtonActionIf;
import tvbrowser.extras.favoritesplugin.FavoritesPluginProxy;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import tvbrowser.ui.filter.dlgs.EditFilterDlg;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.settings.AbstractSettingsTab;
import tvbrowser.ui.settings.SettingsDialog;
import util.i18n.Localizer;
import util.settings.PluginPictureSettings;
import util.settings.ProgramPanelSettings;
import util.ui.CaretPositionCorrector;
import util.ui.EnhancedPanelBuilder;
import util.ui.MarkerChooserDlg;
import util.ui.PluginsPictureSettingsPanel;
import util.ui.UiUtilities;

public class PictureSettingsTab
extends AbstractSettingsTab
implements CancelableSettingsTab {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(PictureSettingsTab.class);
    private JRadioButton mShowPicturesEver;
    private JRadioButton mShowPicturesNever;
    private JRadioButton mShowPicturesForSelection;
    private JRadioButton mShowPicturesForFilter;
    private JCheckBox mShowPicturesInTimeRange;
    private JCheckBox mShowPicturesForDuration;
    private JCheckBox mShowPicturesForPlugins;
    private JSpinner mPictureStartTime;
    private JSpinner mPictureEndTime;
    private JSpinner mDuration;
    private JLabel mStartLabel;
    private JLabel mEndLabel;
    private JCheckBox mShowDescription;
    private JCheckBox mShowPictureBorderProgramTable;
    private JLabel mPluginLabel;
    private Marker[] mClientPlugins;
    private JButton choose;
    private PluginsPictureSettingsPanel mPluginsPictureSettings;
    private JSpinner mDescriptionLines;
    private JLabel mDescriptionLabel;
    private static int PLUGIN_PICTURE_SELECTION_ORIGINAL = -1;
    private long mLastPluginSelectionHandling = 0L;

    @Override
    public JPanel createSettingsPanel() {
        try {
            this.mShowPicturesNever = new JRadioButton(LOCALIZER.msg("showNever", "Show never"), Settings.Pictures.TYPE.getInt() == 0);
            this.mShowPicturesEver = new JRadioButton(LOCALIZER.msg("showEver", "Show always"), Settings.Pictures.TYPE.getInt() == 1);
            this.mShowPicturesForSelection = new JRadioButton(LOCALIZER.msg("showForSelection", "Selection..."), Settings.Pictures.TYPE.getInt() > 1 && Settings.Pictures.TYPE.getInt() < 10);
            this.mShowPicturesForFilter = new JRadioButton(LOCALIZER.msg("showForFilter", "For filter..."), Settings.Pictures.TYPE.getInt() == 10);
            this.mShowPicturesInTimeRange = new JCheckBox(LOCALIZER.msg("showInTimeRange", "Show in time range:"), ProgramPanelSettings.typeContainsType(Settings.Pictures.TYPE.getInt(), 2));
            this.mShowPicturesForDuration = new JCheckBox(LOCALIZER.msg("showForDuration", "Show for duration more than or equals to:"), ProgramPanelSettings.typeContainsType(Settings.Pictures.TYPE.getInt(), 4));
            this.mShowPictureBorderProgramTable = new JCheckBox(LOCALIZER.msg("showPictureBorder", "Show border around picture"), Settings.Pictures.BORDER_SHOW.getBoolean());
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.mShowPicturesEver);
            bg.add(this.mShowPicturesNever);
            bg.add(this.mShowPicturesForSelection);
            bg.add(this.mShowPicturesForFilter);
            String timePattern = LOCALIZER.msg("timePattern", "hh:mm a");
            this.mPictureStartTime = new JSpinner(new SpinnerDateModel());
            this.mPictureStartTime.setEditor(new JSpinner.DateEditor(this.mPictureStartTime, timePattern));
            CaretPositionCorrector.createCorrector(((JSpinner.DateEditor)this.mPictureStartTime.getEditor()).getTextField(), new char[]{':'}, -1);
            this.mPictureEndTime = new JSpinner(new SpinnerDateModel());
            this.mPictureEndTime.setEditor(new JSpinner.DateEditor(this.mPictureEndTime, timePattern));
            CaretPositionCorrector.createCorrector(((JSpinner.DateEditor)this.mPictureEndTime.getEditor()).getTextField(), new char[]{':'}, -1);
            this.mDuration = new JSpinner(new SpinnerNumberModel(Settings.Pictures.DURATION.getInt(), 10, 240, 1));
            Calendar cal = Calendar.getInstance();
            cal.set(11, Settings.Pictures.TIME_START.getHourOfDay());
            cal.set(12, Settings.Pictures.TIME_START.getMinutesOfHour());
            this.mPictureStartTime.setValue(cal.getTime());
            cal.set(11, Settings.Pictures.TIME_END.getHourOfDay());
            cal.set(12, Settings.Pictures.TIME_END.getMinutesOfHour());
            this.mPictureEndTime.setValue(cal.getTime());
            this.mShowDescription = new JCheckBox(LOCALIZER.msg("showDescription", "Show description for pictures"), Settings.Pictures.DESCRIPTION_SHOW.getBoolean());
            this.mShowDescription.addItemListener(e -> this.mShowPictureBorderProgramTable.setEnabled(e.getStateChange() == 2));
            JEditorPane helpLabel = UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("help", "These settings affect only the showing of the pictures. The pictures can only be shown if the download of pictures in enabled. To enable the picture download look at the <a href=\"#link\">settings of the TV dataservices</a>."), e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SettingsDialog.getInstance().showSettingsTab("#plugins");
                }
            });
            EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("5dlu,12dlu,15dlu,default,5dlu,default,5dlu,default:grow,default,5dlu"));
            pb.border(Borders.DIALOG);
            pb.addSeparatorRowFull(false, LOCALIZER.msg("basics", "Picture settings for the program table"));
            pb.addRowFull(this.mShowPicturesNever, 2);
            pb.addRowFull(false, (Component)this.mShowPicturesEver, 2);
            pb.addRowFull(false, (Component)this.mShowPicturesForSelection, 2);
            pb.addRowFull("2dlu,default", (Component)this.mShowPicturesInTimeRange, 3);
            this.mStartLabel = pb.addLabelRow(LOCALIZER.msg("startTime", "From:"), 4);
            pb.add(this.mPictureStartTime, 6);
            this.mEndLabel = pb.addLabelRow("2dlu,default", LOCALIZER.msg("endTime", "To:"), 4);
            pb.add(this.mPictureEndTime, 6);
            pb.addRowFull("2dlu,default", (Component)this.mShowPicturesForDuration, 3);
            pb.addRow(false, (Component)this.mDuration, 6);
            JLabel minutesLabel = pb.labelAdd(LOCALIZER.msg("minutes", "Minutes"), 8);
            if (Settings.Pictures.PLUGIN_IDS.getStringArray() != null) {
                JPanel mSubPanel = new JPanel((LayoutManager)new FormLayout("15dlu,150dlu:grow,5dlu,pref", "pref,2dlu,pref"));
                this.mShowPicturesForPlugins = new JCheckBox(LOCALIZER.msg("showPicturesForPlugins", "Show for programs that are marked by plugins:"), ProgramPanelSettings.typeContainsType(Settings.Pictures.TYPE.getInt(), 3));
                this.mPluginLabel = new JLabel();
                this.mPluginLabel.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        PictureSettingsTab.this.handlePluginSelection();
                    }
                });
                this.mPluginLabel.setEnabled(this.mShowPicturesForPlugins.isSelected());
                this.choose = new JButton(LOCALIZER.msg("selectPlugins", "Choose Plugins"));
                this.choose.addActionListener(e -> {
                    Window parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
                    MarkerChooserDlg chooser = new MarkerChooserDlg(parent, this.mClientPlugins, null);
                    chooser.setLocationRelativeTo(parent);
                    chooser.setVisible(true);
                    this.mClientPlugins = chooser.getMarker();
                    this.handlePluginSelection();
                });
                this.choose.setEnabled(ProgramPanelSettings.typeContainsType(Settings.Pictures.TYPE.getInt(), 3));
                this.mShowPicturesForPlugins.addItemListener(e -> {
                    this.mPluginLabel.setEnabled(e.getStateChange() == 1);
                    this.choose.setEnabled(e.getStateChange() == 1);
                });
                String[] clientPluginIdArr = Settings.Pictures.PLUGIN_IDS.getStringArray();
                ArrayList<ButtonActionIf> clientPlugins = new ArrayList<ButtonActionIf>();
                for (String arr : clientPluginIdArr) {
                    PluginAccess plugin = Plugin.getPluginManager().getActivatedPluginForId(arr);
                    if (plugin != null) {
                        clientPlugins.add(plugin);
                        continue;
                    }
                    if (ReminderPluginProxy.getInstance().getId().compareTo(arr) == 0) {
                        clientPlugins.add(ReminderPluginProxy.getInstance());
                        continue;
                    }
                    if (FavoritesPluginProxy.getInstance().getId().compareTo(arr) != 0) continue;
                    clientPlugins.add(FavoritesPluginProxy.getInstance());
                }
                this.mClientPlugins = clientPlugins.toArray(new Marker[clientPlugins.size()]);
                mSubPanel.add((Component)this.mShowPicturesForPlugins, CC.xyw((int)1, (int)1, (int)4));
                mSubPanel.add((Component)this.mPluginLabel, CC.xy((int)2, (int)3));
                mSubPanel.add((Component)this.choose, CC.xy((int)4, (int)3));
                pb.addRow("2dlu,default", (Component)mSubPanel, 3, 7);
                pb.addRow("2dlu", false);
            } else {
                this.mPluginLabel.setEnabled(false);
            }
            JButton editFilter = new JButton(LOCALIZER.msg("editFilter", "Edit filter"));
            editFilter.setEnabled(this.mShowPicturesForFilter.isSelected());
            editFilter.addActionListener(e -> {
                UserFilter filter = GenericFilterMap.getInstance().getGenericInternalFilter("_picture");
                EditFilterDlg editFilter1 = new EditFilterDlg(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), FilterList.getInstance(), filter, false);
                if (editFilter1.getOkWasPressed()) {
                    GenericFilterMap.getInstance().updateGenericInternalFilter("_picture", filter);
                }
            });
            this.mShowPicturesForFilter.addItemListener(e -> editFilter.setEnabled(e.getStateChange() == 1));
            pb.addRowFull(false, (Component)this.mShowPicturesForFilter);
            pb.addRow("2dlu,default", (Component)editFilter, 3, 4);
            pb.addRowFull(this.mShowDescription, 2);
            this.mDescriptionLines = new JSpinner(new SpinnerNumberModel(Settings.Pictures.DESCRIPTION_LINES.getInt(), 1, 20, 1));
            pb.addRow(false, (Component)this.mDescriptionLines, 3, 4);
            this.mDescriptionLabel = new JLabel(LOCALIZER.msg("lines", "lines"));
            pb.add(this.mDescriptionLabel, 8);
            pb.addRowFull(false, (Component)this.mShowPictureBorderProgramTable, 3);
            this.mDescriptionLabel.setEnabled(this.mShowDescription.isSelected());
            this.mDescriptionLines.setEnabled(this.mShowDescription.isSelected());
            this.mShowPictureBorderProgramTable.setEnabled(!this.mShowDescription.isSelected());
            this.mShowDescription.addActionListener(e -> {
                this.mDescriptionLines.setEnabled(this.mShowDescription.isSelected());
                this.mDescriptionLabel.setEnabled(this.mShowDescription.isSelected());
            });
            pb.addParagraph(LOCALIZER.msg("pluginPictureTitle", "Default picture settings for the program lists of the Plugins"), 1, 9);
            this.mPluginsPictureSettings = new PluginsPictureSettingsPanel(new PluginPictureSettings(Settings.Pictures.PLUGINS_SETTING.getInt()), true);
            pb.addRow(this.mPluginsPictureSettings, 2, 8);
            pb.addRowFull("10dlu,default", (Component)helpLabel);
            if (PLUGIN_PICTURE_SELECTION_ORIGINAL == -1) {
                PLUGIN_PICTURE_SELECTION_ORIGINAL = this.mPluginsPictureSettings.getSettings().getType();
            }
            this.mPluginsPictureSettings.addChangeListener(e -> Settings.setRestartInfo(PictureSettingsTab.class.getCanonicalName(), PLUGIN_PICTURE_SELECTION_ORIGINAL != this.mPluginsPictureSettings.getSettings().getType()));
            this.mShowPicturesInTimeRange.addItemListener(e -> {
                this.mPictureStartTime.setEnabled(this.mShowPicturesInTimeRange.isSelected());
                this.mPictureEndTime.setEnabled(this.mShowPicturesInTimeRange.isSelected());
                this.mStartLabel.setEnabled(this.mShowPicturesInTimeRange.isSelected());
                this.mEndLabel.setEnabled(this.mShowPicturesInTimeRange.isSelected());
            });
            this.mShowPicturesForDuration.addItemListener(e -> {
                this.mDuration.setEnabled(this.mShowPicturesForDuration.isSelected());
                minutesLabel.setEnabled(this.mShowPicturesForDuration.isSelected());
            });
            this.mShowPicturesNever.addItemListener(e -> {
                this.mShowDescription.setEnabled(!this.mShowPicturesNever.isSelected());
                this.mDescriptionLines.setEnabled(!this.mShowPicturesNever.isSelected() && this.mShowDescription.isSelected());
                this.mShowPictureBorderProgramTable.setEnabled(!this.mShowPicturesNever.isSelected() && !this.mShowDescription.isSelected());
            });
            this.mShowPicturesForSelection.addItemListener(e -> {
                this.mShowPicturesForDuration.setEnabled(this.mShowPicturesForSelection.isSelected());
                this.mShowPicturesInTimeRange.setEnabled(this.mShowPicturesForSelection.isSelected());
                this.mStartLabel.setEnabled(this.mShowPicturesForSelection.isSelected() && this.mShowPicturesInTimeRange.isSelected());
                this.mEndLabel.setEnabled(this.mShowPicturesForSelection.isSelected() && this.mShowPicturesInTimeRange.isSelected());
                minutesLabel.setEnabled(this.mShowPicturesForSelection.isSelected() && this.mShowPicturesForDuration.isSelected());
                this.mPictureStartTime.setEnabled(this.mShowPicturesForSelection.isSelected() && this.mShowPicturesInTimeRange.isSelected());
                this.mPictureEndTime.setEnabled(this.mShowPicturesForSelection.isSelected() && this.mShowPicturesInTimeRange.isSelected());
                this.mDuration.setEnabled(this.mShowPicturesForSelection.isSelected() && this.mShowPicturesForDuration.isSelected());
                if (this.mShowPicturesForPlugins != null) {
                    this.mShowPicturesForPlugins.setEnabled(this.mShowPicturesForSelection.isSelected());
                }
                if (this.mPluginLabel != null) {
                    this.mPluginLabel.setEnabled(this.mShowPicturesForSelection.isSelected() && this.mShowPicturesForPlugins.isSelected());
                }
                if (this.choose != null) {
                    this.choose.setEnabled(this.mShowPicturesForSelection.isSelected() && this.mShowPicturesForPlugins.isSelected());
                }
            });
            this.mShowPicturesInTimeRange.getItemListeners()[0].itemStateChanged(null);
            this.mShowPicturesForDuration.getItemListeners()[0].itemStateChanged(null);
            this.mShowPicturesForSelection.getItemListeners()[0].itemStateChanged(null);
            this.mShowPicturesNever.getItemListeners()[0].itemStateChanged(null);
            return pb.getPanel();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    @Override
    public Icon getIcon() {
        return this.getPictureIcon();
    }

    @Override
    public String getTitle() {
        return Localizer.getLocalization("i18n_pictures");
    }

    @Override
    public void saveSettings() {
        Settings.Pictures.TYPE.setInt(this.getPictureShowingType());
        Settings.Pictures.TIME_START.setInt(this.getPictureTimeRangeStart());
        Settings.Pictures.TIME_END.setInt(this.getPictureTimeRangeEnd());
        Settings.Pictures.DURATION.setInt((Integer)this.mDuration.getValue());
        Settings.Pictures.BORDER_SHOW.setBoolean(this.mShowDescription.isSelected());
        if (!this.mShowDescription.isSelected()) {
            Settings.Pictures.BORDER_SHOW.setBoolean(this.mShowPictureBorderProgramTable.isSelected());
        } else {
            Settings.Pictures.BORDER_SHOW.setBoolean(true);
        }
        if (ProgramPanelSettings.typeContainsType(this.getPictureShowingType(), 3)) {
            Settings.Pictures.PLUGIN_IDS.setStringArray(this.getClientPluginIds());
        }
        Settings.Pictures.PLUGINS_SETTING.setInt(this.mPluginsPictureSettings.getSettings().getType());
        Settings.Pictures.DESCRIPTION_LINES.setInt((Integer)this.mDescriptionLines.getValue());
    }

    @Override
    public void cancel() {
        Settings.setRestartInfo(PictureSettingsTab.class.getCanonicalName(), PLUGIN_PICTURE_SELECTION_ORIGINAL != Settings.Pictures.PLUGINS_SETTING.getInt());
    }

    private synchronized void handlePluginSelection() {
        if (System.currentTimeMillis() - this.mLastPluginSelectionHandling > 10L) {
            if (this.mClientPlugins.length > 0) {
                this.mPluginLabel.setText(this.mClientPlugins[0].toString());
                this.mPluginLabel.setEnabled(this.mShowPicturesForPlugins.isSelected());
                int i = 1;
                String others = LOCALIZER.ellipsisMsg("otherPlugins", "others");
                int otherLength = this.mPluginLabel.getFontMetrics(this.mPluginLabel.getFont()).stringWidth(others) + 30;
                do {
                    String text = this.mPluginLabel.getText() + ", " + this.mClientPlugins[i];
                    int addLength = otherLength;
                    if (i == this.mClientPlugins.length - 1) {
                        addLength = 0;
                    }
                    if (this.mPluginLabel.getFontMetrics(this.mPluginLabel.getFont()).stringWidth(text) + addLength >= this.mPluginLabel.getWidth()) break;
                    this.mPluginLabel.setText(text);
                } while (i++ < this.mClientPlugins.length - 1);
                if (i < this.mClientPlugins.length) {
                    this.mPluginLabel.setText(this.mPluginLabel.getText() + " (" + (this.mClientPlugins.length - i) + " " + others + ")");
                }
            } else {
                this.mPluginLabel.setText(LOCALIZER.msg("noPlugins", "No Plugins choosen"));
                this.mPluginLabel.setEnabled(false);
            }
            this.mLastPluginSelectionHandling = System.currentTimeMillis();
        }
    }

    private int getPictureShowingType() {
        int value = 0;
        if (this.mShowPicturesEver.isSelected()) {
            value = 1;
        } else if (this.mShowPicturesForSelection.isSelected()) {
            if (this.mShowPicturesForDuration.isSelected()) {
                value += 4;
            }
            if (this.mShowPicturesForPlugins != null && this.mShowPicturesForPlugins.isSelected() && this.mClientPlugins != null && this.mClientPlugins.length > 0) {
                value += 3;
            }
            if (this.mShowPicturesInTimeRange.isSelected()) {
                value += 2;
            }
        } else if (this.mShowPicturesForFilter.isSelected()) {
            value = 10;
        }
        return value;
    }

    private int getPictureTimeRangeStart() {
        Calendar cal = Calendar.getInstance();
        Date startTime = (Date)this.mPictureStartTime.getValue();
        cal.setTime(startTime);
        return cal.get(11) * 60 + cal.get(12);
    }

    private int getPictureTimeRangeEnd() {
        Calendar cal = Calendar.getInstance();
        Date startTime = (Date)this.mPictureEndTime.getValue();
        cal.setTime(startTime);
        return cal.get(11) * 60 + cal.get(12);
    }

    private String[] getClientPluginIds() {
        if (this.mShowPicturesForPlugins != null) {
            String[] clientPluginIdArr = new String[this.mClientPlugins.length];
            for (int i = 0; i < this.mClientPlugins.length; ++i) {
                clientPluginIdArr[i] = this.mClientPlugins[i].getId();
            }
            return clientPluginIdArr;
        }
        return null;
    }
}

