/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings.channel;

import devplugin.Channel;
import java.util.Collection;
import java.util.HashSet;
import tvbrowser.core.ChannelList;

public class ChannelListModel {
    private HashSet<Channel> mSubscribedChannels = new HashSet();
    private Channel[] mAvailableChannels;

    public ChannelListModel() {
        this.refresh();
    }

    public void subscribeChannel(Channel ch) {
        this.mSubscribedChannels.add(ch);
    }

    public void unsubscribeChannel(Channel ch) {
        this.mSubscribedChannels.remove(ch);
    }

    public void refresh() {
        ChannelList.reload();
        Channel[] channels = ChannelList.getSubscribedChannels();
        this.mAvailableChannels = ChannelList.getAvailableChannels();
        this.mSubscribedChannels.clear();
        for (Channel channel : channels) {
            this.subscribeChannel(channel);
        }
    }

    public boolean isSubscribed(Channel ch) {
        return this.mSubscribedChannels.contains(ch);
    }

    public Channel[] getAvailableChannels() {
        return this.mAvailableChannels;
    }

    public Collection<Channel> getSubscribedChannels() {
        return this.mSubscribedChannels;
    }
}

