/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.update;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import devplugin.Version;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import tvbrowser.TVBrowser;
import tvbrowser.core.Settings;
import tvbrowser.ui.update.PluginAutoUpdater;
import tvbrowser.ui.update.SoftwareUpdateDlg;
import tvbrowser.ui.update.SoftwareUpdateItem;
import util.browserlauncher.Launch;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class TvBrowserVersionChangeDlg
extends JDialog
implements WindowClosingIf {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(TvBrowserVersionChangeDlg.class);
    private boolean mCloseTvBrowser;

    public TvBrowserVersionChangeDlg(Version oldTvBrowserVersion, Version obligatoryUpdate) {
        this.setLocationRelativeTo(null);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.mCloseTvBrowser = true;
        this.init(oldTvBrowserVersion, obligatoryUpdate);
    }

    private void init(Version oldTvBrowserVersion, Version obligatoryUpdate) {
        this.setTitle(LOCALIZER.msg("title", "TV-Browser was updated from {0} to {1}", oldTvBrowserVersion, TVBrowser.VERSION));
        UiUtilities.registerForClosing(this);
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("default:grow,default,default:grow"), (JPanel)this.getContentPane());
        JLabel l = pb.addLabelRow(false, LOCALIZER.msg("header", "TV-Browser was updated from {0} to {1}!", oldTvBrowserVersion, TVBrowser.VERSION), 2);
        l.setForeground(new Color(200, 0, 0));
        l.setFont(l.getFont().deriveFont(1, 22.0f));
        l.setBorder(Borders.createEmptyBorder((String)"10dlu,3dlu,5dlu,3dlu"));
        JEditorPane pane = UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("text", "<div style=\"font-size:large;text-align:justify\"><p>TV-Browser is developed on a regular basis. Every version contains changes to improve TV-Browser, but sometimes it is necessary to change some functions that could lead to discontinued support for old Plugin versions.</p><br><div style=\"font-weight:bold;color:red\">We recommend to update all installed plugins now. (It can happen that a plugin update is obligatory.)</div><p>You will need an Internet connection.</b> If you currently don't have an internet connection we recommend to close TV-Browser now and using the previous version until a Plugin update is possible.</p><p>Do you want to update your Plugins now (this may take some time)?</p></div>"), e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                Launch.openURL(e.getURL().toString());
            }
        }, UIManager.getColor("EditorPane.background"));
        pane.setPreferredSize(new Dimension(Sizes.dialogUnitXAsPixel((int)420, (Component)pane), Sizes.dialogUnitYAsPixel((int)200, (Component)pane)));
        pane.setBackground(UIManager.getColor("EditorPane.background"));
        pane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.darkGray), Borders.createEmptyBorder((String)"0dlu,10dlu,0dlu,10dlu")));
        JScrollPane scroll = new JScrollPane(pane);
        scroll.setBackground(pane.getBackground());
        scroll.getViewport().setBackground(scroll.getBackground());
        scroll.setBorder(BorderFactory.createEmptyBorder());
        pb.addRowFull("fill:default", false, scroll);
        JComponent[] buttons = new JButton[]{new JButton(LOCALIZER.msg("updatePlugins", "Update Plugins now")), new JButton(LOCALIZER.msg("closeTvBrowser", "Close TV-Browser now")), new JButton(LOCALIZER.msg("closeDialog", "Close this dialog and don't update"))};
        buttons[0].addActionListener(e -> {
            try {
                SoftwareUpdateItem[] updateItems = PluginAutoUpdater.getUpdateItemsForVersionChange();
                if (updateItems.length > 0) {
                    boolean oldValue = Settings.Plugins.BETA_WARNING.getBoolean();
                    Settings.Plugins.BETA_WARNING.setBoolean(false);
                    SoftwareUpdateDlg updateDlg = new SoftwareUpdateDlg(null, 1, updateItems, true, oldTvBrowserVersion);
                    if (!updateDlg.isEmpty()) {
                        updateDlg.setLocationRelativeTo(null);
                        updateDlg.setVisible(true);
                    }
                    Settings.Plugins.BETA_WARNING.setBoolean(oldValue);
                }
                this.mCloseTvBrowser = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.close();
        });
        buttons[1].addActionListener(e -> this.close());
        buttons[2].addActionListener(e -> {
            this.mCloseTvBrowser = false;
            this.close();
        });
        buttons[0].setFont(buttons[0].getFont().deriveFont(1, 13.0f));
        buttons[1].setFont(buttons[1].getFont().deriveFont(1, 13.0f));
        buttons[2].setFont(buttons[2].getFont().deriveFont(1, 13.0f));
        buttons[2].setEnabled(oldTvBrowserVersion.compareTo(obligatoryUpdate) >= 0);
        buttons[2].setToolTipText(LOCALIZER.msg("obligatoryTooltip", "If this button is disabled the plugin update is obligatory."));
        this.getRootPane().setDefaultButton(buttons[0]);
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.setOpaque(true);
        bb.addGlue();
        bb.addButton(buttons);
        bb.addGlue();
        bb.setBorder(Borders.createEmptyBorder((String)"6dlu,6dlu,6dlu,6dlu"));
        pb.addRowFull(false, (Component)bb.getPanel());
        pb.getPanel().setOpaque(true);
        pb.getPanel().setBackground(UIManager.getColor("EditorPane.background"));
    }

    public boolean getIsToCloseTvBrowser() {
        return this.mCloseTvBrowser;
    }

    @Override
    public void close() {
        this.dispose();
    }
}

