/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import util.ui.UiUtilities;

public final class WindowSetting {
    private Window mWindowCache;
    private int mXPos;
    private int mYPos;
    private int mWidth;
    private int mHeight;
    private Dimension mMinSize;
    private int mExtendedState;
    private boolean mIgnoreAndMinSizeLocation;

    public WindowSetting(ObjectInputStream in) throws IOException {
        int version = in.readInt();
        this.mXPos = in.readInt();
        this.mYPos = in.readInt();
        this.mWidth = in.readInt();
        this.mHeight = in.readInt();
        if (version > 1) {
            this.mExtendedState = in.readInt();
        }
        if (version > 2) {
            this.mIgnoreAndMinSizeLocation = in.readBoolean();
        }
    }

    public WindowSetting(Dimension size) {
        this.mXPos = -1;
        this.mYPos = -1;
        if (size == null) {
            this.mWidth = -1;
            this.mHeight = -1;
        } else {
            this.mWidth = size.width;
            this.mHeight = size.height;
        }
        this.mExtendedState = 0;
        this.mIgnoreAndMinSizeLocation = false;
    }

    public void saveSettings(ObjectOutputStream out) throws IOException {
        out.writeInt(3);
        out.writeInt(this.mXPos);
        out.writeInt(this.mYPos);
        out.writeInt(this.mWidth);
        out.writeInt(this.mHeight);
        out.writeInt(this.mExtendedState);
        out.writeBoolean(this.mIgnoreAndMinSizeLocation);
    }

    public void layout(Window window) {
        this.layout(window, null);
    }

    public void layout(final Window window, final Window parent) {
        final Rectangle d = window.getGraphicsConfiguration().getBounds();
        int width = this.mWidth;
        int height = this.mHeight;
        if (width < 20 || width > d.x + d.width) {
            window.pack();
            width = window.getWidth();
        }
        if (height < 20 || height > d.y + d.height) {
            window.pack();
            height = window.getHeight();
        }
        window.pack();
        this.mMinSize = window.getMinimumSize();
        this.mMinSize = new Dimension(Math.min(this.mMinSize.width, d.width), Math.min(this.mMinSize.height, d.height));
        width = Math.max(width, this.mMinSize.width);
        height = Math.max(height, this.mMinSize.height);
        width = Math.min(width, d.width);
        height = Math.min(height, d.height);
        window.setSize(width, height);
        boolean locationSet = false;
        if (this.mXPos < 0 || this.mYPos < 0 || this.mXPos > d.x + d.width || this.mYPos > d.y + d.height) {
            UiUtilities.centerAndShow(window, false);
        } else {
            window.setLocation(this.mXPos, this.mYPos);
            locationSet = true;
        }
        if (this.mExtendedState == 6 && window instanceof JFrame) {
            ((JFrame)window).setExtendedState(this.mExtendedState);
        }
        if (this.mWindowCache == null || !window.equals(this.mWindowCache)) {
            window.addComponentListener(new ComponentAdapter(){
                private Thread mSavePosWait;
                private AtomicBoolean mWaitSavePos = new AtomicBoolean(false);
                private Thread mSaveSizeWait;
                private AtomicBoolean mWaitSaveSize = new AtomicBoolean(false);

                private int getExtendedState(ComponentEvent e) {
                    WindowSetting.this.mExtendedState = 0;
                    if (window instanceof JFrame) {
                        WindowSetting.this.mExtendedState = ((JFrame)window).getExtendedState();
                    } else if (window instanceof JDialog && e.getComponent().getSize().equals(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().getSize())) {
                        WindowSetting.this.mExtendedState = 6;
                    }
                    return WindowSetting.this.mExtendedState;
                }

                private void savePos(final ComponentEvent e) {
                    this.mWaitSavePos.set(true);
                    if (this.mSavePosWait == null || !this.mSavePosWait.isAlive()) {
                        this.mSavePosWait = new Thread("SAVE WINDOW POSITION WAITING THREAD"){

                            @Override
                            public void run() {
                                while (mWaitSavePos.getAndSet(false)) {
                                    try {
                                        1.sleep(100L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                                if ((this.getExtendedState(e) & 6) != 6) {
                                    WindowSetting.this.mXPos = e.getComponent().getX();
                                    WindowSetting.this.mYPos = e.getComponent().getY();
                                }
                            }
                        };
                        this.mSavePosWait.start();
                    }
                }

                private void saveSize(final ComponentEvent e) {
                    this.mWaitSaveSize.set(true);
                    if (this.mSaveSizeWait == null || !this.mSaveSizeWait.isAlive()) {
                        this.mSaveSizeWait = new Thread("SAVE WINDOW SIZE WAITING THREAD"){

                            @Override
                            public void run() {
                                while (mWaitSaveSize.getAndSet(false)) {
                                    try {
                                        2.sleep(100L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                                if ((this.getExtendedState(e) & 6) != 6) {
                                    WindowSetting.this.mWidth = e.getComponent().getWidth();
                                    WindowSetting.this.mHeight = e.getComponent().getHeight();
                                }
                            }
                        };
                        this.mSaveSizeWait.start();
                    }
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                    this.savePos(e);
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    this.savePos(e);
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    if (WindowSetting.this.mMinSize != null && !WindowSetting.this.mIgnoreAndMinSizeLocation) {
                        int winWidth = window.getWidth();
                        int winHeight = window.getHeight();
                        boolean resize = false;
                        if ((double)winWidth < WindowSetting.this.mMinSize.getWidth()) {
                            winWidth = WindowSetting.this.mMinSize.width;
                            resize = true;
                        }
                        if ((double)winHeight < WindowSetting.this.mMinSize.getHeight()) {
                            winHeight = WindowSetting.this.mMinSize.height;
                            resize = true;
                        }
                        if (resize) {
                            window.setSize(winWidth, winHeight);
                        }
                    }
                    this.saveSize(e);
                }

                @Override
                public void componentShown(final ComponentEvent e) {
                    SwingUtilities.invokeLater(new Thread(){

                        @Override
                        public void run() {
                            try {
                                3.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (parent == null && !WindowSetting.this.mIgnoreAndMinSizeLocation) {
                                Point p = e.getComponent().getLocation();
                                if (WindowSetting.this.mXPos < 0 || WindowSetting.this.mYPos < 0 || WindowSetting.this.mXPos > d.x + d.width || WindowSetting.this.mYPos > d.y + d.height) {
                                    UiUtilities.centerAndShow(window, false);
                                } else if ((p.x != WindowSetting.this.mXPos || WindowSetting.this.mYPos != p.y) && System.getenv("DESKTOP_SESSION") != null && System.getenv("DESKTOP_SESSION").toLowerCase().equals("ubuntu")) {
                                    window.setLocation(WindowSetting.this.mXPos, WindowSetting.this.mYPos);
                                }
                            } else {
                                Point p = e.getComponent().getLocation();
                                if (!(WindowSetting.this.mXPos < 0 && WindowSetting.this.mYPos < 0 || p.x == WindowSetting.this.mXPos && WindowSetting.this.mYPos == p.y || System.getenv("DESKTOP_SESSION") == null || !System.getenv("DESKTOP_SESSION").toLowerCase().equals("ubuntu"))) {
                                    window.setLocation(WindowSetting.this.mXPos, WindowSetting.this.mYPos);
                                }
                            }
                        }
                    });
                }
            });
        }
        if (parent != null && !this.mIgnoreAndMinSizeLocation && !locationSet) {
            window.setLocationRelativeTo(parent);
        }
        this.mWindowCache = window;
    }

    public String toString() {
        return "x:" + this.mXPos + " y:" + this.mYPos + " " + this.mWidth + "x" + this.mHeight;
    }

    public void setIgnoreAndMinSizeLocation(boolean ignoreAndMinSizeLocation) {
        this.mIgnoreAndMinSizeLocation = ignoreAndMinSizeLocation;
    }
}

