/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla;

import java.lang.reflect.Constructor;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.lang.reflect.TypeToken;
import org.jquantlib.math.Array;
import org.jquantlib.methods.lattices.BinomialTree;
import org.jquantlib.methods.lattices.BlackScholesLattice;
import org.jquantlib.methods.lattices.Tree;
import org.jquantlib.pricingengines.Greeks;
import org.jquantlib.pricingengines.VanillaOptionEngine;
import org.jquantlib.pricingengines.arguments.OneAssetOptionArguments;
import org.jquantlib.pricingengines.results.OneAssetOptionResults;
import org.jquantlib.pricingengines.vanilla.DiscretizedVanillaOption;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.processes.StochasticProcess1D;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.volatilities.BlackConstantVol;
import org.jquantlib.termstructures.yieldcurves.FlatForward;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.TimeGrid;
import org.jquantlib.util.Date;

public abstract class BinomialVanillaEngine<T extends BinomialTree>
extends VanillaOptionEngine {
    private final Class<T> clazz = TypeToken.getClazz(this.getClass());
    private final int timeSteps_;

    public BinomialVanillaEngine(int timeSteps) {
        this.timeSteps_ = timeSteps;
        if (this.timeSteps_ <= 0) {
            throw new IllegalArgumentException("timeSteps must be positive");
        }
    }

    private Object getTreeInstance(StochasticProcess1D bs, double maturity, int timeSteps, double strike) {
        try {
            Constructor<T> c = this.clazz.getConstructor(StochasticProcess1D.class, Double.TYPE, Integer.TYPE, Double.TYPE);
            return this.clazz.cast(c.newInstance(bs, maturity, timeSteps, strike));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void calculate() {
        GeneralizedBlackScholesProcess process = (GeneralizedBlackScholesProcess)((OneAssetOptionArguments)this.arguments).stochasticProcess;
        if (process == null) {
            throw new NullPointerException("Black-Scholes process required");
        }
        DayCounter rfdc = process.riskFreeRate().getLink().dayCounter();
        DayCounter divdc = process.dividendYield().getLink().dayCounter();
        DayCounter voldc = process.blackVolatility().getLink().dayCounter();
        Calendar volcal = process.blackVolatility().getLink().calendar();
        double s0 = process.stateVariable().getLink().evaluate();
        if (s0 <= 0.0) {
            throw new IllegalStateException("negative or null underlying given");
        }
        double v = process.blackVolatility().getLink().blackVol(((OneAssetOptionArguments)this.arguments).exercise.lastDate(), s0);
        Date maturityDate = ((OneAssetOptionArguments)this.arguments).exercise.lastDate();
        double r = process.riskFreeRate().getLink().zeroRate(maturityDate, rfdc, Compounding.CONTINUOUS, Frequency.NO_FREQUENCY).rate();
        double q = process.dividendYield().getLink().zeroRate(maturityDate, divdc, Compounding.CONTINUOUS, Frequency.NO_FREQUENCY).rate();
        Date referenceDate = process.riskFreeRate().getLink().referenceDate();
        Handle<YieldTermStructure> flatRiskFree = new Handle<YieldTermStructure>(new FlatForward(referenceDate, r, rfdc));
        Handle<YieldTermStructure> flatDividends = new Handle<YieldTermStructure>(new FlatForward(referenceDate, q, divdc));
        Handle<BlackVolTermStructure> flatVol = new Handle<BlackVolTermStructure>(new BlackConstantVol(referenceDate, volcal, v, voldc));
        PlainVanillaPayoff payoff = (PlainVanillaPayoff)((OneAssetOptionArguments)this.arguments).payoff;
        if (payoff == null) {
            throw new NullPointerException("non-plain payoff given");
        }
        double maturity = rfdc.yearFraction(referenceDate, maturityDate);
        GeneralizedBlackScholesProcess bs = new GeneralizedBlackScholesProcess(process.stateVariable(), flatDividends, flatRiskFree, flatVol);
        TimeGrid grid = new TimeGrid(maturity, this.timeSteps_);
        Tree tree = (Tree)this.getTreeInstance(bs, maturity, this.timeSteps_, payoff.strike());
        BlackScholesLattice<Tree> lattice = new BlackScholesLattice<Tree>(tree, r, maturity, this.timeSteps_);
        DiscretizedVanillaOption option = new DiscretizedVanillaOption((OneAssetOptionArguments)this.arguments, process, grid);
        option.initialize(lattice, maturity);
        option.rollback(grid.at(2));
        Array va2 = new Array(option.values().getData());
        if (va2.size() != 3) {
            throw new IllegalStateException("Expect 3 nodes in grid at second step");
        }
        double p2h = va2.at(2);
        double s2 = lattice.underlying(2, 2);
        option.rollback(grid.at(1));
        Array va = new Array(option.values().getData());
        if (va.size() != 2) {
            throw new IllegalStateException("Expect 2 nodes in grid at first step");
        }
        double p1 = va.at(1);
        option.rollback(0.0);
        double p0 = option.presentValue();
        double s1 = lattice.underlying(1, 1);
        double delta0 = (p1 - p0) / (s1 - s0);
        double delta1 = (p2h - p1) / (s2 - s1);
        ((OneAssetOptionResults)this.results).value = p0;
        ((OneAssetOptionResults)this.results).delta = delta0;
        ((OneAssetOptionResults)this.results).gamma = 2.0 * (delta1 - delta0) / (s2 - s0);
        ((OneAssetOptionResults)this.results).theta = Greeks.blackScholesTheta(process, ((OneAssetOptionResults)this.results).value, ((OneAssetOptionResults)this.results).delta, ((OneAssetOptionResults)this.results).gamma);
    }
}

