/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Italy
extends DelegateCalendar {
    private static final Italy SETTLEMENT_CALENDAR = new Italy(Market.SETTLEMENT);
    private static final Italy EXCHANGE_CALENDAR = new Italy(Market.EXCHANGE);

    private Italy(Market market) {
        WesternCalendar delegate;
        switch (market) {
            case SETTLEMENT: {
                delegate = new ItalySettlementCalendar();
                break;
            }
            case EXCHANGE: {
                delegate = new ItalyExchangeCalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Italy getCalendar(Market market) {
        switch (market) {
            case SETTLEMENT: {
                return SETTLEMENT_CALENDAR;
            }
            case EXCHANGE: {
                return EXCHANGE_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class ItalyExchangeCalendar
    extends WesternCalendar {
        private ItalyExchangeCalendar() {
        }

        @Override
        public String getName() {
            return "Milan stock exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || dd == em - 3 || dd == em || d == 1 && m == Month.MAY || d == 15 && m == Month.AUGUST || d == 24 && m == Month.DECEMBER || d == 25 && m == Month.DECEMBER || d == 26 && m == Month.DECEMBER) && (d != 31 || m != Month.DECEMBER);
        }
    }

    private static final class ItalySettlementCalendar
    extends WesternCalendar {
        private ItalySettlementCalendar() {
        }

        @Override
        public String getName() {
            return "Italian settlement";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || d == 6 && m == Month.JANUARY || dd == em || d == 25 && m == Month.APRIL || d == 1 && m == Month.MAY || d == 2 && m == Month.JUNE && y >= 2000 || d == 15 && m == Month.AUGUST || d == 1 && m == Month.NOVEMBER || d == 8 && m == Month.DECEMBER || d == 25 && m == Month.DECEMBER || d == 26 && m == Month.DECEMBER) && (d != 31 || m != Month.DECEMBER || y != 1999);
        }
    }

    public static enum Market {
        SETTLEMENT,
        EXCHANGE;

    }
}

