/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.math.Beta;
import org.jquantlib.math.UnaryFunctionInteger;

public class CumulativeBinomialDistribution
implements UnaryFunctionInteger {
    private static final double accuracy = 1.0E-16;
    private static final int maxIteration = 100;
    private final int n;
    private final double p;

    public CumulativeBinomialDistribution(double p, int n) {
        this.n = n;
        this.p = p;
        if (p <= 0.0) {
            throw new ArithmeticException("negative p not allowed");
        }
        if (p > 1.0) {
            throw new ArithmeticException("p>1.0 not allowed");
        }
    }

    @Override
    public double evaluate(int k) {
        if (k >= this.n) {
            return 1.0;
        }
        return 1.0 - Beta.incompleteBetaFunction(k + 1, this.n - k, this.p, 1.0E-16, 100);
    }
}

