/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.RelinkableHandle;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.yieldcurves.RelativeDateRateHelper;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.util.Date;

public class FraRateHelper
extends RelativeDateRateHelper {
    private Date fixingDate;
    private int monthsToStart;
    private IborIndex iborIndex;
    private RelinkableHandle<YieldTermStructure> termStructureHandle;

    public FraRateHelper(Handle<Quote> rate, int monthsToStart, int monthsToEnd, int fixingDays, Calendar calendar, BusinessDayConvention convention, boolean endOfMonth, DayCounter dayCounter) {
        this.quote = rate;
        this.monthsToStart = monthsToStart;
        if (monthsToEnd <= monthsToStart) {
            throw new IllegalArgumentException("monthsToEnd must be greater than monthsToStart");
        }
        this.iborIndex = new IborIndex("no-fix", new Period(monthsToEnd - monthsToStart, TimeUnit.MONTHS), fixingDays, calendar, null, convention, endOfMonth, dayCounter, this.termStructureHandle);
        this.initializeDates();
    }

    public FraRateHelper(double rate, int monthsToStart, int monthsToEnd, int fixingDays, Calendar calendar, BusinessDayConvention convention, boolean endOfMonth, DayCounter dayCounter) {
        super(rate);
        this.monthsToStart = monthsToStart;
        if (monthsToEnd <= monthsToStart) {
            throw new IllegalArgumentException("monthsToEnd must be grater than monthsToStart");
        }
        this.iborIndex = new IborIndex("no-fix", new Period(monthsToEnd - monthsToStart, TimeUnit.MONTHS), fixingDays, calendar, null, convention, endOfMonth, dayCounter, this.termStructureHandle);
        this.initializeDates();
    }

    public FraRateHelper(Handle<Quote> rate, int monthsToStart, IborIndex i) {
        this.quote = rate;
        this.monthsToStart = monthsToStart;
        this.iborIndex = new IborIndex("no-fix", i.getTenor(), i.getFixingDays(), i.getFixingCalendar(), null, i.getConvention(), i.isEndOfMonth(), i.getDayCounter(), this.termStructureHandle);
        this.initializeDates();
    }

    public FraRateHelper(double rate, int monthsToStart, IborIndex i) {
        super(rate);
        this.monthsToStart = monthsToStart;
        this.iborIndex = new IborIndex("no-fix", i.getTenor(), i.getFixingDays(), i.getFixingCalendar(), null, i.getConvention(), i.isEndOfMonth(), i.getDayCounter(), this.termStructureHandle);
        this.initializeDates();
    }

    @Override
    public double getImpliedQuote() {
        if (this.termStructure == null) {
            throw new IllegalStateException("term structure not set");
        }
        return this.iborIndex.fixing(this.fixingDate, true);
    }

    @Override
    public void setTermStructure(YieldTermStructure t) {
        this.termStructureHandle.setLink(t);
        super.setTermStructure(t);
    }

    @Override
    protected void initializeDates() {
        Date settlement = this.iborIndex.getFixingCalendar().advance(this.evaluationDate, new Period(this.iborIndex.getFixingDays(), TimeUnit.DAYS), BusinessDayConvention.FOLLOWING, false);
        this.earliestDate = this.iborIndex.getFixingCalendar().advance(settlement, new Period(this.monthsToStart, TimeUnit.MONTHS), this.iborIndex.getConvention(), this.iborIndex.isEndOfMonth());
        this.latestDate = this.iborIndex.maturityDate(this.earliestDate);
        this.fixingDate = this.iborIndex.fixingDate(this.earliestDate);
    }
}

