/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Finland
extends DelegateCalendar {
    private static final Finland HSE_CALENDAR = new Finland(Market.HSE);

    private Finland(Market market) {
        FinlandHSECalendar delegate;
        switch (market) {
            case HSE: {
                delegate = new FinlandHSECalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Finland getCalendar(Market market) {
        switch (market) {
            case HSE: {
                return HSE_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class FinlandHSECalendar
    extends WesternCalendar {
        private FinlandHSECalendar() {
        }

        @Override
        public String getName() {
            return "HSE";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || d == 6 && m == Month.JANUARY || dd == em - 3 || dd == em || dd == em + 38 || d == 1 && m == Month.MAY || w == Weekday.FRIDAY && d >= 18 && d <= 24 && m == Month.JUNE || d == 6 && m == Month.DECEMBER || d == 24 && m == Month.DECEMBER || d == 25 && m == Month.DECEMBER || d == 26 && m == Month.DECEMBER) && (d != 31 || m != Month.DECEMBER);
        }
    }

    public static enum Market {
        HSE;

    }
}

