/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.AWTCompatibility;
import netscape.application.Font;
import netscape.application.Size;

public class FontMetrics {
    Font _font;
    java.awt.FontMetrics _awtMetrics;
    static final String LEADING = "Leading";
    static final String ASCENT = "Ascent";
    static final String DESCENT = "Descent";
    static final String TOTAL_HEIGHT = "Total Height";
    static final String MAX_ASCENT = "Maximum Ascent";
    static final String MAX_DESCENT = "Maximum Descent";
    static final String MAX_ADVANCE = "Maximum Advance";

    public FontMetrics() {
    }

    public FontMetrics(Font font) {
        this();
        this._font = font;
        if (!this._font.wasDownloaded()) {
            this._awtMetrics = AWTCompatibility.awtToolkit().getFontMetrics(this._font._awtFont);
        }
    }

    FontMetrics(java.awt.FontMetrics fontMetrics) {
        this();
        this._font = AWTCompatibility.fontForAWTFont(fontMetrics.getFont());
        this._awtMetrics = fontMetrics;
    }

    public Font font() {
        return this._font;
    }

    public int leading() {
        if (this._awtMetrics != null) {
            return this._awtMetrics.getLeading();
        }
        return this._font._intValueFromDescription(LEADING);
    }

    public int ascent() {
        if (this._awtMetrics != null) {
            return this._awtMetrics.getAscent();
        }
        return this._font._intValueFromDescription(ASCENT);
    }

    public int descent() {
        if (this._awtMetrics != null) {
            return this._awtMetrics.getDescent();
        }
        return this._font._intValueFromDescription(DESCENT);
    }

    public int height() {
        if (this._awtMetrics != null) {
            return this._awtMetrics.getHeight();
        }
        return this._font._intValueFromDescription(TOTAL_HEIGHT);
    }

    public int charHeight() {
        if (this._awtMetrics != null) {
            return this._awtMetrics.getAscent() + this._awtMetrics.getDescent();
        }
        return this._font._intValueFromDescription(ASCENT) + this._font._intValueFromDescription(DESCENT);
    }

    public int maxAscent() {
        if (this._awtMetrics != null) {
            return this._awtMetrics.getMaxAscent();
        }
        return this._font._intValueFromDescription(MAX_ASCENT);
    }

    public int maxDescent() {
        if (this._awtMetrics != null) {
            return this._awtMetrics.getMaxDecent();
        }
        return this._font._intValueFromDescription(MAX_DESCENT);
    }

    public int maxAdvance() {
        if (this._awtMetrics != null) {
            return this._awtMetrics.getMaxAdvance();
        }
        return this._font._intValueFromDescription(MAX_ADVANCE);
    }

    public int charWidth(int n) {
        if (this._awtMetrics != null) {
            return this._awtMetrics.charWidth(n);
        }
        return 0;
    }

    public int charWidth(char c) {
        if (this._awtMetrics != null) {
            return this._awtMetrics.charWidth(c);
        }
        return 0;
    }

    public int stringWidth(String string) {
        if (string == null) {
            return 0;
        }
        if (this._awtMetrics != null) {
            return this._awtMetrics.stringWidth(string);
        }
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c >= '\u0000' && c < this._font._widthsArray.length) {
                n += this._font._widthsArray[c];
            }
            ++n2;
        }
        return n;
    }

    public int stringHeight() {
        return this.ascent() + this.descent();
    }

    public Size stringSize(String string) {
        return new Size(this.stringWidth(string), this.stringHeight());
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        if (this._awtMetrics != null) {
            return this._awtMetrics.charsWidth(cArray, n, n2);
        }
        return 0;
    }

    public int bytesWidth(byte[] byArray, int n, int n2) {
        if (this._awtMetrics != null) {
            return this._awtMetrics.bytesWidth(byArray, n, n2);
        }
        return 0;
    }

    public int[] widthsArray() {
        if (this._awtMetrics != null) {
            return this._awtMetrics.getWidths();
        }
        return this._font._widthsArray;
    }

    public int widthsArrayBase() {
        return this._font._widthsArrayBase;
    }

    public String toString() {
        if (this._awtMetrics != null) {
            return this._awtMetrics.toString();
        }
        return "";
    }
}

