/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Color;
import netscape.application.Font;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.ListView;
import netscape.application.Rect;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;

public class ListItem
implements Cloneable,
Codable {
    ListView listView;
    String command;
    String title;
    Font font;
    Color selectedColor = Color.white;
    Color textColor = Color.black;
    Image image;
    Image selectedImage;
    boolean selected;
    boolean enabled = true;
    Object data;
    static final String LISTVIEW_KEY = "listView";
    static final String COMMAND_KEY = "command";
    static final String TITLE_KEY = "title";
    static final String FONT_KEY = "font";
    static final String SELECTEDCOLOR_KEY = "selectedColor";
    static final String TEXTCOLOR_KEY = "textColor";
    static final String IMAGE_KEY = "image";
    static final String SELECTEDIMAGE_KEY = "selectedImage";
    static final String SELECTED_KEY = "selected";
    static final String ENABLED_KEY = "enabled";
    static final String DATA_KEY = "data";
    static final String VER_2_TEXTCOLOR_KEY = "foregroundColor";

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InconsistencyException(this + ": clone() not supported :" + cloneNotSupportedException);
        }
    }

    void setListView(ListView listView) {
        this.listView = listView;
    }

    public ListView listView() {
        return this.listView;
    }

    public boolean isTransparent() {
        return !this.selected;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public String command() {
        return this.command;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String title() {
        return this.title;
    }

    public void setSelected(boolean bl) {
        if (!this.enabled) {
            bl = false;
        }
        this.selected = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!this.enabled) {
            this.selected = false;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Image image() {
        return this.image;
    }

    public void setSelectedImage(Image image) {
        this.selectedImage = image;
    }

    public Image selectedImage() {
        return this.selectedImage;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font font() {
        if (this.font == null) {
            this.font = Font.defaultFont();
        }
        return this.font;
    }

    public void setSelectedColor(Color color) {
        this.selectedColor = color;
    }

    public Color selectedColor() {
        return this.selectedColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public Color textColor() {
        return this.textColor;
    }

    public void setData(Object object) {
        this.data = object;
    }

    public Object data() {
        return this.data;
    }

    public int minWidth() {
        Font font;
        int n = 0;
        if (this.image != null) {
            n = this.image.width();
        }
        if (this.selectedImage != null && this.selectedImage.width() > n) {
            n = this.selectedImage.width();
        }
        if ((font = this.font()) != null) {
            n += font.fontMetrics().stringWidth(this.title);
        }
        if (n > 0) {
            n += 3;
        }
        return n;
    }

    public int minHeight() {
        Font font;
        int n = 0;
        int n2 = 0;
        if (this.image != null) {
            n = this.image.height();
        }
        if (this.selectedImage != null && this.selectedImage.height() > n) {
            n = this.selectedImage.height();
        }
        if ((font = this.font()) != null) {
            n2 = font.fontMetrics().stringHeight();
        }
        if (n2 > n) {
            n = n2;
        }
        return n;
    }

    protected void drawBackground(Graphics graphics, Rect rect) {
        if (this.selected) {
            graphics.setColor(this.selectedColor);
            graphics.fillRect(rect);
        }
    }

    protected void drawStringInRect(Graphics graphics, String string, Font font, Rect rect, int n) {
        if (this.listView().isEnabled() && this.enabled) {
            graphics.setColor(this.textColor);
        } else {
            graphics.setColor(Color.gray);
        }
        graphics.setFont(font);
        graphics.drawStringInRect(string, rect, n);
    }

    public void drawInRect(Graphics graphics, Rect rect) {
        this.drawBackground(graphics, rect);
        Image image = this.selected ? this.selectedImage : this.image;
        int n = 0;
        int n2 = 0;
        if (this.image != null) {
            n2 = this.image.width();
            n = this.image.height();
        }
        if (this.selectedImage != null) {
            if (this.selectedImage.width() > n2) {
                n2 = this.selectedImage.width();
            }
            if (this.selectedImage.height() > n) {
                n = this.selectedImage.height();
            }
        }
        if (image != null) {
            image.drawAt(graphics, rect.x, rect.y + (rect.height - n) / 2);
        }
        if (this.title != null && this.title.length() > 0) {
            Rect rect2 = Rect.newRect(rect.x + 2 + n2, rect.y, rect.width - 2 - n2, rect.height);
            this.drawStringInRect(graphics, this.title, this.font(), rect2, 0);
            Rect.returnRect(rect2);
        }
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.application.ListItem", 3);
        classInfo.addField(LISTVIEW_KEY, (byte)18);
        classInfo.addField(COMMAND_KEY, (byte)16);
        classInfo.addField(TITLE_KEY, (byte)16);
        classInfo.addField(FONT_KEY, (byte)18);
        classInfo.addField(SELECTEDCOLOR_KEY, (byte)18);
        classInfo.addField(IMAGE_KEY, (byte)18);
        classInfo.addField(SELECTEDIMAGE_KEY, (byte)18);
        classInfo.addField(SELECTED_KEY, (byte)0);
        classInfo.addField(ENABLED_KEY, (byte)0);
        classInfo.addField(DATA_KEY, (byte)18);
        classInfo.addField(TEXTCOLOR_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeObject(LISTVIEW_KEY, this.listView);
        encoder.encodeString(COMMAND_KEY, this.command);
        encoder.encodeString(TITLE_KEY, this.title);
        encoder.encodeObject(FONT_KEY, this.font);
        encoder.encodeObject(SELECTEDCOLOR_KEY, this.selectedColor);
        encoder.encodeObject(IMAGE_KEY, this.image);
        encoder.encodeObject(SELECTEDIMAGE_KEY, this.selectedImage);
        encoder.encodeBoolean(SELECTED_KEY, this.selected);
        encoder.encodeBoolean(ENABLED_KEY, this.enabled);
        if (this.data != null && this.data instanceof Codable) {
            encoder.encodeObject(DATA_KEY, this.data);
        } else {
            encoder.encodeObject(DATA_KEY, null);
        }
        encoder.encodeObject(TEXTCOLOR_KEY, this.textColor);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.listView = (ListView)decoder.decodeObject(LISTVIEW_KEY);
        this.command = decoder.decodeString(COMMAND_KEY);
        this.title = decoder.decodeString(TITLE_KEY);
        this.font = (Font)decoder.decodeObject(FONT_KEY);
        this.selectedColor = (Color)decoder.decodeObject(SELECTEDCOLOR_KEY);
        this.image = (Image)decoder.decodeObject(IMAGE_KEY);
        this.selectedImage = (Image)decoder.decodeObject(SELECTEDIMAGE_KEY);
        this.selected = decoder.decodeBoolean(SELECTED_KEY);
        this.enabled = decoder.decodeBoolean(ENABLED_KEY);
        this.data = decoder.decodeObject(DATA_KEY);
        if (decoder.versionForClassName("netscape.application.ListItem") == 2) {
            this.textColor = (Color)decoder.decodeObject(VER_2_TEXTCOLOR_KEY);
            return;
        }
        if (decoder.versionForClassName("netscape.application.ListItem") > 2) {
            this.textColor = (Color)decoder.decodeObject(TEXTCOLOR_KEY);
        }
    }

    public void finishDecoding() throws CodingException {
    }
}

