/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Application;
import netscape.application.BezelBorder;
import netscape.application.Bitmap;
import netscape.application.Border;
import netscape.application.Color;
import netscape.application.ContainerView;
import netscape.application.ExternalWindow;
import netscape.application.FormElement;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.InternalWindow;
import netscape.application.ListItem;
import netscape.application.ListView;
import netscape.application.MouseEvent;
import netscape.application.PopupItem;
import netscape.application.Rect;
import netscape.application.Size;
import netscape.application.Target;
import netscape.application.View;
import netscape.application.Window;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class Popup
extends View
implements Target,
FormElement {
    ListView popupList;
    Window popupWindow;
    ContainerView container;
    ListItem selectedItem;
    ListItem wasSelectedItem;
    Target target;
    Image image;
    boolean _showingPopupForKeyboard;
    boolean enabled = true;
    static final String LISTVIEW_KEY = "popupList";
    static final String WINDOW_KEY = "popupWindow";
    static final String CONTAINER_KEY = "container";
    static final String SELECTEDITEM_KEY = "selectedItem";
    static final String TARGET_KEY = "target";
    static final String SELECTEDIMAGE_KEY = "selectedImage";
    static final String ENABLED_KEY = "enabled";
    public static final String SELECT_NEXT_ITEM = ListView.SELECT_NEXT_ITEM;
    public static final String SELECT_PREVIOUS_ITEM = ListView.SELECT_PREVIOUS_ITEM;
    public static final String POPUP = "popup";
    static final String CLOSE_POPUP_AND_CANCEL = "cancel";
    static final String CLOSE_POPUP_AND_COMMIT = "commit";

    public Popup() {
        this(0, 0, 0, 0);
    }

    public Popup(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public Popup(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        InternalWindow internalWindow = new InternalWindow(n, n2, n3, n4);
        internalWindow.setType(0);
        internalWindow.setLayer(300);
        internalWindow._contentView.setTransparent(true);
        internalWindow.setScrollsToVisible(true);
        InternalWindow internalWindow2 = internalWindow;
        this.container = new ContainerView(0, 0, n3, n4);
        this.container.setTransparent(true);
        this.container.setBorder(BezelBorder.raisedBezel());
        this.container.setVertResizeInstruction(16);
        this.container.setHorizResizeInstruction(2);
        ListView listView = new ListView(0, 0, n3, n4);
        PopupItem popupItem = new PopupItem();
        popupItem.setPopup(this);
        this.setPopupList(listView);
        this.setPrototypeItem(popupItem);
        this.setPopupWindow(internalWindow2);
        this.setPopupImage(Bitmap.bitmapNamed("netscape/application/PopupKnobH.gif"));
        this._setupKeyboard();
    }

    public void setPrototypeItem(ListItem listItem) {
        this.popupList.setPrototypeItem(listItem);
        if (listItem instanceof PopupItem) {
            ((PopupItem)listItem).setPopup(this);
        }
    }

    public ListItem prototypeItem() {
        return this.popupList.prototypeItem();
    }

    public void removeAllItems() {
        this.popupList.removeAllItems();
    }

    public ListItem addItem(String string, String string2) {
        this.hidePopupIfNeeded();
        ListItem listItem = this.popupList.addItem();
        listItem.setTitle(string);
        listItem.setCommand(string2);
        return listItem;
    }

    public void removeItem(String string) {
        if (string == null) {
            return;
        }
        int n = this.popupList.count();
        while (n-- > 0) {
            ListItem listItem = this.itemAt(n);
            if (!string.equals(listItem.title())) continue;
            this.hidePopupIfNeeded();
            this.popupList.removeItemAt(n);
            return;
        }
    }

    public void removeItemAt(int n) {
        if (this.popupList.count() > n) {
            this.hidePopupIfNeeded();
            this.popupList.removeItemAt(n);
        }
    }

    public int selectedIndex() {
        int n = this.popupList.indexOfItem(this.selectedItem);
        if (n < 0 && this.popupList.count() > 0) {
            n = 0;
            this.selectItemAt(0);
        }
        return n;
    }

    public ListItem selectedItem() {
        int n = this.selectedIndex();
        if (n < 0) {
            return null;
        }
        return this.popupList.itemAt(n);
    }

    public void selectItem(ListItem listItem) {
        this.selectedItem = listItem;
        this.draw();
    }

    public void selectItemAt(int n) {
        this.selectItem(this.popupList.itemAt(n));
    }

    public int count() {
        return this.popupList.count();
    }

    public ListItem itemAt(int n) {
        return this.popupList.itemAt(n);
    }

    public void setBorder(Border border) {
        this.container.setBorder(border);
    }

    public Border border() {
        return this.container.border();
    }

    public void setPopupList(ListView listView) {
        this.popupList = listView;
        this.popupList.setTarget(this);
        this.popupList.setAllowsMultipleSelection(false);
        this.popupList.setAllowsEmptySelection(true);
        this.popupList.setTracksMouseOutsideBounds(false);
        this.container.addSubview(this.popupList);
    }

    public ListView popupList() {
        return this.popupList;
    }

    public void setPopupWindow(Window window) {
        this.popupWindow = window;
        if (window instanceof InternalWindow) {
            InternalWindow internalWindow = (InternalWindow)window;
            internalWindow.setScrollsToVisible(true);
            window.addSubview(this.container);
        }
    }

    public Window popupWindow() {
        return this.popupWindow;
    }

    public void setPopupImage(Image image) {
        this.image = image;
    }

    public Image popupImage() {
        return this.image;
    }

    protected void layoutPopupWindow() {
        Border border = this.container.border();
        this.popupList.setRowHeight(this.bounds.height - border.heightMargin());
        this.popupList.setBounds(border.leftMargin(), border.topMargin(), this.bounds.width - border.widthMargin(), this.popupList.rowHeight() * this.popupList.count());
        int n = this.selectedIndex();
        Rect rect = Rect.newRect(0, 0, this.width(), this.height());
        this.convertRectToView(null, rect, rect);
        if (this.rootView().windowClipView() != null) {
            this.rootView().convertRectToView(this.rootView().windowClipView(), rect, rect);
        }
        this.popupWindow.setBounds(rect.x, rect.y - n * this.popupList.rowHeight(), this.popupList.width() + border.widthMargin(), this.popupList.height() + border.heightMargin());
        Rect.returnRect(rect);
    }

    protected void showPopupWindow(MouseEvent mouseEvent) {
        if (this.popupWindow instanceof InternalWindow) {
            InternalWindow internalWindow = (InternalWindow)this.popupWindow;
            internalWindow.setRootView(this.rootView());
            Application.application().beginModalSessionForView(internalWindow);
        } else {
            ExternalWindow externalWindow = (ExternalWindow)this.popupWindow;
            Application.application().beginModalSessionForView(externalWindow.rootView());
        }
        this.popupWindow.show();
        this.rootView().setMouseView(this.popupList);
        if (mouseEvent != null) {
            this.popupList.mouseDown(this.convertEventToView(this.popupList, mouseEvent));
            return;
        }
        this.popupList.selectItem(this.selectedItem());
        this.rootView().makeSelectedView(this.popupList);
    }

    public boolean mouseDown(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return false;
        }
        this.layoutPopupWindow();
        this.showPopupWindow(mouseEvent);
        return true;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.setDirty(true);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isTransparent() {
        return this.popupList.isTransparent();
    }

    public void drawView(Graphics graphics) {
        Color color = null;
        Border border = this.container.border();
        if (this.selectedItem == null && this.popupList.selectedItem() == null) {
            this.selectItem(this.popupList.itemAt(0));
        }
        if (!this.popupList.isTransparent() && this.selectedItem != null && this.selectedItem.isTransparent()) {
            graphics.setColor(this.popupList.backgroundColor());
            graphics.fillRect(0, 0, this.width(), this.height());
        }
        if (this.selectedItem != null) {
            Rect rect = Rect.newRect(border.leftMargin(), border.topMargin(), this.bounds.width - border.widthMargin(), this.bounds.height - border.heightMargin());
            graphics.pushState();
            graphics.setClipRect(rect);
            if (!this.isEnabled()) {
                color = this.selectedItem.textColor();
                this.selectedItem.setTextColor(Color.gray);
            }
            this.selectedItem.drawInRect(graphics, rect);
            if (!this.isEnabled()) {
                this.selectedItem.setTextColor(color);
            }
            graphics.popState();
            Rect.returnRect(rect);
        }
        border.drawInRect(graphics, 0, 0, this.width(), this.height());
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public Target target() {
        return this.target;
    }

    public void setCommand(String string) {
        this.popupList.setCommand(string);
    }

    public String command() {
        return this.popupList.command();
    }

    public void sendCommand() {
        if (this.target != null) {
            String string = null;
            if (this.selectedItem != null) {
                string = this.selectedItem.command();
            }
            if (string == null) {
                string = this.command();
            }
            this.target.performCommand(string, this);
        }
    }

    public void performCommand(String string, Object object) {
        if (SELECT_NEXT_ITEM.equals(string)) {
            this.selectNextItem(true);
        } else if (SELECT_PREVIOUS_ITEM.equals(string)) {
            this.selectNextItem(false);
        } else if (POPUP.equals(string)) {
            this.layoutPopupWindow();
            this.wasSelectedItem = this.selectedItem();
            this._showingPopupForKeyboard = true;
            this.showPopupWindow(null);
            this._setupKeyboardToClosePopup(true);
        } else if (this.showingPopupForKeyboard()) {
            boolean bl = false;
            if (CLOSE_POPUP_AND_CANCEL.equals(string)) {
                this.selectItem(this.wasSelectedItem);
                bl = true;
            } else if (CLOSE_POPUP_AND_COMMIT.equals(string)) {
                this.selectItem(this.popupList.selectedItem());
                if (this.popupList.selectedItem() != null) {
                    this.sendCommand();
                }
                bl = true;
            }
            if (bl) {
                this.popupList.disableDrawing();
                this.popupList.deselectItem(this.popupList.selectedItem());
                this.popupList.reenableDrawing();
                this.popupWindow.hide();
                if (this.popupWindow instanceof InternalWindow) {
                    InternalWindow internalWindow = (InternalWindow)this.popupWindow;
                    Application.application().endModalSessionForView(internalWindow);
                } else {
                    ExternalWindow externalWindow = (ExternalWindow)this.popupWindow;
                    Application.application().endModalSessionForView(externalWindow.rootView());
                }
                this._setupKeyboardToClosePopup(false);
                this._showingPopupForKeyboard = false;
            }
        } else {
            if (this.popupList.selectedItem() != null) {
                this.selectedItem = this.popupList.selectedItem();
            }
            if (this.selectedItem != null) {
                this.sendCommand();
            }
            this.popupList.disableDrawing();
            this.popupList.deselectItem(this.selectedItem);
            this.popupList.reenableDrawing();
            this.popupWindow.hide();
            if (this.popupWindow instanceof InternalWindow) {
                InternalWindow internalWindow = (InternalWindow)this.popupWindow;
                Application.application().endModalSessionForView(internalWindow);
            } else {
                ExternalWindow externalWindow = (ExternalWindow)this.popupWindow;
                Application.application().endModalSessionForView(externalWindow.rootView());
            }
            this._setupKeyboardToClosePopup(false);
        }
        this.draw();
    }

    public Size minSize() {
        int n = 0;
        int n2 = 0;
        if (this.container.border() != null) {
            n = this.container.border().widthMargin();
            n2 = this.container.border().heightMargin();
        }
        int n3 = 0;
        int n4 = 0;
        if (this.popupList != null) {
            n3 = this.popupList.minItemWidth();
            n4 = this.popupList.minItemHeight();
        }
        int n5 = 0;
        int n6 = 0;
        if (this.image != null) {
            n5 = this.image.width();
            n6 = this.image.height();
        }
        n6 = n6 < n4 ? 0 : n4 - n6;
        return new Size(n + n3 + n5, n2 + n4 + n6);
    }

    public void describeClassInfo(ClassInfo classInfo) {
        super.describeClassInfo(classInfo);
        classInfo.addClass("netscape.application.Popup", 2);
        classInfo.addField(LISTVIEW_KEY, (byte)18);
        classInfo.addField(WINDOW_KEY, (byte)18);
        classInfo.addField(CONTAINER_KEY, (byte)18);
        classInfo.addField(SELECTEDITEM_KEY, (byte)18);
        classInfo.addField(TARGET_KEY, (byte)18);
        classInfo.addField(SELECTEDIMAGE_KEY, (byte)18);
        classInfo.addField(ENABLED_KEY, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(LISTVIEW_KEY, this.popupList);
        encoder.encodeObject(WINDOW_KEY, this.popupWindow);
        encoder.encodeObject(CONTAINER_KEY, this.container);
        encoder.encodeObject(SELECTEDITEM_KEY, this.selectedItem);
        encoder.encodeObject(TARGET_KEY, this.target);
        encoder.encodeObject(SELECTEDIMAGE_KEY, this.image);
        encoder.encodeBoolean(ENABLED_KEY, this.enabled);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.popupList = (ListView)decoder.decodeObject(LISTVIEW_KEY);
        this.popupWindow = (Window)decoder.decodeObject(WINDOW_KEY);
        this.container = (ContainerView)decoder.decodeObject(CONTAINER_KEY);
        this.selectedItem = (ListItem)decoder.decodeObject(SELECTEDITEM_KEY);
        this.target = (Target)decoder.decodeObject(TARGET_KEY);
        this.image = (Image)decoder.decodeObject(SELECTEDIMAGE_KEY);
        if (decoder.versionForClassName("netscape.application.Popup") > 1) {
            this.enabled = decoder.decodeBoolean(ENABLED_KEY);
        }
    }

    void _setupKeyboard() {
        this.removeAllCommandsForKeys();
        this.setCommandForKey(SELECT_NEXT_ITEM, 1005, 0);
        this.setCommandForKey(SELECT_PREVIOUS_ITEM, 1004, 0);
        this.setCommandForKey(POPUP, 10, 0);
        this.setCommandForKey(POPUP, 32, 0);
    }

    void selectNextItem(boolean bl) {
        int n = this.selectedIndex();
        int n2 = this.count();
        if (bl && n < n2 - 1) {
            this.selectItemAt(n + 1);
        } else if (!bl && n > 0) {
            this.selectItemAt(n - 1);
        }
        if (this.selectedItem() != null) {
            this.sendCommand();
        }
    }

    public boolean canBecomeSelectedView() {
        return true;
    }

    void _setupKeyboardToClosePopup(boolean bl) {
        if (bl) {
            this.setCommandForKey(CLOSE_POPUP_AND_CANCEL, 27, 2);
            this.setCommandForKey(CLOSE_POPUP_AND_COMMIT, 10, 2);
            return;
        }
        this.removeCommandForKey(27);
        this.setCommandForKey(POPUP, 10, 0);
    }

    protected void ancestorWillRemoveFromViewHierarchy(View view) {
        super.ancestorWillRemoveFromViewHierarchy(view);
        this.hidePopupIfNeeded();
    }

    public void hidePopupIfNeeded() {
        if (this.showingPopupForKeyboard()) {
            this.performCommand(CLOSE_POPUP_AND_CANCEL, this);
        }
    }

    public boolean showingPopupForKeyboard() {
        return this._showingPopupForKeyboard;
    }

    public String formElementText() {
        if (this.selectedItem() != null) {
            return this.selectedItem().title();
        }
        return "";
    }
}

