/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Color;
import netscape.application.DragDestination;
import netscape.application.DragSession;
import netscape.application.Graphics;
import netscape.application.MouseEvent;
import netscape.application.Point;
import netscape.application.Rect;
import netscape.application.Scrollable;
import netscape.application.Target;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Vector;

public class ScrollView
extends View
implements Scrollable {
    View contentView;
    Color backgroundColor;
    Rect clipRect;
    Vector scrollBars = new Vector();
    boolean transparent = false;
    private boolean scrollBarUpdatesEnabled = true;
    static final String CONTENTVIEW_KEY = "contentView";
    static final String BACKGROUNDC_KEY = "backgroundColor";
    static final String SCROLLERS_KEY = "scrollBars";
    static final String SCROLLERUPDATES_KEY = "scrollBarUpdatesEnabed";
    static final String TRANSPARENT_KEY = "transparent";

    public ScrollView() {
        this(0, 0, 0, 0);
    }

    public ScrollView(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public ScrollView(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.backgroundColor = Color.lightGray;
        this.setHorizResizeInstruction(2);
        this.setVertResizeInstruction(16);
    }

    public void addSubview(View view) {
        this.subviews().removeAllElements();
        super.addSubview(view);
    }

    public void setContentView(View view) {
        if (this.contentView != null) {
            this.contentView.removeFromSuperview();
        }
        this.contentView = view;
        if (this.contentView != null) {
            this.contentView.moveTo(0, 0);
            this.addSubview(this.contentView);
        }
        this.updateScrollBars();
    }

    public View contentView() {
        return this.contentView;
    }

    public int cursorForPoint(int n, int n2) {
        if (this.contentView == null) {
            return 0;
        }
        Point point = Point.newPoint(n, n2);
        this.convertPointToView(this.contentView, point, point);
        int n3 = this.contentView.cursorForPoint(point.x, point.y);
        Point.returnPoint(point);
        return n3;
    }

    public void setBackgroundColor(Color color) {
        if (color != null) {
            this.backgroundColor = color;
        }
    }

    public Color backgroundColor() {
        return this.backgroundColor;
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void addScrollBar(Target target) {
        this.scrollBars.addElementIfAbsent(target);
    }

    public void removeScrollBar(Target target) {
        this.scrollBars.removeElement(target);
    }

    public void setScrollBarUpdatesEnabled(boolean bl) {
        this.scrollBarUpdatesEnabled = bl;
    }

    public boolean scrollBarUpdatesEnabled() {
        return this.scrollBarUpdatesEnabled;
    }

    public void updateScrollBars() {
        if (!this.scrollBarUpdatesEnabled) {
            return;
        }
        int n = this.scrollBars.count();
        int n2 = 0;
        while (n2 < n) {
            Target target = (Target)this.scrollBars.elementAt(n2);
            target.performCommand("updateScrollValue", this);
            ++n2;
        }
    }

    View scrollingView() {
        return this;
    }

    public void scrollRectToVisible(Rect rect) {
        int n = 0;
        int n2 = 0;
        if (rect == null || this.contentView == null) {
            return;
        }
        n = this.positionAdjustment(this.bounds.width, rect.width, rect.x);
        n2 = this.positionAdjustment(this.bounds.height, rect.height, rect.y);
        if (n != 0 || n2 != 0) {
            this.scrollBy(n, n2);
        }
    }

    private int positionAdjustment(int n, int n2, int n3) {
        if (n3 >= 0 && n2 + n3 <= n) {
            return 0;
        }
        if (n3 <= 0 && n2 + n3 >= n) {
            return 0;
        }
        if (n3 > 0 && n2 <= n) {
            return -n3 + n - n2;
        }
        if (n3 >= 0 && n2 >= n) {
            return -n3;
        }
        if (n3 <= 0 && n2 <= n) {
            return -n3;
        }
        if (n3 < 0 && n2 >= n) {
            return -n3 + n - n2;
        }
        return 0;
    }

    public void scrollTo(int n, int n2) {
        boolean bl;
        Rect rect = null;
        if (this.contentView == null) {
            return;
        }
        this.setClipRect(null);
        if (n > 0 || this.bounds.width >= this.contentView.bounds.width) {
            n = 0;
        } else if (n < this.bounds.width - this.contentView.bounds.width) {
            n = this.bounds.width - this.contentView.bounds.width;
        }
        if (n2 > 0 || this.bounds.height >= this.contentView.bounds.height) {
            n2 = 0;
        } else if (n2 < this.bounds.height - this.contentView.bounds.height) {
            n2 = this.bounds.height - this.contentView.bounds.height;
        }
        int n3 = n - this.contentView.bounds.x;
        int n4 = n2 - this.contentView.bounds.y;
        if (n3 == 0 && n4 == 0) {
            this.updateScrollBars();
            return;
        }
        boolean bl2 = bl = this.isBuffered() && this.drawingBufferValid;
        if (bl) {
            if (n3 != 0 && n4 == 0 && Math.abs(n3) < this.bounds.width) {
                rect = n3 < 0 ? Rect.newRect(this.bounds.width + n3, 0, -n3, this.bounds.height) : Rect.newRect(0, 0, n3, this.bounds.height);
            } else if (n3 == 0 && n4 != 0 && Math.abs(n4) < this.bounds.height) {
                rect = n4 < 0 ? Rect.newRect(0, this.bounds.height + n4, this.bounds.width, -n4) : Rect.newRect(0, 0, this.bounds.width, n4);
            }
            if (rect != null) {
                this.contentView.moveTo(n, n2);
                this.setClipRect(rect);
                Rect.returnRect(rect);
            } else {
                this.contentView.moveTo(n, n2);
            }
        } else {
            this.contentView.moveTo(n, n2);
        }
        if (this.scrollBarUpdatesEnabled) {
            this.updateScrollBars();
        }
        this.setDirty(true);
    }

    public void scrollBy(int n, int n2) {
        if (this.contentView != null) {
            this.scrollTo(this.contentView.bounds.x + n, this.contentView.bounds.y + n2);
        }
    }

    public void subviewDidResize(View view) {
        if (view != this.contentView) {
            return;
        }
        this.scrollBy(0, 0);
        this.drawBackground();
    }

    public void didSizeBy(int n, int n2) {
        super.didSizeBy(n, n2);
        this.scrollBy(0, 0);
    }

    void setClipRect(Rect rect) {
        if (this.clipRect != null) {
            Rect.returnRect(this.clipRect);
        }
        if (rect != null) {
            this.clipRect = Rect.newRect(rect);
            return;
        }
        this.clipRect = null;
    }

    void updateDrawingBuffer(Rect rect) {
        if (this.clipRect != null && this.isBuffered() && !this.isTransparent()) {
            Graphics graphics = this.drawingBuffer.createGraphics();
            graphics.setDebugOptions(this.shouldDebugGraphics());
            if (this.clipRect.height != this.bounds.height) {
                if (this.clipRect.y == 0) {
                    graphics.copyArea(this.clipRect.x, this.clipRect.y, this.clipRect.width, this.bounds.height - this.clipRect.height, this.clipRect.x, this.clipRect.maxY());
                } else {
                    graphics.copyArea(0, this.clipRect.height, this.clipRect.width, this.bounds.height - this.clipRect.height, 0, 0);
                }
            } else if (this.clipRect.x == 0) {
                graphics.copyArea(this.clipRect.x, this.clipRect.y, this.bounds.width - this.clipRect.width, this.clipRect.height, this.clipRect.maxX(), this.clipRect.y);
            } else {
                graphics.copyArea(this.clipRect.width, 0, this.bounds.width - this.clipRect.width, this.clipRect.height, 0, 0);
            }
            graphics.dispose();
            graphics = null;
            rect = new Rect(rect);
            Rect rect2 = new Rect(0, 0, 0, 0);
            this.contentView.getDirtyRect(rect2);
            if (rect2.isEmpty()) {
                rect.intersectWith(this.clipRect);
            } else {
                rect2.unionWith(this.clipRect);
                rect.intersectWith(rect2);
            }
            this.setClipRect(null);
        }
        super.updateDrawingBuffer(rect);
    }

    public void computeVisibleRect(Rect rect) {
        super.computeVisibleRect(rect);
        if (this.clipRect != null) {
            rect.intersectWith(this.clipRect);
        }
    }

    public void drawView(Graphics graphics) {
        int n;
        int n2;
        if (this.isTransparent()) {
            return;
        }
        if (this.contentView != null && this.contentView.isTransparent()) {
            graphics.setColor(this.backgroundColor);
            Rect rect = graphics.clipRect();
            graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
            return;
        }
        if (this.contentView != null) {
            n2 = this.bounds.width - this.contentView.bounds.width;
            n = this.bounds.height - this.contentView.bounds.height;
        } else {
            n2 = this.bounds.width;
            n = this.bounds.height;
        }
        if (n2 > 0) {
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(this.bounds.width - n2, 0, n2, this.bounds.height);
        }
        if (n > 0) {
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(0, this.bounds.height - n, this.bounds.width, n);
        }
        if (this.clipRect != null && this.isBuffered()) {
            if (this.clipRect.y == this.bounds.y) {
                this.drawingBuffer.drawAt(graphics, this.clipRect.x, this.clipRect.maxY());
                return;
            }
            this.drawingBuffer.drawAt(graphics, this.clipRect.x, -this.clipRect.height);
        }
    }

    public void drawSubviews(Graphics graphics) {
        super.drawSubviews(graphics);
        this.setClipRect(null);
    }

    void drawBackground() {
        int n;
        int n2;
        if (this.contentView != null) {
            n2 = this.bounds.width - this.contentView.bounds.width;
            n = this.bounds.height - this.contentView.bounds.height;
        } else {
            n2 = this.bounds.width;
            n = this.bounds.height;
        }
        Rect rect = Rect.newRect();
        if (n2 > 0) {
            rect.setBounds(this.bounds.width - n2, 0, n2, this.bounds.height);
            this.addDirtyRect(rect);
        }
        if (n > 0) {
            rect.setBounds(0, this.bounds.height - n, this.bounds.width, n);
            this.addDirtyRect(rect);
        }
        Rect.returnRect(rect);
    }

    public boolean mouseDown(MouseEvent mouseEvent) {
        if (this.contentView != null) {
            boolean bl = this.contentView.mouseDown(this.convertEventToView(this.contentView, mouseEvent));
            if (bl) {
                this.rootView().setMouseView(this.contentView);
                return true;
            }
            return false;
        }
        return false;
    }

    public DragDestination acceptsDrag(DragSession dragSession, int n, int n2) {
        if (this.contentView != null) {
            return this.contentView.acceptsDrag(dragSession, n - this.contentView.bounds.x, n2 - this.contentView.bounds.y);
        }
        return null;
    }

    public int lengthOfScrollViewForAxis(int n) {
        if (n == 0) {
            return this.bounds.width;
        }
        return this.bounds.height;
    }

    public int lengthOfContentViewForAxis(int n) {
        if (this.contentView == null) {
            return 0;
        }
        if (n == 0) {
            return this.contentView.bounds.width;
        }
        return this.contentView.bounds.height;
    }

    public int positionOfContentViewForAxis(int n) {
        if (this.contentView == null) {
            return 0;
        }
        if (n == 0) {
            return this.contentView.bounds.x;
        }
        return this.contentView.bounds.y;
    }

    public void describeClassInfo(ClassInfo classInfo) {
        super.describeClassInfo(classInfo);
        classInfo.addClass("netscape.application.ScrollView", 1);
        classInfo.addField(CONTENTVIEW_KEY, (byte)18);
        classInfo.addField(BACKGROUNDC_KEY, (byte)18);
        classInfo.addField(SCROLLERS_KEY, (byte)18);
        classInfo.addField(SCROLLERUPDATES_KEY, (byte)0);
        classInfo.addField(TRANSPARENT_KEY, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(CONTENTVIEW_KEY, this.contentView);
        encoder.encodeObject(BACKGROUNDC_KEY, this.backgroundColor);
        encoder.encodeObject(SCROLLERS_KEY, this.scrollBars);
        encoder.encodeBoolean(SCROLLERUPDATES_KEY, this.scrollBarUpdatesEnabled);
        encoder.encodeBoolean(TRANSPARENT_KEY, this.transparent);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.contentView = (View)decoder.decodeObject(CONTENTVIEW_KEY);
        this.backgroundColor = (Color)decoder.decodeObject(BACKGROUNDC_KEY);
        this.scrollBars = (Vector)decoder.decodeObject(SCROLLERS_KEY);
        this.scrollBarUpdatesEnabled = decoder.decodeBoolean(SCROLLERUPDATES_KEY);
        this.transparent = decoder.decodeBoolean(TRANSPARENT_KEY);
    }
}

