/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.FelixBundle;
import org.apache.felix.framework.URLHandlers;
import org.apache.felix.framework.util.Util;
import org.apache.felix.moduleloader.IModule;

class URLHandlersBundleURLConnection
extends URLConnection {
    private Felix m_framework;
    private IModule m_targetModule;
    private int m_classPathIdx = -1;
    private int m_contentLength;
    private long m_contentTime;
    private String m_contentType;
    private InputStream m_is;

    public URLHandlersBundleURLConnection(URL url) {
        super(url);
    }

    public URLHandlersBundleURLConnection(URL url, Felix framework) throws IOException {
        super(url);
        this.m_framework = framework;
        if (this.m_framework == null) {
            this.m_framework = (Felix)URLHandlers.getFrameworkFromContext();
        }
        if (this.m_framework == null) {
            throw new IOException("Unable to find framework for URL: " + url);
        }
        long bundleId = Util.getBundleIdFromModuleId(url.getHost());
        FelixBundle bundle = (FelixBundle)this.m_framework.getBundle(bundleId);
        if (bundle == null) {
            throw new IOException("No bundle associated with resource: " + url);
        }
        int revision = Util.getModuleRevisionFromModuleId(url.getHost());
        IModule[] modules = bundle.getInfo().getModules();
        if (modules == null || revision < 0 || revision >= modules.length) {
            throw new IOException("Resource does not exist: " + url);
        }
        this.m_targetModule = modules[revision];
        this.m_classPathIdx = url.getPort();
        if (!modules[revision].getContentLoader().hasInputStream(this.m_classPathIdx, url.getPath())) {
            URL newurl = modules[revision].getContentLoader().getResource(url.getPath());
            if (newurl == null) {
                throw new IOException("Resource does not exist: " + url);
            }
            this.m_classPathIdx = newurl.getPort();
        }
    }

    public synchronized void connect() throws IOException {
        if (!this.connected) {
            if (this.m_targetModule == null || this.m_classPathIdx < 0) {
                throw new IOException("Resource does not exist: " + this.url);
            }
            this.m_is = this.m_targetModule.getContentLoader().getInputStream(this.m_classPathIdx, this.url.getPath());
            this.m_contentLength = this.m_is == null ? 0 : this.m_is.available();
            this.m_contentTime = 0L;
            this.m_contentType = URLConnection.guessContentTypeFromName(this.url.getFile());
            this.connected = true;
        }
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.m_is;
    }

    public int getContentLength() {
        try {
            this.connect();
        }
        catch (IOException ex) {
            return -1;
        }
        return this.m_contentLength;
    }

    public long getLastModified() {
        try {
            this.connect();
        }
        catch (IOException ex) {
            return 0L;
        }
        if (this.m_contentTime != -1L) {
            return this.m_contentTime;
        }
        return 0L;
    }

    public String getContentType() {
        try {
            this.connect();
        }
        catch (IOException ex) {
            return null;
        }
        return this.m_contentType;
    }

    public Permission getPermission() {
        return null;
    }
}

