/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.montecarlo;

import org.jquantlib.math.randomnumbers.RandomNumberGenerator;
import org.jquantlib.math.randomnumbers.RandomSequenceGeneratorIntf;
import org.jquantlib.methods.montecarlo.BrownianBridge;
import org.jquantlib.methods.montecarlo.Path;
import org.jquantlib.methods.montecarlo.Sample;
import org.jquantlib.processes.StochasticProcess1D;
import org.jquantlib.time.TimeGrid;

public class PathGenerator<RNG extends RandomNumberGenerator, GSG extends RandomSequenceGeneratorIntf> {
    private boolean brownianBridge_;
    private GSG generator_;
    private int dimension_;
    private TimeGrid timeGrid_;
    private StochasticProcess1D process_;
    private double[] temp_;
    private BrownianBridge bb_;

    public PathGenerator(StochasticProcess1D process, double length, int timeSteps, GSG generator, boolean brownianBridge) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.brownianBridge_ = brownianBridge;
        this.generator_ = generator;
        this.dimension_ = generator.dimension();
        this.timeGrid_ = new TimeGrid(length, timeSteps);
        this.process_ = process;
        this.temp_ = new double[this.dimension_];
        this.bb_ = new BrownianBridge(this.timeGrid_);
        if (this.dimension_ != timeSteps) {
            throw new IllegalArgumentException("sequence generator dimensionality (" + this.dimension_ + ") != timeSteps (" + timeSteps + ")");
        }
    }

    public PathGenerator(StochasticProcess1D process, TimeGrid timeGrid, GSG generator, boolean brownianBridge) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.brownianBridge_ = brownianBridge;
        this.generator_ = generator;
        this.dimension_ = generator.dimension();
        this.timeGrid_ = timeGrid;
        this.process_ = process;
        this.temp_ = new double[this.dimension_];
        this.bb_ = new BrownianBridge(this.timeGrid_);
        if (this.dimension_ != this.timeGrid_.size() - 1) {
            throw new IllegalArgumentException("sequence generator dimensionality (" + this.dimension_ + ") != timeSteps (" + (this.timeGrid_.size() - 1) + ")");
        }
    }

    private final Sample<Path> next() {
        return this.next(false);
    }

    public final Sample<Path> antithetic() {
        return this.next(true);
    }

    public final Sample<Path> next(boolean antithetic) {
        return null;
    }
}

