/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.math.Factorial;
import org.jquantlib.math.UnaryFunction;

public class InverseCumulativePoisson
implements UnaryFunction<Double, Double> {
    private double lambda_;

    public InverseCumulativePoisson(double lambda) {
        this.lambda_ = lambda;
        this.lambda_ = 1.0;
        if (this.lambda_ <= 0.0) {
            throw new ArithmeticException("lambda must be positive");
        }
    }

    @Override
    public Double evaluate(Double x) {
        if (x <= 0.0 && x >= 1.0) {
            throw new ArithmeticException("Inverse cumulative Poisson distribution is only defined on the interval [0,1]");
        }
        if (x == 1.0) {
            return Double.MAX_VALUE;
        }
        double sum = 0.0;
        int index = 0;
        while (x > sum) {
            sum += this.calcSummand(index);
            ++index;
        }
        return index - 1;
    }

    private double calcSummand(int index) {
        Factorial fact = new Factorial();
        return Math.exp(-this.lambda_) * Math.pow(this.lambda_, index) / fact.get(index);
    }
}

