/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.math.UnaryFunctionDouble;
import org.jquantlib.math.distributions.NormalDistribution;

public class MoroInverseCumulativeNormal
extends NormalDistribution
implements UnaryFunctionDouble {
    static final double a0_ = 2.50662823884;
    static final double a1_ = -18.61500062529;
    static final double a2_ = 41.39119773534;
    static final double a3_ = -25.44106049637;
    static final double b0_ = -8.4735109309;
    static final double b1_ = 23.08336743743;
    static final double b2_ = -21.06224101826;
    static final double b3_ = 3.13082909833;
    static final double c0_ = 0.3374754822726147;
    static final double c1_ = 0.9761690190917186;
    static final double c2_ = 0.1607979714918209;
    static final double c3_ = 0.0276438810333863;
    static final double c4_ = 0.0038405729373609;
    static final double c5_ = 3.951896511919E-4;
    static final double c6_ = 3.21767881768E-5;
    static final double c7_ = 2.888167364E-7;
    static final double c8_ = 3.960315187E-7;

    public MoroInverseCumulativeNormal() {
    }

    public MoroInverseCumulativeNormal(double average, double sigma) {
        super(average, sigma);
    }

    @Override
    public double evaluate(double x) {
        double result;
        double temp = x - 0.5;
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return 1.0;
        }
        if (Math.abs(temp) < 0.42) {
            result = temp * temp;
            result = temp * (((-25.44106049637 * result + 41.39119773534) * result + -18.61500062529) * result + 2.50662823884) / ((((3.13082909833 * result + -21.06224101826) * result + 23.08336743743) * result + -8.4735109309) * result + 1.0);
        } else {
            result = x < 0.5 ? x : 1.0 - x;
            result = Math.log(-Math.log(result));
            result = 0.3374754822726147 + result * (0.9761690190917186 + result * (0.1607979714918209 + result * (0.0276438810333863 + result * (0.0038405729373609 + result * (3.951896511919E-4 + result * (3.21767881768E-5 + result * (2.888167364E-7 + result * 3.960315187E-7)))))));
            if (x < 0.5) {
                result = -result;
            }
        }
        return this.average + result * this.sigma;
    }
}

