/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.processes;

import cern.colt.function.DoubleFunction;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Mult;
import org.jquantlib.processes.LinearDiscretization;
import org.jquantlib.processes.StochasticProcess;
import org.jquantlib.processes.StochasticProcess1D;

public class EulerDiscretization
implements LinearDiscretization {
    @Override
    public double[] driftDiscretization(StochasticProcess sp, double t0, double[] x0, double dt) {
        return new DenseDoubleMatrix1D(sp.drift(t0, x0)).assign((DoubleFunction)Mult.mult((double)dt)).toArray();
    }

    @Override
    public double[][] diffusionDiscretization(StochasticProcess sp, double t0, double[] x0, double dt) {
        return new DenseDoubleMatrix2D(sp.diffusion(t0, x0)).assign((DoubleFunction)Mult.mult((double)Math.sqrt(dt))).toArray();
    }

    @Override
    public double[][] covarianceDiscretization(StochasticProcess sp, double t0, double[] x0, double dt) {
        DenseDoubleMatrix2D sigma = new DenseDoubleMatrix2D(sp.diffusion(t0, x0));
        DoubleMatrix2D sigmaT = new Algebra().transpose((DoubleMatrix2D)sigma);
        return sigma.zMult(sigmaT, null, dt, 0.0, false, false).toArray();
    }

    @Override
    public double driftDiscretization(StochasticProcess1D sp, double t0, double x0, double dt) {
        return sp.drift(t0, x0) * dt;
    }

    @Override
    public double diffusionDiscretization(StochasticProcess1D sp, double t0, double x0, double dt) {
        return sp.diffusion(t0, x0) * Math.sqrt(dt);
    }

    @Override
    public double varianceDiscretization(StochasticProcess1D sp, double t0, double x0, double dt) {
        double sigma = sp.diffusion(t0, x0);
        return sigma * sigma * dt;
    }
}

