/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.util;

import java.util.Collection;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.jquantlib.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class TimeSeries<T> {
    private static final Logger logger = LoggerFactory.getLogger(TimeSeries.class);
    private final NavigableMap<Date, T> map = new TreeMap<Date, T>();

    public TimeSeries() {
    }

    public TimeSeries(Date[] dates, T[] values) {
        this();
        if (dates.length != values.length) {
            String msg = MessageFormatter.arrayFormat((String)"size mismatch({}, {})", (Object[])new Object[]{dates.length, values.length});
            logger.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        for (int i = 0; i < dates.length; ++i) {
            this.map.put(dates[i], values[i]);
        }
    }

    public TimeSeries(Date startingDate, List<T> values) {
        this();
        Date tmp = startingDate;
        for (int i = 0; i < values.size(); ++i) {
            this.map.put(tmp, values.get(i));
            tmp = startingDate.getDateAfter(i);
        }
    }

    public Date firstDate() {
        return (Date)this.map.firstKey();
    }

    public Date lastDate() {
        return (Date)this.map.lastKey();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public T find(Date d) {
        return (T)this.map.get(d);
    }

    public void add(Date date, T dt) {
        this.map.put(date, dt);
    }

    public Date[] dates() {
        return this.map.keySet().toArray(new Date[0]);
    }

    public Collection<T> values() {
        return this.map.values();
    }
}

