/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.task;

import java.io.File;
import org.apache.felix.ipojo.manipulator.Pojoization;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class IPojoTask
extends Task {
    private File m_metadata;
    private File m_input;
    private File m_output;
    private boolean m_ignoreAnnotations = false;

    public void setMetadata(File meta) {
        this.m_metadata = meta;
    }

    public void setInput(File in) {
        this.m_input = in;
    }

    public void setOutput(File out) {
        this.m_output = out;
    }

    public void setIgnoreAnnotations(boolean flag) {
        this.m_ignoreAnnotations = flag;
    }

    public void execute() {
        String out;
        boolean r;
        if (this.m_input == null) {
            throw new BuildException("No input bundle specified");
        }
        if (!this.m_input.exists()) {
            throw new BuildException("The input bundle " + this.m_input.getAbsolutePath() + " does not exist");
        }
        this.log("Input Bundle File : " + this.m_input.getAbsolutePath());
        if (this.m_metadata == null) {
            this.m_metadata = new File("./metadata.xml");
            if (!this.m_metadata.exists()) {
                if (this.m_ignoreAnnotations) {
                    this.log("No metadata file found & ignore annotations : nothing to do");
                    return;
                }
                this.log("No metadata file found - try to use only annotations");
                this.m_metadata = null;
            } else {
                this.log("Metadata File : " + this.m_metadata.getAbsolutePath());
            }
        } else {
            if (!this.m_metadata.exists()) {
                throw new BuildException("No metadata file found - the file " + this.m_metadata.getAbsolutePath() + " does not exist");
            }
            this.log("Metadata File : " + this.m_metadata.getAbsolutePath());
        }
        this.log("Start bundle manipulation");
        if (this.m_output == null) {
            this.m_output = new File("./_out.jar");
        }
        if (this.m_output.exists() && !(r = this.m_output.delete())) {
            throw new BuildException("The file " + this.m_output.getAbsolutePath() + " cannot be deleted");
        }
        Pojoization pojo = new Pojoization();
        if (!this.m_ignoreAnnotations) {
            pojo.setAnnotationProcessing();
        }
        pojo.pojoization(this.m_input, this.m_output, this.m_metadata);
        for (int i = 0; i < pojo.getWarnings().size(); ++i) {
            this.log((String)pojo.getWarnings().get(i));
        }
        if (pojo.getErrors().size() > 0) {
            throw new BuildException((String)pojo.getErrors().get(0));
        }
        if (this.m_output.getName().equals("_out.jar")) {
            this.m_input.delete();
            this.m_output.renameTo(this.m_input);
            out = this.m_input.getAbsolutePath();
        } else {
            out = this.m_output.getAbsolutePath();
        }
        this.log("Bundle manipulation - SUCCESS");
        this.log("Output File : " + out);
    }
}

