/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal;

import java.util.Dictionary;
import org.jetbrains.annotations.NotNull;

public class HttpConfig {
    public static final String PROP_INVALIDATE_SESSION = "org.apache.felix.http.session.invalidate";
    public static final boolean DEFAULT_INVALIDATE_SESSION = true;
    public static final String PROP_UNIQUE_SESSION_ID = "org.apache.felix.http.session.uniqueid";
    public static final boolean DEFAULT_UNIQUE_SESSION_ID = true;
    private volatile boolean uniqueSessionId;
    private volatile boolean invalidateContainerSession;

    public boolean isUniqueSessionId() {
        return this.uniqueSessionId;
    }

    public void setUniqueSessionId(boolean appendSessionId) {
        this.uniqueSessionId = appendSessionId;
    }

    public boolean isInvalidateContainerSession() {
        return this.invalidateContainerSession;
    }

    public void setInvalidateContainerSession(boolean invalidateContainerSession) {
        this.invalidateContainerSession = invalidateContainerSession;
    }

    public void configure(@NotNull Dictionary<String, Object> props) {
        this.setUniqueSessionId(this.getBooleanProperty(props, PROP_UNIQUE_SESSION_ID, true));
        this.setInvalidateContainerSession(this.getBooleanProperty(props, PROP_INVALIDATE_SESSION, true));
    }

    private boolean getBooleanProperty(Dictionary<String, Object> props, String name, boolean defValue) {
        Object v = props.get(name);
        if (v != null) {
            String value = String.valueOf(v);
            return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
        }
        return defValue;
    }
}

