/*
 * Decompiled with CFR 0.152.
 */
package aQute.maven.repo.api;

import aQute.bnd.version.MavenVersion;
import aQute.maven.repo.api.Archive;
import aQute.maven.repo.api.Program;
import java.nio.file.Path;

public class Revision {
    public final Program program;
    public final String group;
    public final String artifact;
    public final MavenVersion version;
    public final String path;

    Revision(Program program, MavenVersion version) {
        this.program = program;
        this.group = program.group;
        this.artifact = program.artifact;
        this.version = version;
        this.path = String.valueOf(program.path) + "/" + version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + super.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Revision other = (Revision)obj;
        if (!this.version.equals((Object)other.version)) {
            return false;
        }
        return this.program.equals(other.program);
    }

    public boolean isSnapshot() {
        return this.version.isSnapshot();
    }

    public Archive archive(String extension, String classifier) {
        return new Archive(this, null, extension, classifier);
    }

    public Archive archive(MavenVersion version, String extension, String classifier) {
        return new Archive(this, version, extension, classifier);
    }

    public String metadata() {
        return String.valueOf(this.path) + "/maven-metadata.xml";
    }

    public String metadata(String id) {
        return String.valueOf(this.path) + "/maven-metadata-" + id + ".xml";
    }

    public String toString() {
        return String.valueOf(this.program.toString()) + ":" + this.version;
    }

    public Archive pomArchive() {
        return this.archive("pom", null);
    }

    public static Revision fromProjectPath(Path projectDirPath) {
        int l = projectDirPath.getNameCount();
        if (l < 3) {
            return null;
        }
        String version = projectDirPath.getName(l - 1).toString();
        String artifact = projectDirPath.getName(l - 2).toString();
        StringBuilder sb = new StringBuilder();
        String del = "";
        int i = 0;
        while (i < l - 2) {
            sb.append(del).append(projectDirPath.getName(i));
            del = ".";
            ++i;
        }
        String group = sb.toString();
        return Program.valueOf(group, artifact).version(version);
    }

    public Archive getPomArchive() {
        return this.archive("pom", null);
    }
}

