/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.eclipse;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.publisher.eclipse.BrandingIron;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ExecutablesDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.ConfigCUsAction;
import org.eclipse.equinox.p2.publisher.eclipse.IBrandingAdvice;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;

public class EquinoxExecutableAction
extends AbstractPublisherAction {
    private static String TYPE = "executable";
    protected String configSpec;
    protected String idBase;
    protected Version version;
    protected ExecutablesDescriptor executables;
    protected String flavor;
    static /* synthetic */ Class class$0;

    protected EquinoxExecutableAction() {
    }

    public EquinoxExecutableAction(ExecutablesDescriptor executables, String configSpec, String idBase, Version version, String flavor) {
        this.executables = executables;
        this.configSpec = configSpec;
        this.idBase = idBase == null ? "org.eclipse" : idBase;
        this.version = version;
        this.flavor = flavor;
    }

    public IStatus perform(IPublisherInfo info, IPublisherResult result, IProgressMonitor monitor) {
        ExecutablesDescriptor brandedExecutables = this.brandExecutables(info, this.executables);
        try {
            this.publishExecutableIU(info, brandedExecutables, result);
            this.publishExecutableCU(info, brandedExecutables, result);
            this.publishExecutableSetter(brandedExecutables, result);
        }
        finally {
            if (brandedExecutables.isTemporary()) {
                FileUtils.deleteAll((File)brandedExecutables.getLocation());
            }
        }
        return Status.OK_STATUS;
    }

    private void publishExecutableSetter(ExecutablesDescriptor brandedExecutables, IPublisherResult result) {
        MetadataFactory.InstallableUnitDescription iud = new MetadataFactory.InstallableUnitDescription();
        String executableName = brandedExecutables.getExecutableName();
        String id = String.valueOf(this.getExecutableId()) + '.' + executableName;
        iud.setId(id);
        iud.setVersion(this.version);
        iud.setTouchpointType(PublisherHelper.TOUCHPOINT_OSGI);
        iud.setCapabilities(new IProvidedCapability[]{this.createSelfCapability(id, this.version)});
        String filter = this.createFilterSpec(this.configSpec);
        if (filter.length() > 0) {
            iud.setFilter(filter);
        }
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("configure", "setLauncherName(name:" + executableName + ")");
        touchpointData.put("unconfigure", "setLauncherName()");
        iud.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        result.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud), "root");
    }

    protected void publishExecutableIU(IPublisherInfo info, ExecutablesDescriptor execDescriptor, IPublisherResult result) {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        String id = this.getExecutableId();
        iu.setId(id);
        iu.setVersion(this.version);
        String filter = this.createFilterSpec(this.configSpec);
        iu.setFilter(filter);
        iu.setSingleton(true);
        iu.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        String namespace = ConfigCUsAction.getAbstractCUCapabilityNamespace(this.idBase, TYPE, this.flavor, this.configSpec);
        String capabilityId = ConfigCUsAction.getAbstractCUCapabilityId(this.idBase, TYPE, this.flavor, this.configSpec);
        IProvidedCapability executableCapability = MetadataFactory.createProvidedCapability((String)namespace, (String)capabilityId, (Version)this.version);
        IProvidedCapability selfCapability = this.createSelfCapability(id, this.version);
        iu.setCapabilities(new IProvidedCapability[]{selfCapability, executableCapability});
        ArtifactKey key = PublisherHelper.createBinaryArtifactKey(id, this.version);
        iu.setArtifacts(new IArtifactKey[]{key});
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, null);
        this.publishArtifact(descriptor, execDescriptor.getFiles(), null, info, this.createRootPrefixComputer(execDescriptor.getLocation()));
        if (execDescriptor.isTemporary()) {
            FileUtils.deleteAll((File)execDescriptor.getLocation());
        }
        String[] config = EquinoxExecutableAction.parseConfigSpec(this.configSpec);
        String ws = config[0];
        String os = config[1];
        String arch = config[2];
        String launcherFragment = "org.eclipse.equinox.launcher." + ws + '.' + os;
        if (!"macosx".equals(os) || "x86_64".equals(arch)) {
            launcherFragment = String.valueOf(launcherFragment) + '.' + arch;
        }
        iu.setRequiredCapabilities(new IRequiredCapability[]{MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)launcherFragment, (VersionRange)VersionRange.emptyRange, (String)filter, (boolean)false, (boolean)false)});
        result.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu), "root");
    }

    private String getExecutableId() {
        return this.createCUIdString(this.idBase, TYPE, "", this.configSpec);
    }

    private void publishExecutableCU(IPublisherInfo info, ExecutablesDescriptor execDescriptor, IPublisherResult result) {
        MetadataFactory.InstallableUnitFragmentDescription cu = new MetadataFactory.InstallableUnitFragmentDescription();
        String id = this.createCUIdString(this.idBase, TYPE, this.flavor, this.configSpec);
        cu.setId(id);
        cu.setVersion(this.version);
        cu.setFilter(this.createFilterSpec(this.configSpec));
        String executableId = this.getExecutableId();
        cu.setHost(new IRequiredCapability[]{MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)executableId, (VersionRange)new VersionRange(this.version, true, this.version, true), null, (boolean)false, (boolean)false)});
        cu.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        cu.setCapabilities(new IProvidedCapability[]{PublisherHelper.createSelfCapability(id, this.version)});
        cu.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        String[] config = EquinoxExecutableAction.parseConfigSpec(this.configSpec);
        String os = config[1];
        Map touchpointData = this.computeInstallActions(execDescriptor, os);
        cu.addTouchpointData(MetadataFactory.createTouchpointData((Map)touchpointData));
        IInstallableUnit unit = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu);
        result.addIU(unit, "root");
    }

    private Map computeInstallActions(ExecutablesDescriptor execDescriptor, String os) {
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        String configurationData = "unzip(source:@artifact, target:${installFolder});";
        if ("macosx".equals(os)) {
            String execName = execDescriptor.getExecutableName();
            configurationData = String.valueOf(configurationData) + " chmod(targetDir:${installFolder}/" + execName + ".app/Contents/MacOS/, targetFile:" + execName + ", permissions:755);";
        } else if (!"win32".equals(os)) {
            File[] fileList = execDescriptor.getFiles();
            int i = 0;
            while (i < fileList.length) {
                configurationData = String.valueOf(configurationData) + " chmod(targetDir:${installFolder}, targetFile:" + fileList[i].getName() + ", permissions:755);";
                ++i;
            }
        }
        touchpointData.put("install", configurationData);
        String unConfigurationData = "cleanupzip(source:@artifact, target:${installFolder});";
        touchpointData.put("uninstall", unConfigurationData);
        return touchpointData;
    }

    protected ExecutablesDescriptor brandExecutables(IPublisherInfo info, ExecutablesDescriptor descriptor) {
        ExecutablesDescriptor result = new ExecutablesDescriptor(descriptor);
        result.makeTemporaryCopy();
        IBrandingAdvice advice = this.getBrandingAdvice(info);
        if (advice == null) {
            this.partialBrandExecutables(result);
        } else {
            this.fullBrandExecutables(result, advice);
        }
        return result;
    }

    private IBrandingAdvice getBrandingAdvice(IPublisherInfo info) {
        Collection advice;
        Iterator i;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.p2.publisher.eclipse.IBrandingAdvice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((i = (advice = info.getAdvice(this.configSpec, true, null, null, clazz)).iterator()).hasNext()) {
            return (IBrandingAdvice)i.next();
        }
        return null;
    }

    protected void fullBrandExecutables(ExecutablesDescriptor descriptor, IBrandingAdvice advice) {
        BrandingIron iron = new BrandingIron();
        iron.setIcons(advice.getIcons());
        String name = advice.getExecutableName();
        if (name == null) {
            name = "eclipse";
        }
        iron.setName(name);
        iron.setOS(advice.getOS());
        iron.setRoot(descriptor.getLocation().getAbsolutePath());
        try {
            iron.brand();
            descriptor.setExecutableName(name, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void partialBrandExecutables(ExecutablesDescriptor descriptor) {
        File[] list = descriptor.getFiles();
        int i = 0;
        while (i < list.length) {
            this.mungeExecutableFileName(list[i], descriptor);
            ++i;
        }
        descriptor.setExecutableName("eclipse", true);
    }

    private void mungeExecutableFileName(File file, ExecutablesDescriptor descriptor) {
        if (file.getName().equals("launcher")) {
            File newFile = new File(file.getParentFile(), "eclipse");
            file.renameTo(newFile);
            descriptor.replace(file, newFile);
        } else if (file.getName().equals("launcher.exe")) {
            File newFile = new File(file.getParentFile(), "eclipse.exe");
            file.renameTo(newFile);
            descriptor.replace(file, newFile);
        }
    }
}

