/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.parser;

import org.eclipse.equinox.ds.model.ComponentDescription;
import org.eclipse.equinox.ds.model.ServiceDescription;
import org.eclipse.equinox.ds.parser.ComponentElement;
import org.eclipse.equinox.ds.parser.ElementHandler;
import org.eclipse.equinox.ds.parser.ParserHandler;
import org.eclipse.equinox.ds.parser.ProvideElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class ServiceElement
extends ElementHandler {
    private ComponentElement parent;
    private ServiceDescription service;

    public ServiceElement(ParserHandler root, ComponentElement parent, Attributes attributes) {
        this.root = root;
        this.parent = parent;
        this.service = new ServiceDescription();
        this.processAttributes(attributes);
    }

    protected void handleAttribute(String name, String value) {
        if (name.equals("servicefactory")) {
            this.service.setServicefactory(value.equalsIgnoreCase("true"));
            return;
        }
        this.root.logError("unrecognized service element attribute: " + name);
    }

    ServiceDescription getServiceDescription() {
        return this.service;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.isSCRNamespace(uri) && localName.equals("provide")) {
            this.root.setHandler(new ProvideElement(this.root, this, attributes));
            return;
        }
        super.startElement(uri, localName, qName, attributes);
    }

    public void endElement(String uri, String localName, String qName) {
        ComponentDescription component = this.parent.getComponentDescription();
        if (component.getService() != null) {
            this.root.logError("more than one service element");
        }
        if (this.service.getProvides().length == 0) {
            this.root.logError("no provide elements specified");
        }
        if (component.getFactory() != null && this.service.isServicefactory()) {
            this.root.logError("component factory is incompatible with Service factory ");
        }
        component.setService(this.service);
        this.root.setHandler(this.parent);
    }

    protected String getElementName() {
        return "service";
    }
}

