/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.item.selector.taglib.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.model.Group;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLUtil;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletException;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class ItemSelectorRepositoryEntryBrowserUtil {
    private static final Log _log = LogFactoryUtil.getLog(ItemSelectorRepositoryEntryBrowserUtil.class);

    public static void addPortletBreadcrumbEntries(long folderId, String displayStyle, HttpServletRequest request, LiferayPortletResponse liferayPortletResponse, PortletURL portletURL) throws Exception {
        ItemSelectorRepositoryEntryBrowserUtil.addGroupSelectorBreadcrumbEntry(request, liferayPortletResponse, portletURL);
        portletURL.setParameter("displayStyle", displayStyle);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Group scopeGroup = themeDisplay.getScopeGroup();
        ItemSelectorRepositoryEntryBrowserUtil.addPortletBreadcrumbEntry(0L, request, scopeGroup.getDescriptiveName(request.getLocale()), portletURL);
        if (folderId != 0L) {
            Folder folder = DLAppServiceUtil.getFolder((long)folderId);
            List ancestorFolders = folder.getAncestors();
            Collections.reverse(ancestorFolders);
            for (Folder ancestorFolder : ancestorFolders) {
                ItemSelectorRepositoryEntryBrowserUtil.addPortletBreadcrumbEntry(ancestorFolder.getFolderId(), request, ancestorFolder.getName(), portletURL);
            }
            ItemSelectorRepositoryEntryBrowserUtil.addPortletBreadcrumbEntry(folder.getFolderId(), request, folder.getName(), portletURL);
        }
    }

    public static JSONObject getItemMetadataJSONObject(FileEntry fileEntry, Locale locale) throws PortalException {
        JSONObject itemMetadataJSONObject = JSONFactoryUtil.createJSONObject();
        JSONArray groupsJSONArray = JSONFactoryUtil.createJSONArray();
        JSONObject firstTabJSONObject = JSONFactoryUtil.createJSONObject();
        JSONArray firstTabDataJSONArray = JSONFactoryUtil.createJSONArray();
        FileVersion latestFileVersion = fileEntry.getLatestFileVersion();
        firstTabDataJSONArray.put(ItemSelectorRepositoryEntryBrowserUtil._createJSONObject(LanguageUtil.get((Locale)locale, (String)"format"), HtmlUtil.escape((String)latestFileVersion.getExtension())));
        firstTabDataJSONArray.put(ItemSelectorRepositoryEntryBrowserUtil._createJSONObject(LanguageUtil.get((Locale)locale, (String)"size"), TextFormatter.formatStorageSize((double)fileEntry.getSize(), (Locale)locale)));
        firstTabDataJSONArray.put(ItemSelectorRepositoryEntryBrowserUtil._createJSONObject(LanguageUtil.get((Locale)locale, (String)"name"), HtmlUtil.escape((String)DLUtil.getTitleWithExtension((FileEntry)fileEntry))));
        firstTabDataJSONArray.put(ItemSelectorRepositoryEntryBrowserUtil._createJSONObject(LanguageUtil.get((Locale)locale, (String)"modified"), LanguageUtil.format((Locale)locale, (String)"x-ago-by-x", (Object[])new Object[]{LanguageUtil.getTimeDescription((Locale)locale, (long)(System.currentTimeMillis() - fileEntry.getModifiedDate().getTime()), (boolean)true), HtmlUtil.escape((String)fileEntry.getUserName())})));
        firstTabJSONObject.put("data", firstTabDataJSONArray);
        firstTabJSONObject.put("title", LanguageUtil.get((Locale)locale, (String)"file-info"));
        groupsJSONArray.put(firstTabJSONObject);
        JSONObject secondTabJSONObject = JSONFactoryUtil.createJSONObject();
        JSONArray secondTabDataJSONArray = JSONFactoryUtil.createJSONArray();
        secondTabDataJSONArray.put(ItemSelectorRepositoryEntryBrowserUtil._createJSONObject(LanguageUtil.get((Locale)locale, (String)"version"), HtmlUtil.escape((String)latestFileVersion.getVersion())));
        secondTabDataJSONArray.put(ItemSelectorRepositoryEntryBrowserUtil._createJSONObject(LanguageUtil.get((Locale)locale, (String)"status"), WorkflowConstants.getStatusLabel((int)latestFileVersion.getStatus())));
        secondTabJSONObject.put("data", secondTabDataJSONArray);
        secondTabJSONObject.put("title", LanguageUtil.get((Locale)locale, (String)"version"));
        groupsJSONArray.put(secondTabJSONObject);
        itemMetadataJSONObject.put("groups", groupsJSONArray);
        return itemMetadataJSONObject;
    }

    protected static void addGroupSelectorBreadcrumbEntry(HttpServletRequest request, LiferayPortletResponse liferayPortletResponse, PortletURL portletURL) throws PortalException, PortletException {
        PortletURL viewGroupSelectorURL = PortletURLUtil.clone((PortletURL)portletURL, (LiferayPortletResponse)liferayPortletResponse);
        viewGroupSelectorURL.setParameter("showGroupSelector", Boolean.TRUE.toString());
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)"sites", (String)viewGroupSelectorURL.toString());
    }

    protected static void addPortletBreadcrumbEntry(long folderId, HttpServletRequest request, String title, PortletURL portletURL) {
        portletURL.setParameter("folderId", String.valueOf(folderId));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)title, (String)portletURL.toString());
    }

    private static JSONObject _createJSONObject(String key, String value) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("key", key);
        jsonObject.put("value", value);
        return jsonObject;
    }
}

