/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obr.plugin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.felix.obr.plugin.PathFile;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ObrCleanRepo
extends AbstractMojo {
    private String obrRepository;
    private ArtifactRepository localRepository;

    public void execute() throws MojoExecutionException {
        if ("NONE".equalsIgnoreCase(this.obrRepository)) {
            return;
        }
        try {
            String localRepoPath = this.localRepository.getBasedir();
            PathFile repositoryXml = ObrCleanRepo.normalizeRepositoryPath(this.obrRepository, localRepoPath);
            if (!repositoryXml.isExists()) {
                this.getLog().error((CharSequence)("The repository file " + repositoryXml.getAbsoluteFilename() + " does not exist"));
                return;
            }
            Document doc = this.parseFile(repositoryXml.getFile(), this.initConstructor());
            Element finalDocument = this.cleanDocument(doc.getDocumentElement());
            if (finalDocument == null) {
                this.getLog().info((CharSequence)("Nothing to clean in " + repositoryXml.getAbsoluteFilename()));
            } else {
                this.getLog().info((CharSequence)"Cleaning...");
                this.writeToFile(repositoryXml.getUri(), finalDocument);
                this.getLog().info((CharSequence)("Repository " + repositoryXml.getAbsoluteFilename() + " updated"));
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Exception while cleaning the OBR repository file : " + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private Element cleanDocument(Element elem) {
        int i;
        NodeList nodes = elem.getElementsByTagName("resource");
        ArrayList<Element> toRemove = new ArrayList<Element>();
        for (i = 0; i < nodes.getLength(); ++i) {
            Element n = (Element)nodes.item(i);
            String value = n.getAttribute("uri");
            String localRepoPath = this.localRepository.getBasedir();
            File file = new File(localRepoPath, value);
            if (file.exists()) continue;
            this.getLog().info((CharSequence)("The bundle " + n.getAttribute("presentationname") + " - " + n.getAttribute("version") + " will be removed"));
            toRemove.add(n);
        }
        if (toRemove.size() > 0) {
            for (i = 0; i < toRemove.size(); ++i) {
                elem.removeChild((Node)toRemove.get(i));
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
            Date d = new Date();
            d.setTime(System.currentTimeMillis());
            elem.setAttribute("lastmodified", format.format(d));
            return elem;
        }
        return null;
    }

    private DocumentBuilder initConstructor() throws MojoExecutionException {
        DocumentBuilder constructor = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            constructor = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.getLog().error((CharSequence)"Unable to create a new xml document");
            throw new MojoExecutionException("Cannot create the Document Builder : " + e.getMessage());
        }
        return constructor;
    }

    private Document parseFile(File file, DocumentBuilder constructor) throws MojoExecutionException {
        if (constructor == null) {
            return null;
        }
        this.getLog().info((CharSequence)("Parsing " + file.getAbsolutePath()));
        Document doc = null;
        try {
            doc = constructor.parse(file);
        }
        catch (SAXException e) {
            this.getLog().error((CharSequence)("Cannot parse " + file.getAbsolutePath() + " : " + e.getMessage()));
            throw new MojoExecutionException("Cannot parse " + file.getAbsolutePath() + " : " + e.getMessage());
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Cannot open " + file.getAbsolutePath() + " : " + e.getMessage()));
            throw new MojoExecutionException("Cannot open " + file.getAbsolutePath() + " : " + e.getMessage());
        }
        return doc;
    }

    private void writeToFile(URI outputFilename, Node treeToBeWrite) throws MojoExecutionException {
        Transformer transformer = null;
        TransformerFactory tfabrique = TransformerFactory.newInstance();
        try {
            transformer = tfabrique.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            this.getLog().error((CharSequence)("Unable to write to file: " + outputFilename.toString()));
            throw new MojoExecutionException("Unable to write to file: " + outputFilename.toString() + " : " + e.getMessage());
        }
        Properties proprietes = new Properties();
        proprietes.put("method", "xml");
        proprietes.put("version", "1.0");
        proprietes.put("encoding", "ISO-8859-1");
        proprietes.put("standalone", "yes");
        proprietes.put("indent", "yes");
        proprietes.put("omit-xml-declaration", "no");
        transformer.setOutputProperties(proprietes);
        DOMSource input = new DOMSource(treeToBeWrite);
        File fichier = new File(outputFilename);
        FileOutputStream flux = null;
        try {
            flux = new FileOutputStream(fichier);
        }
        catch (FileNotFoundException e) {
            this.getLog().error((CharSequence)("Unable to write to file: " + fichier.getName()));
            throw new MojoExecutionException("Unable to write to file: " + fichier.getName() + " : " + e.getMessage());
        }
        StreamResult output = new StreamResult(flux);
        try {
            transformer.transform(input, output);
        }
        catch (TransformerException e) {
            throw new MojoExecutionException("Unable to write to file: " + outputFilename.toString() + " : " + e.getMessage());
        }
        try {
            flux.flush();
            flux.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException when closing file : " + e.getMessage());
        }
    }

    private static PathFile normalizeRepositoryPath(String obrPath, String mavenPath) {
        URI uri;
        if (null == obrPath || obrPath.length() == 0) {
            obrPath = mavenPath + File.separatorChar + "repository.xml";
        } else if (!obrPath.endsWith(".xml")) {
            obrPath = obrPath + File.separatorChar + "repository.xml";
        }
        try {
            uri = new URI(obrPath);
        }
        catch (URISyntaxException e) {
            uri = null;
        }
        if (null == uri || !uri.isAbsolute()) {
            File file = new File(obrPath);
            if (!file.isAbsolute()) {
                file = new File(mavenPath, obrPath);
            }
            uri = file.toURI();
        }
        return new PathFile(uri.toASCIIString());
    }
}

