/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obr.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class PathFile {
    private String m_fullFilename;
    private String m_fileName;
    private String m_pathFile;
    private String m_baseDir;
    private String m_protocol;
    private boolean m_relative;
    private boolean m_folder;
    private boolean m_exist;
    private boolean m_file;
    private boolean m_valid;
    private static final String REGEXP_BACKSLASH = "\\\\";

    public PathFile(String filename) {
        this.m_fullFilename = filename;
        if (filename == null) {
            this.m_valid = false;
            return;
        }
        this.m_valid = true;
        this.m_protocol = this.extractProtocol(filename);
        this.m_pathFile = this.extractPathFile(filename);
        if (this.m_pathFile.startsWith("//")) {
            this.m_pathFile = this.m_pathFile.substring(1);
        }
        this.m_fileName = this.extractFileName(filename);
        this.m_relative = this.extractRelative();
        if (!(this.m_relative || this.getProtocol().compareTo("file") != 0 && this.getProtocol().compareTo("") != 0)) {
            File f = new File(this.getOnlyAbsoluteFilename());
            this.m_file = f.isFile();
            this.m_folder = f.isDirectory();
            this.m_exist = f.exists();
            if (this.m_folder) {
                this.m_pathFile = this.m_pathFile + this.m_fileName + File.separator;
                this.m_fileName = "";
            }
        }
        if (this.m_exist) {
            this.m_protocol = "file";
        } else if (this.m_fileName.compareTo("") == 0) {
            this.m_folder = true;
            this.m_file = false;
        } else {
            this.m_folder = false;
            this.m_file = true;
        }
        if (!this.isRelative() && !this.m_pathFile.startsWith("/")) {
            this.m_pathFile = "/".concat(this.m_pathFile);
        }
    }

    private boolean extractRelative() {
        if (this.m_pathFile.startsWith("." + File.separator, 1) || this.m_pathFile.startsWith(".." + File.separator, 1)) {
            this.m_pathFile = this.m_pathFile.substring(1);
            this.m_valid = false;
            return true;
        }
        return false;
    }

    private String extractFileName(String fullFilename) {
        int index = fullFilename.lastIndexOf(47);
        return fullFilename.substring(index + 1, fullFilename.length());
    }

    private String extractPathFile(String fullFilename) {
        String substring = this.extractFileName(fullFilename).compareTo("") == 0 ? fullFilename : fullFilename.substring(0, fullFilename.indexOf(this.extractFileName(fullFilename)));
        if (this.getProtocol().compareTo("") != 0) {
            substring = substring.substring(5);
        }
        return substring;
    }

    private String extractProtocol(String filename) {
        if (filename.startsWith("file:")) {
            return "file";
        }
        if (filename.startsWith("http:")) {
            return "http";
        }
        return "";
    }

    public void setBaseDir(String baseDir) {
        this.m_baseDir = baseDir;
        if (this.isRelative() && this.m_fullFilename != null) {
            this.m_valid = true;
            if (this.getProtocol().compareTo("file") == 0 || this.getProtocol().compareTo("") == 0) {
                File f = new File(this.getOnlyAbsoluteFilename());
                this.m_file = f.isFile();
                this.m_folder = f.isDirectory();
                this.m_exist = f.exists();
            }
            if (this.m_exist) {
                this.m_protocol = "file";
            }
        }
    }

    public String getBaseDir() {
        return this.m_baseDir;
    }

    public boolean isValid() {
        return this.m_valid;
    }

    public boolean isRelative() {
        return this.m_relative;
    }

    public boolean isExists() {
        return this.m_exist;
    }

    public boolean isFile() {
        return this.m_file;
    }

    public boolean isFolder() {
        return this.m_folder;
    }

    public File getFile() {
        if (!this.isValid()) {
            return null;
        }
        String path = PathFile.uniformSeparator(this.getOnlyAbsoluteFilename());
        if (File.separatorChar == '\\') {
            path = path.replace('\\', '/');
        }
        File f = new File(path);
        return f;
    }

    public URI getUri() {
        if (!this.isValid()) {
            return null;
        }
        String path = PathFile.uniformSeparator(this.getAbsoluteFilename());
        if (File.separatorChar == '\\') {
            path = path.replace('\\', '/');
        }
        path = path.replaceAll(" ", "%20");
        URI uri = null;
        try {
            uri = new URI(path);
        }
        catch (URISyntaxException e) {
            System.err.println("Malformed URI: " + path);
            System.err.println(e.getMessage());
            return null;
        }
        return uri;
    }

    public String getRelativePath() {
        if (!this.isValid()) {
            return null;
        }
        return this.getProtocol() + ":/" + this.getOnlyRelativePath();
    }

    public String getOnlyRelativePath() {
        if (!this.isValid()) {
            return null;
        }
        if (this.isRelative()) {
            return this.m_pathFile;
        }
        if (this.m_baseDir != null && this.m_pathFile.startsWith(this.m_baseDir)) {
            return "." + File.separator + this.m_pathFile.substring(this.m_baseDir.length());
        }
        return this.m_pathFile;
    }

    private String calculAbsolutePath(String baseDir, String path) {
        if (path.startsWith(".." + File.separatorChar)) {
            String base = baseDir;
            int lastIndex = base.lastIndexOf(File.separator);
            if (lastIndex == base.length()) {
                base = base.substring(0, base.length() - 1);
                lastIndex = base.lastIndexOf(File.separator);
            }
            if (lastIndex < base.length()) {
                return this.calculAbsolutePath(base.substring(0, lastIndex + 1), path.substring(3));
            }
            return null;
        }
        if (path.startsWith("." + File.separatorChar)) {
            String res = File.separatorChar == '\\' ? path.replaceFirst(".", baseDir.replace('\\', '/')) : path.replaceFirst(".", baseDir);
            return PathFile.uniformSeparator(res);
        }
        return PathFile.uniformSeparator(baseDir + path);
    }

    public String getOnlyAbsolutePath() {
        if (!this.isValid()) {
            return null;
        }
        if (this.isRelative()) {
            return this.calculAbsolutePath(this.m_baseDir, this.m_pathFile);
        }
        return this.m_pathFile;
    }

    public String getAbsolutePath() {
        if (this.isRelative()) {
            return this.getProtocol() + ":/" + this.calculAbsolutePath(this.m_baseDir, this.m_pathFile);
        }
        if (this.getProtocol().compareTo("") == 0 || this.m_pathFile == null) {
            return this.m_pathFile;
        }
        return this.getProtocol() + ":" + this.m_pathFile;
    }

    public String getOnlyAbsoluteFilename() {
        if (this.getOnlyAbsolutePath() != null && this.getFilename() != null) {
            return this.getOnlyAbsolutePath() + this.getFilename();
        }
        return null;
    }

    public String getAbsoluteFilename() {
        if (this.getAbsolutePath() != null && this.getFilename() != null) {
            return this.getAbsolutePath() + this.getFilename();
        }
        return null;
    }

    public String getOnlyRelativeFilename() {
        if (!this.isValid()) {
            return "";
        }
        return this.getOnlyRelativePath() + this.getFilename();
    }

    public String getRelativeFilename() {
        if (!this.isValid()) {
            return "";
        }
        if (this.isRelative()) {
            return this.getRelativePath() + this.getFilename();
        }
        return this.getAbsoluteFilename();
    }

    public String getFilename() {
        return this.m_fileName;
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    public boolean createPath() {
        File path = new File(this.getOnlyAbsolutePath());
        if (path.exists()) {
            return true;
        }
        return path.mkdirs();
    }

    public boolean createFile() {
        File path = new File(this.getOnlyAbsolutePath());
        if (!path.exists() && !this.createPath()) {
            return false;
        }
        path = new File(this.getOnlyAbsoluteFilename());
        try {
            return path.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean delete() {
        File path = new File(this.getAbsoluteFilename());
        if (path.exists()) {
            return path.delete();
        }
        return true;
    }

    public static String doubleSeparator(String path) {
        if (path != null && File.separatorChar == '\\') {
            return path.replaceAll(REGEXP_BACKSLASH, "\\\\\\\\");
        }
        return null;
    }

    public static String uniformSeparator(String path) {
        if (File.separatorChar == '\\') {
            if (path.startsWith("/")) {
                return path.substring(1).replace('/', File.separatorChar);
            }
            return path.replace('/', File.separatorChar);
        }
        return path.replace('\\', File.separatorChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFile(PathFile src, PathFile dest) {
        AbstractInterruptibleChannel out;
        block17: {
            FileChannel in = null;
            out = null;
            if (!src.isExists()) {
                System.err.println("src file must exist: " + src.getAbsoluteFilename());
                return false;
            }
            if (!dest.isExists()) {
                dest.createFile();
            }
            try {
                try {
                    in = new FileInputStream(src.getOnlyAbsoluteFilename()).getChannel();
                    out = new FileOutputStream(dest.getOnlyAbsoluteFilename()).getChannel();
                    in.transferTo(0L, in.size(), (WritableByteChannel)((Object)out));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Object var6_5 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            return false;
                        }
                    }
                    if (out == null) return true;
                    try {
                        out.close();
                        return true;
                    }
                    catch (IOException e3) {
                        return false;
                    }
                }
                Object var6_4 = null;
                if (in == null) break block17;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (in != null) {
                    try {}
                    catch (IOException e2) {
                        return false;
                    }
                    in.close();
                }
                if (out == null) throw throwable;
                try {}
                catch (IOException e3) {
                    return false;
                }
                out.close();
                throw throwable;
            }
            try {}
            catch (IOException e2) {
                return false;
            }
            in.close();
        }
        if (out == null) return true;
        try {}
        catch (IOException e3) {
            return false;
        }
        out.close();
        return true;
    }
}

