/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.indexes;

import java.util.Currency;
import org.jquantlib.Configuration;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.Index;
import org.jquantlib.indexes.IndexManager;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.util.Date;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Observer;
import org.jquantlib.util.TimeSeriesDouble;

public abstract class InterestRateIndex
extends Index
implements Observer {
    private String familyName;
    private Period tenor;
    private int fixingDays;
    private Calendar fixingCalendar;
    private Currency currency;
    private DayCounter dayCounter;

    public InterestRateIndex(String familyName, Period tenor, int fixingDays, Calendar fixingCalendar, Currency currency, DayCounter dayCounter) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("not implemented yet");
        }
        this.familyName = familyName;
        this.tenor = tenor;
        this.fixingDays = fixingDays;
        this.fixingCalendar = fixingCalendar;
        this.currency = currency;
        this.dayCounter = dayCounter;
        if (fixingDays > 2) {
            throw new IllegalArgumentException("wrong number (" + fixingDays + ") of fixing days");
        }
        Configuration.getSystemConfiguration(null).getGlobalSettings().getEvaluationDate().addObserver(this);
        IndexManager.getInstance().notifier(this.getName()).addObserver(this);
    }

    @Override
    public double fixing(Date fixingDate, boolean forecastTodaysFixing) {
        if (this.isValidFixingDate(fixingDate)) {
            throw new IllegalStateException("Fixing date " + fixingDate + " is not valid");
        }
        Date today = Configuration.getSystemConfiguration(null).getGlobalSettings().getEvaluationDate();
        boolean enforceTodaysHistoricFixings = Configuration.getSystemConfiguration(null).isEnforcesTodaysHistoricFixings();
        if (fixingDate.le(today) || fixingDate.equals(today) && enforceTodaysHistoricFixings && !forecastTodaysFixing) {
            Double pastFixing = ((TimeSeriesDouble)IndexManager.getInstance().get(this.getName())).find(fixingDate);
            if (pastFixing == null) {
                throw new IllegalArgumentException("Missing " + this.getName() + " fixing for " + fixingDate);
            }
            return pastFixing;
        }
        if (fixingDate.equals(today) && !forecastTodaysFixing) {
            try {
                Double pastFixing = ((TimeSeriesDouble)IndexManager.getInstance().get(this.getName())).find(fixingDate);
                if (pastFixing != null) {
                    return pastFixing;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return this.forecastFixing(fixingDate);
    }

    @Override
    public String getName() {
        StringBuilder builder = new StringBuilder(this.familyName);
        if (this.tenor.units() == TimeUnit.DAYS) {
            if (this.fixingDays == 0) {
                builder.append("ON");
            } else if (this.fixingDays == 2) {
                builder.append("SN");
            } else {
                builder.append("TN");
            }
        } else {
            builder.append(this.tenor.getShortFormat());
        }
        builder.append(this.dayCounter.name());
        return builder.toString();
    }

    public Date fixingDate(Date valueDate) {
        Date fixingDate = this.getFixingCalendar().advance(valueDate, this.fixingDays, TimeUnit.DAYS);
        if (!this.isValidFixingDate(fixingDate)) {
            throw new IllegalArgumentException("fixing date " + fixingDate + " is not valid");
        }
        return fixingDate;
    }

    @Override
    public boolean isValidFixingDate(Date fixingDate) {
        return this.fixingCalendar.isBusinessDay(fixingDate);
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public Period getTenor() {
        return this.tenor;
    }

    public int getFixingDays() {
        return this.fixingDays;
    }

    @Override
    public Calendar getFixingCalendar() {
        return this.fixingCalendar;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public DayCounter getDayCounter() {
        return this.dayCounter;
    }

    public abstract Handle<YieldTermStructure> getTermStructure();

    public Date valueDate(Date fixingDate) {
        if (!this.isValidFixingDate(fixingDate)) {
            throw new IllegalArgumentException("Fixing date " + fixingDate + " is not valid");
        }
        return this.getFixingCalendar().advance(fixingDate, this.fixingDays, TimeUnit.DAYS);
    }

    public abstract Date maturityDate(Date var1);

    protected abstract double forecastFixing(Date var1);

    @Override
    public void update(Observable o, Object arg) {
        this.notifyObservers(arg);
    }
}

