/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math;

import org.jquantlib.lang.annotation.NonNegative;
import org.jquantlib.math.Constants;

public final class Closeness {
    public static final boolean isClose(double x, double y) {
        return Closeness.isClose(x, y, 42);
    }

    public static final boolean isClose(double x, double y, @NonNegative int n) {
        double tolerance;
        double diff = Math.abs(x - y);
        return diff <= (tolerance = (double)n * Constants.QL_EPSILON) * Math.abs(x) && diff <= tolerance * Math.abs(y);
    }

    public static final boolean isCloseEnough(double x, double y) {
        return Closeness.isCloseEnough(x, y, 42);
    }

    public static final boolean isCloseEnough(double x, double y, @NonNegative int n) {
        double tolerance;
        double diff = Math.abs(x - y);
        return diff <= (tolerance = (double)n * Constants.QL_EPSILON) * Math.abs(x) || diff <= tolerance * Math.abs(y);
    }
}

