/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.barrier;

import org.jquantlib.instruments.BarrierType;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;
import org.jquantlib.pricingengines.arguments.BarrierOptionArguments;
import org.jquantlib.pricingengines.barrier.BarrierOptionEngine;
import org.jquantlib.pricingengines.results.OneAssetOptionResults;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.InterestRate;
import org.jquantlib.time.Frequency;

public class AnalyticBarrierOptionEngine
extends BarrierOptionEngine {
    private static final String BS_PROCESS_REQUIRED = "Black-Scholes process required";
    private static final String NON_PLAIN_PAYOFF_GIVEN = "non-plain payoff given";
    private static final String STRIKE_MUST_BE_POSITIVE = "strike must be positive";
    private static final String UNKNOWN_TYPE = "unknown type";
    private final CumulativeNormalDistribution f_ = new CumulativeNormalDistribution();

    @Override
    public void calculate() {
        if (!(((BarrierOptionArguments)this.getArguments()).payoff instanceof PlainVanillaPayoff)) {
            throw new ArithmeticException(NON_PLAIN_PAYOFF_GIVEN);
        }
        PlainVanillaPayoff payoff = (PlainVanillaPayoff)((BarrierOptionArguments)this.getArguments()).payoff;
        if (!(payoff.strike() > 0.0)) {
            throw new ArithmeticException(STRIKE_MUST_BE_POSITIVE);
        }
        if (!(((BarrierOptionArguments)this.arguments).stochasticProcess instanceof GeneralizedBlackScholesProcess)) {
            throw new ArithmeticException(BS_PROCESS_REQUIRED);
        }
        double strike = payoff.strike();
        BarrierType barrierType = ((BarrierOptionArguments)this.arguments).barrierType;
        switch (payoff.optionType()) {
            case CALL: {
                switch (barrierType) {
                    case DownIn: {
                        if (strike >= this.barrier()) {
                            ((OneAssetOptionResults)this.results).value = this.C(1.0, 1.0) + this.E(1.0);
                            break;
                        }
                        ((OneAssetOptionResults)this.results).value = this.A(1.0) - this.B(1.0) + this.D(1.0, 1.0) + this.E(1.0);
                        break;
                    }
                    case UpIn: {
                        if (strike >= this.barrier()) {
                            ((OneAssetOptionResults)this.results).value = this.A(1.0) + this.E(-1.0);
                            break;
                        }
                        ((OneAssetOptionResults)this.results).value = this.B(1.0) - this.C(-1.0, 1.0) + this.D(-1.0, 1.0) + this.E(-1.0);
                        break;
                    }
                    case DownOut: {
                        if (strike >= this.barrier()) {
                            ((OneAssetOptionResults)this.results).value = this.A(1.0) - this.C(1.0, 1.0) + this.F(1.0);
                            break;
                        }
                        ((OneAssetOptionResults)this.results).value = this.B(1.0) - this.D(1.0, 1.0) + this.F(1.0);
                        break;
                    }
                    case UpOut: {
                        ((OneAssetOptionResults)this.results).value = strike >= this.barrier() ? this.F(-1.0) : this.A(1.0) - this.B(1.0) + this.C(-1.0, 1.0) - this.D(-1.0, 1.0) + this.F(-1.0);
                    }
                }
                break;
            }
            case PUT: {
                switch (barrierType) {
                    case DownIn: {
                        if (strike >= this.barrier()) {
                            ((OneAssetOptionResults)this.results).value = this.B(-1.0) - this.C(1.0, -1.0) + this.D(1.0, -1.0) + this.E(1.0);
                            break;
                        }
                        ((OneAssetOptionResults)this.results).value = this.A(-1.0) + this.E(1.0);
                        break;
                    }
                    case UpIn: {
                        if (strike >= this.barrier()) {
                            ((OneAssetOptionResults)this.results).value = this.A(-1.0) - this.B(-1.0) + this.D(-1.0, -1.0) + this.E(-1.0);
                            break;
                        }
                        ((OneAssetOptionResults)this.results).value = this.C(-1.0, -1.0) + this.E(-1.0);
                        break;
                    }
                    case DownOut: {
                        if (strike >= this.barrier()) {
                            ((OneAssetOptionResults)this.results).value = this.A(-1.0) - this.B(-1.0) + this.C(1.0, -1.0) - this.D(1.0, -1.0) + this.F(1.0);
                            break;
                        }
                        ((OneAssetOptionResults)this.results).value = this.F(1.0);
                        break;
                    }
                    case UpOut: {
                        ((OneAssetOptionResults)this.results).value = strike >= this.barrier() ? this.B(-1.0) - this.D(-1.0, -1.0) + this.F(-1.0) : this.A(-1.0) - this.C(-1.0, -1.0) + this.F(-1.0);
                    }
                }
                break;
            }
            default: {
                throw new ArithmeticException(UNKNOWN_TYPE);
            }
        }
    }

    private double underlying() {
        return ((BarrierOptionArguments)this.arguments).stochasticProcess.initialValues()[0];
    }

    private double strike() {
        if (!(((BarrierOptionArguments)this.getArguments()).payoff instanceof PlainVanillaPayoff)) {
            throw new ArithmeticException(NON_PLAIN_PAYOFF_GIVEN);
        }
        PlainVanillaPayoff payoff = (PlainVanillaPayoff)((BarrierOptionArguments)this.getArguments()).payoff;
        return payoff.strike();
    }

    private double residualTime() {
        return ((BarrierOptionArguments)this.arguments).stochasticProcess.getTime(((BarrierOptionArguments)this.arguments).exercise.lastDate());
    }

    private double volatility() {
        if (!(((BarrierOptionArguments)this.arguments).stochasticProcess instanceof GeneralizedBlackScholesProcess)) {
            throw new ArithmeticException(BS_PROCESS_REQUIRED);
        }
        GeneralizedBlackScholesProcess process = (GeneralizedBlackScholesProcess)((BarrierOptionArguments)this.arguments).stochasticProcess;
        return process.blackVolatility().getLink().blackVol(this.residualTime(), this.strike());
    }

    private double stdDeviation() {
        return this.volatility() * Math.sqrt(this.residualTime());
    }

    private double barrier() {
        return ((BarrierOptionArguments)this.arguments).barrier;
    }

    private double rebate() {
        return ((BarrierOptionArguments)this.arguments).rebate;
    }

    private double riskFreeRate() {
        if (!(((BarrierOptionArguments)this.arguments).stochasticProcess instanceof GeneralizedBlackScholesProcess)) {
            throw new ArithmeticException(BS_PROCESS_REQUIRED);
        }
        GeneralizedBlackScholesProcess process = (GeneralizedBlackScholesProcess)((BarrierOptionArguments)this.arguments).stochasticProcess;
        InterestRate rate = process.riskFreeRate().getLink().zeroRate(this.residualTime(), Compounding.CONTINUOUS, Frequency.NO_FREQUENCY, false);
        return rate.rate();
    }

    private double riskFreeDiscount() {
        if (!(((BarrierOptionArguments)this.arguments).stochasticProcess instanceof GeneralizedBlackScholesProcess)) {
            throw new ArithmeticException(BS_PROCESS_REQUIRED);
        }
        GeneralizedBlackScholesProcess process = (GeneralizedBlackScholesProcess)((BarrierOptionArguments)this.arguments).stochasticProcess;
        return process.riskFreeRate().getLink().discount(this.residualTime());
    }

    private double dividendYield() {
        if (!(((BarrierOptionArguments)this.arguments).stochasticProcess instanceof GeneralizedBlackScholesProcess)) {
            throw new ArithmeticException(BS_PROCESS_REQUIRED);
        }
        GeneralizedBlackScholesProcess process = (GeneralizedBlackScholesProcess)((BarrierOptionArguments)this.arguments).stochasticProcess;
        InterestRate yield = process.dividendYield().getLink().zeroRate(this.residualTime(), Compounding.CONTINUOUS, Frequency.NO_FREQUENCY, false);
        return yield.rate();
    }

    private double dividendDiscount() {
        if (!(((BarrierOptionArguments)this.arguments).stochasticProcess instanceof GeneralizedBlackScholesProcess)) {
            throw new ArithmeticException(BS_PROCESS_REQUIRED);
        }
        GeneralizedBlackScholesProcess process = (GeneralizedBlackScholesProcess)((BarrierOptionArguments)this.arguments).stochasticProcess;
        return process.dividendYield().getLink().discount(this.residualTime());
    }

    private double mu() {
        double vol = this.volatility();
        return (this.riskFreeRate() - this.dividendYield()) / (vol * vol) - 0.5;
    }

    private double muSigma() {
        return (1.0 + this.mu()) * this.stdDeviation();
    }

    private double A(double phi) {
        double x1 = Math.log(this.underlying() / this.strike()) / this.stdDeviation() + this.muSigma();
        double N1 = this.f_.evaluate(phi * x1);
        double N2 = this.f_.evaluate(phi * (x1 - this.stdDeviation()));
        return phi * (this.underlying() * this.dividendDiscount() * N1 - this.strike() * this.riskFreeDiscount() * N2);
    }

    private double B(double phi) {
        double x2 = Math.log(this.underlying() / this.barrier()) / this.stdDeviation() + this.muSigma();
        double N1 = this.f_.evaluate(phi * x2);
        double N2 = this.f_.evaluate(phi * (x2 - this.stdDeviation()));
        return phi * (this.underlying() * this.dividendDiscount() * N1 - this.strike() * this.riskFreeDiscount() * N2);
    }

    private double C(double eta, double phi) {
        double HS = this.barrier() / this.underlying();
        double powHS0 = Math.pow(HS, 2.0 * this.mu());
        double powHS1 = powHS0 * HS * HS;
        double y1 = Math.log(this.barrier() * HS / this.strike()) / this.stdDeviation() + this.muSigma();
        double N1 = this.f_.evaluate(eta * y1);
        double N2 = this.f_.evaluate(eta * (y1 - this.stdDeviation()));
        return phi * (this.underlying() * this.dividendDiscount() * powHS1 * N1 - this.strike() * this.riskFreeDiscount() * powHS0 * N2);
    }

    private double D(double eta, double phi) {
        double HS = this.barrier() / this.underlying();
        double powHS0 = Math.pow(HS, 2.0 * this.mu());
        double powHS1 = powHS0 * HS * HS;
        double y2 = Math.log(this.barrier() / this.underlying()) / this.stdDeviation() + this.muSigma();
        double N1 = this.f_.evaluate(eta * y2);
        double N2 = this.f_.evaluate(eta * (y2 - this.stdDeviation()));
        return phi * (this.underlying() * this.dividendDiscount() * powHS1 * N1 - this.strike() * this.riskFreeDiscount() * powHS0 * N2);
    }

    private double E(double eta) {
        if (this.rebate() > 0.0) {
            double powHS0 = Math.pow(this.barrier() / this.underlying(), 2.0 * this.mu());
            double x2 = Math.log(this.underlying() / this.barrier()) / this.stdDeviation() + this.muSigma();
            double y2 = Math.log(this.barrier() / this.underlying()) / this.stdDeviation() + this.muSigma();
            double N1 = this.f_.evaluate(eta * (x2 - this.stdDeviation()));
            double N2 = this.f_.evaluate(eta * (y2 - this.stdDeviation()));
            return this.rebate() * this.riskFreeDiscount() * (N1 - powHS0 * N2);
        }
        return 0.0;
    }

    private double F(double eta) {
        if (this.rebate() > 0.0) {
            double m = this.mu();
            double vol = this.volatility();
            double lambda = Math.sqrt(m * m + 2.0 * this.riskFreeRate() / (vol * vol));
            double HS = this.barrier() / this.underlying();
            double powHSplus = Math.pow(HS, m + lambda);
            double powHSminus = Math.pow(HS, m - lambda);
            double sigmaSqrtT = this.stdDeviation();
            double z = Math.log(this.barrier() / this.underlying()) / sigmaSqrtT + lambda * sigmaSqrtT;
            double N1 = this.f_.evaluate(eta * z);
            double N2 = this.f_.evaluate(eta * (z - 2.0 * lambda * sigmaSqrtT));
            return this.rebate() * (powHSplus * N1 + powHSminus * N2);
        }
        return 0.0;
    }
}

