/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class UnitedStates
extends DelegateCalendar {
    private static final UnitedStates SETTLEMENT_CALENDAR = new UnitedStates(Market.SETTLEMENT);
    private static final UnitedStates NYSE_CALENDAR = new UnitedStates(Market.NYSE);
    private static final UnitedStates GOVBOND_CALENDAR = new UnitedStates(Market.GOVERNMENTBOND);
    private static final UnitedStates NERC_CALENDAR = new UnitedStates(Market.NERC);

    private UnitedStates(Market market) {
        WesternCalendar delegate;
        switch (market) {
            case SETTLEMENT: {
                delegate = new USSettlementCalendar();
                break;
            }
            case NYSE: {
                delegate = new NyseCalendar();
                break;
            }
            case GOVERNMENTBOND: {
                delegate = new USGovernmentBondCalendar();
                break;
            }
            case NERC: {
                delegate = new USNercCalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static UnitedStates getCalendar(Market market) {
        switch (market) {
            case SETTLEMENT: {
                return SETTLEMENT_CALENDAR;
            }
            case NYSE: {
                return NYSE_CALENDAR;
            }
            case GOVERNMENTBOND: {
                return GOVBOND_CALENDAR;
            }
            case NERC: {
                return NERC_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class USNercCalendar
    extends WesternCalendar {
        private USNercCalendar() {
        }

        @Override
        public String getName() {
            return "North American Energy Reliability Council";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int m = date.getMonth();
            return !(this.isWeekend(w) || (d == 1 || d == 2 && w == Weekday.MONDAY) && m == Month.JANUARY.toInteger() || d >= 25 && w == Weekday.MONDAY && m == Month.MAY.toInteger() || (d == 4 || d == 5 && w == Weekday.MONDAY) && m == Month.JULY.toInteger() || d <= 7 && w == Weekday.MONDAY && m == Month.SEPTEMBER.toInteger() || d >= 22 && d <= 28 && w == Weekday.THURSDAY && m == Month.NOVEMBER.toInteger()) && (d != 25 && (d != 26 || w != Weekday.MONDAY) || m != Month.DECEMBER.toInteger());
        }
    }

    private static final class USGovernmentBondCalendar
    extends WesternCalendar {
        private USGovernmentBondCalendar() {
        }

        @Override
        public String getName() {
            return "US government bond market";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            int m = date.getMonth();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || (d == 1 || d == 2 && w == Weekday.MONDAY) && m == Month.JANUARY.toInteger() || d >= 15 && d <= 21 && w == Weekday.MONDAY && m == Month.JANUARY.toInteger() || d >= 15 && d <= 21 && w == Weekday.MONDAY && m == Month.FEBRUARY.toInteger() || dd == em - 3 || d >= 25 && w == Weekday.MONDAY && m == Month.MAY.toInteger() || (d == 4 || d == 5 && w == Weekday.MONDAY || d == 3 && w == Weekday.FRIDAY) && m == Month.JULY.toInteger() || d <= 7 && w == Weekday.MONDAY && m == Month.SEPTEMBER.toInteger() || d >= 8 && d <= 14 && w == Weekday.MONDAY && m == Month.OCTOBER.toInteger() || (d == 11 || d == 12 && w == Weekday.MONDAY || d == 10 && w == Weekday.FRIDAY) && m == Month.NOVEMBER.toInteger() || d >= 22 && d <= 28 && w == Weekday.THURSDAY && m == Month.NOVEMBER.toInteger()) && (d != 25 && (d != 26 || w != Weekday.MONDAY) && (d != 24 || w != Weekday.FRIDAY) || m != Month.DECEMBER.toInteger());
        }
    }

    private static final class NyseCalendar
    extends WesternCalendar {
        private NyseCalendar() {
        }

        @Override
        public String getName() {
            return "New York stock exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            int m = date.getMonth();
            int y = date.getYear();
            int em = this.easterMonday(y);
            if (this.isWeekend(w) || (d == 1 || d == 2 && w == Weekday.MONDAY) && m == Month.JANUARY.toInteger() || d >= 15 && d <= 21 && w == Weekday.MONDAY && m == Month.FEBRUARY.toInteger() || dd == em - 3 || d >= 25 && w == Weekday.MONDAY && m == Month.MAY.toInteger() || (d == 4 || d == 5 && w == Weekday.MONDAY || d == 3 && w == Weekday.FRIDAY) && m == Month.JULY.toInteger() || d <= 7 && w == Weekday.MONDAY && m == Month.SEPTEMBER.toInteger() || d >= 22 && d <= 28 && w == Weekday.THURSDAY && m == Month.NOVEMBER.toInteger() || (d == 25 || d == 26 && w == Weekday.MONDAY || d == 24 && w == Weekday.FRIDAY) && m == Month.DECEMBER.toInteger()) {
                return false;
            }
            return !(y >= 1998 ? d >= 15 && d <= 21 && w == Weekday.MONDAY && m == Month.JANUARY.toInteger() || y == 2004 && m == Month.JUNE.toInteger() && d == 11 || y == 2001 && m == Month.SEPTEMBER.toInteger() && 11 <= d && d <= 14 || y == 2007 && m == Month.JANUARY.toInteger() && d == 2 : (y <= 1980 ? y % 4 == 0 && m == Month.NOVEMBER.toInteger() && d <= 7 && w == Weekday.TUESDAY || y == 1977 && m == Month.JULY.toInteger() && d == 14 || y == 1973 && m == Month.JANUARY.toInteger() && d == 25 || y == 1972 && m == Month.DECEMBER.toInteger() && d == 28 || y == 1969 && m == Month.JULY.toInteger() && d == 21 || y == 1969 && m == Month.MARCH.toInteger() && d == 31 || y == 1969 && m == Month.FEBRUARY.toInteger() && d == 10 || y == 1968 && m == Month.JULY.toInteger() && d == 5 || y == 1968 && dd >= 163 && w == Weekday.WEDNESDAY : y == 1994 && m == Month.APRIL.toInteger() && d == 27));
        }
    }

    private static final class USSettlementCalendar
    extends WesternCalendar {
        private USSettlementCalendar() {
        }

        @Override
        public String getName() {
            return "US settlement";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            int m = date.getMonth();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || (d == 1 || d == 2 && w == Weekday.MONDAY) && m == Month.JANUARY.toInteger() || d == 31 && w == Weekday.FRIDAY && m == Month.DECEMBER.toInteger() || d >= 15 && d <= 21 && w == Weekday.MONDAY && m == Month.JANUARY.toInteger() || d >= 15 && d <= 21 && w == Weekday.MONDAY && m == Month.FEBRUARY.toInteger() || dd == em - 3 && y >= 2008 || d >= 25 && w == Weekday.MONDAY && m == Month.MAY.toInteger() || (d == 4 || d == 5 && w == Weekday.MONDAY || d == 3 && w == Weekday.FRIDAY) && m == Month.JULY.toInteger() || d <= 7 && w == Weekday.MONDAY && m == Month.SEPTEMBER.toInteger() || d >= 8 && d <= 14 && w == Weekday.MONDAY && m == Month.OCTOBER.toInteger() || (d == 11 || d == 12 && w == Weekday.MONDAY || d == 10 && w == Weekday.FRIDAY) && m == Month.NOVEMBER.toInteger() || d >= 22 && d <= 28 && w == Weekday.THURSDAY && m == Month.NOVEMBER.toInteger()) && (d != 25 && (d != 26 || w != Weekday.MONDAY) && (d != 24 || w != Weekday.FRIDAY) || m != Month.DECEMBER.toInteger());
        }
    }

    public static enum Market {
        SETTLEMENT,
        NYSE,
        GOVERNMENTBOND,
        NERC;

    }
}

