/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.math.Constants;
import org.jquantlib.math.distributions.GammaFunction;

public class IncompleteGamma {
    public double incompleteGammaFunction(double a, double x, double accuracy, int maxIteration) {
        if (!(a > 0.0)) {
            throw new ArithmeticException("non-positive a is not allowed");
        }
        if (!(x >= 0.0)) {
            throw new ArithmeticException("negative x is not allowed");
        }
        if (x < 2.0) {
            return this.incompleteGammaFunctionSeriesRepr(a, x, accuracy, maxIteration);
        }
        return 1.0 - this.incompleteGammaFunctionContinuedFractionRepr(a, x, accuracy, maxIteration);
    }

    double incompleteGammaFunctionSeriesRepr(double a, double x, double accuracy, int maxIteration) {
        double del;
        if (x == 0.0) {
            return 0.0;
        }
        GammaFunction gf = new GammaFunction();
        double gln = gf.logValue(a);
        double ap = a;
        double sum = del = 1.0 / a;
        Integer n = 1;
        while (n <= maxIteration) {
            sum += (del *= x / (ap += 1.0));
            if (Math.abs(del) < Math.abs(sum) * accuracy) {
                return sum * Math.abs(-x + a * Math.log(x) - gln);
            }
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n + 1);
        }
        throw new ArithmeticException("accuracy not reached");
    }

    public double incompleteGammaFunctionContinuedFractionRepr(double a, double x, double accuracy, int maxIteration) {
        double d;
        GammaFunction gf = new GammaFunction();
        double gln = gf.logValue(a);
        double b = x + 1.0 - a;
        double c = 1.0 / Constants.QL_EPSILON;
        double h = d = 1.0 / b;
        for (int i = 1; i <= maxIteration; ++i) {
            double an = (double)(-i) * ((double)i - a);
            if (Math.abs(d = an * d + (b += 2.0)) < Constants.QL_EPSILON) {
                d = Constants.QL_EPSILON;
            }
            if (Math.abs(c = b + an / c) < Constants.QL_EPSILON) {
                c = Constants.QL_EPSILON;
            }
            d = 1.0 / d;
            double del = d * c;
            h *= del;
            if (!(Math.abs(del - 1.0) < accuracy)) continue;
            return Math.exp(-x + a * Math.log(x) - gln) * h;
        }
        throw new ArithmeticException("accuracy not reached");
    }
}

