/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.interpolations;

import java.util.Arrays;
import org.jquantlib.math.interpolations.AbstractInterpolation;
import org.jquantlib.math.interpolations.Interpolation;
import org.jquantlib.math.interpolations.Interpolator;
import org.jquantlib.math.interpolations.LinearInterpolation;

public class LogLinearInterpolation
extends AbstractInterpolation {
    private double[] logY;
    private Interpolation linearInterpolation;

    private LogLinearInterpolation() {
    }

    public static Interpolator getInterpolator() {
        LogLinearInterpolation logLinearInterpolation = new LogLinearInterpolation();
        return new LogLinearInterpolationImpl(logLinearInterpolation);
    }

    @Override
    protected double primitiveImpl(double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected double derivativeImpl(double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected double secondDerivativeImpl(double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void update() {
        this.reload();
    }

    @Override
    public void reload() {
        super.reload();
        this.logY = new double[this.vx.length];
        for (int i = 0; i < this.vx.length; ++i) {
            if (this.vx[i] <= 0.0) {
                throw new ArithmeticException("negative or null value " + this.vx[i] + " at " + i + " position.");
            }
            this.logY[i] = Math.log(this.vy[i]);
        }
        this.linearInterpolation = LinearInterpolation.getInterpolator().interpolate(this.vx, this.logY);
    }

    @Override
    protected double evaluateImpl(double x) {
        return Math.exp(this.linearInterpolation.evaluate(x));
    }

    private static class LogLinearInterpolationImpl
    implements Interpolator {
        private LogLinearInterpolation delegate;

        public LogLinearInterpolationImpl(LogLinearInterpolation delegate) {
            this.delegate = delegate;
        }

        @Override
        public final Interpolation interpolate(double[] x, double[] y) {
            return this.interpolate(x.length, x, y);
        }

        @Override
        public final Interpolation interpolate(int size, double[] x, double[] y) {
            this.delegate.vx = Arrays.copyOfRange(x, 0, size);
            this.delegate.vy = Arrays.copyOfRange(y, 0, size);
            this.delegate.reload();
            return this.delegate;
        }

        @Override
        public final boolean isGlobal() {
            return false;
        }
    }
}

