/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.asian;

import org.joda.primitives.list.impl.ArrayDoubleList;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.AverageType;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.math.Constants;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;
import org.jquantlib.math.distributions.NormalDistribution;
import org.jquantlib.pricingengines.BlackCalculator;
import org.jquantlib.pricingengines.Greeks;
import org.jquantlib.pricingengines.arguments.DiscreteAveragingAsianOptionArguments;
import org.jquantlib.pricingengines.asian.DiscreteAveragingAsianOptionEngine;
import org.jquantlib.pricingengines.results.OneAssetOptionResults;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.time.Frequency;
import org.jquantlib.util.Date;

public class AnalyticDiscreteGeometricAveragePriceAsianEngine
extends DiscreteAveragingAsianOptionEngine {
    @Override
    public void calculate() {
        double nx_1;
        double Nx_1;
        int i;
        int pastFixings;
        double runningLog;
        if (((DiscreteAveragingAsianOptionArguments)this.arguments).exercise.type() != Exercise.Type.EUROPEAN) {
            throw new IllegalArgumentException("not an European Option");
        }
        if (((DiscreteAveragingAsianOptionArguments)this.arguments).averageType == AverageType.Geometric) {
            if (!(((DiscreteAveragingAsianOptionArguments)this.arguments).runningAccumulator > 0.0)) {
                throw new IllegalArgumentException("positive running product required: " + ((DiscreteAveragingAsianOptionArguments)this.arguments).runningAccumulator + " not allowed");
            }
            runningLog = Math.log(((DiscreteAveragingAsianOptionArguments)this.arguments).runningAccumulator);
            pastFixings = ((DiscreteAveragingAsianOptionArguments)this.arguments).pastFixings;
        } else {
            runningLog = 1.0;
            pastFixings = 0;
        }
        StrikedTypePayoff payoff = null;
        if (!(((DiscreteAveragingAsianOptionArguments)this.arguments).payoff instanceof StrikedTypePayoff)) {
            throw new IllegalArgumentException("non-plain payoff given");
        }
        payoff = (StrikedTypePayoff)((DiscreteAveragingAsianOptionArguments)this.arguments).payoff;
        GeneralizedBlackScholesProcess process = (GeneralizedBlackScholesProcess)((DiscreteAveragingAsianOptionArguments)this.arguments).stochasticProcess;
        if (process == null) {
            throw new NullPointerException("Black-Scholes process required");
        }
        Date referenceDate = process.riskFreeRate().getLink().referenceDate();
        DayCounter rfdc = process.riskFreeRate().getLink().dayCounter();
        DayCounter divdc = process.dividendYield().getLink().dayCounter();
        DayCounter voldc = process.blackVolatility().getLink().dayCounter();
        ArrayDoubleList fixingTimes = new ArrayDoubleList();
        for (i = 0; i < ((DiscreteAveragingAsianOptionArguments)this.arguments).fixingDates.size(); ++i) {
            if (!((DiscreteAveragingAsianOptionArguments)this.arguments).fixingDates.get(i).ge(referenceDate)) continue;
            double t = voldc.yearFraction(referenceDate, ((DiscreteAveragingAsianOptionArguments)this.arguments).fixingDates.get(i));
            fixingTimes.add(t);
        }
        int remainingFixings = fixingTimes.size();
        int numberOfFixings = pastFixings + remainingFixings;
        double N = numberOfFixings;
        double pastWeight = (double)pastFixings / N;
        double futureWeight = 1.0 - pastWeight;
        double timeSum = 0.0;
        for (int j = 0; j < fixingTimes.size(); ++j) {
            timeSum += ((Double)fixingTimes.get(j)).doubleValue();
        }
        double vola = process.blackVolatility().getLink().blackVol(((DiscreteAveragingAsianOptionArguments)this.arguments).exercise.lastDate(), payoff.strike());
        double temp = 0.0;
        for (i = pastFixings + 1; i < numberOfFixings; ++i) {
            temp += (Double)fixingTimes.get(i - pastFixings - 1) * (N - (double)i);
        }
        double variance = vola * vola / N / N * (timeSum + 2.0 * temp);
        double dsigG_dsig = Math.sqrt(timeSum + 2.0 * temp) / N;
        double sigG = vola * dsigG_dsig;
        double dmuG_dsig = -(vola * timeSum) / N;
        Date exDate = ((DiscreteAveragingAsianOptionArguments)this.arguments).exercise.lastDate();
        double dividendRate = process.dividendYield().getLink().zeroRate(exDate, divdc, Compounding.CONTINUOUS, Frequency.NO_FREQUENCY).rate();
        double riskFreeRate = process.riskFreeRate().getLink().zeroRate(exDate, rfdc, Compounding.CONTINUOUS, Frequency.NO_FREQUENCY).rate();
        double nu = riskFreeRate - dividendRate - 0.5 * vola * vola;
        double s = process.stateVariable().getLink().evaluate();
        double muG = pastWeight * runningLog + futureWeight * Math.log(s) + nu * timeSum / N;
        double forwardPrice = Math.exp(muG + variance / 2.0);
        double riskFreeDiscount = process.riskFreeRate().getLink().discount(((DiscreteAveragingAsianOptionArguments)this.arguments).exercise.lastDate());
        BlackCalculator black = new BlackCalculator(payoff, forwardPrice, Math.sqrt(variance), riskFreeDiscount);
        ((OneAssetOptionResults)this.results).value = black.value();
        ((OneAssetOptionResults)this.results).delta = futureWeight * black.delta(forwardPrice) * forwardPrice / s;
        ((OneAssetOptionResults)this.results).gamma = forwardPrice * futureWeight / (s * s) * (black.gamma(forwardPrice) * futureWeight * forwardPrice - pastWeight * black.delta(forwardPrice));
        CumulativeNormalDistribution CND = new CumulativeNormalDistribution();
        NormalDistribution ND = new NormalDistribution();
        if (sigG > Constants.QL_EPSILON) {
            double x_1 = (muG - Math.log(payoff.strike()) + variance) / sigG;
            Nx_1 = CND.evaluate(x_1);
            nx_1 = ND.evaluate(x_1);
        } else {
            Nx_1 = muG > Math.log(payoff.strike()) ? 1.0 : 0.0;
            nx_1 = 0.0;
        }
        ((OneAssetOptionResults)this.results).vega = forwardPrice * riskFreeDiscount * ((dmuG_dsig + sigG * dsigG_dsig) * Nx_1 + nx_1 * dsigG_dsig);
        if (payoff.optionType() == Option.Type.PUT) {
            ((OneAssetOptionResults)this.results).vega -= riskFreeDiscount * forwardPrice * (dmuG_dsig + sigG * dsigG_dsig);
        }
        double tRho = rfdc.yearFraction(process.riskFreeRate().getLink().referenceDate(), ((DiscreteAveragingAsianOptionArguments)this.arguments).exercise.lastDate());
        ((OneAssetOptionResults)this.results).rho = black.rho(tRho) * timeSum / (N * tRho) - (tRho - timeSum / N) * ((OneAssetOptionResults)this.results).value;
        double tDiv = divdc.yearFraction(process.dividendYield().getLink().referenceDate(), ((DiscreteAveragingAsianOptionArguments)this.arguments).exercise.lastDate());
        ((OneAssetOptionResults)this.results).dividendRho = black.dividendRho(tDiv) * timeSum / (N * tDiv);
        ((OneAssetOptionResults)this.results).strikeSensitivity = black.strikeSensitivity();
        ((OneAssetOptionResults)this.results).theta = Greeks.blackScholesTheta(process, ((OneAssetOptionResults)this.results).value, ((OneAssetOptionResults)this.results).delta, ((OneAssetOptionResults)this.results).gamma);
    }
}

