package aQute.lib.diff;

import java.util.*;

/**
 * @author pkriens
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class DiffBinary {
	byte		[] src;
	byte		[] tgt;
	int			[] sindex;
	final static int S  = 8;
	int 		rover;
	BitSet		map= new BitSet();
	int			l;
	int			osrc;
	int			lsrc;
	
	public static List diff( byte [] a, byte [] b ) {
		DiffBinary d = new DiffBinary( a, b );
		return d.computeDelta();
	}
	
	public DiffBinary( byte [] src, byte[] tgt ) {
		this.src = src;
		this.tgt = tgt;
		map.set(0,src.length);
	}

	List computeDelta( ) {
		Vector			result = new Vector();
		Delta			last = null;
		boolean			equal = true;
		
		initMatch(src);
		while ( rover < tgt.length ) {
			findMatch( src, tgt, rover );
			if ( l < S ) {
				if ( last == null ) {
					last = new Delta('i',tgt,rover, 0, 0);
					result.add( last );
				}
				last.length++;				
				rover+=1;
				equal = false;
			}
			else {
				last = null;
				Delta copy = new Delta('c',src,osrc,rover,l);
				result.add( copy );
				map.clear( osrc, osrc+l );
				lsrc = osrc + l;
				rover+=l;
			}
		}
		int set = map.nextSetBit(0);	;
		while ( set >= 0 ) {
			equal = false;
			int clrd = map.nextClearBit(set);
			if ( clrd < 0 )
				clrd = map.length();
			Delta	delta = new Delta('d',src,set,rover, clrd - set);
			result.add( delta );
			set = map.nextSetBit(clrd);
		}
		if ( equal )
			return null;
			
		Collections.sort(result);
		return result;
	}


	void initMatch( byte [] src ) {
		sindex = new int[src.length*10+1];
		for ( int i=0; i<sindex.length; i++ ) sindex[i]=-1;
		
		int i = 0;
		while ( i + S <= src.length ) {
			int f = (int) (adler32( src,i, i+S ) % sindex.length);
			while ( sindex[f] != -1 )
				f = (f+1) % sindex.length;
	
			sindex[ f  ] = i;
			i+=1;	// This might be a memory hog
		}
	}

	/**
	 * Adler-32 is composed of two sums accumulated per byte: 
	 * s1 is the sum of all bytes, s2 is the sum of all s1 values. 
	 * Both sums are done modulo 65521. s1 is initialized to 1, s2 
	 * to zero. The Adler-32 checksum is stored as s2*65536 + s1 in 
	 * most- significant-byte first (network) order. 
	 */

	long adler32( byte[] src, int start, int end ) {
		long s1 = 0;
		long s2 = 0;
		if ( end > src.length ) end = src.length;
		
		for ( int i=start; i <end; i++ ) {
			s1 = (s1 + (0xFF&src[i])) % 65521;
			s2 = (s2 + s1)  % 65521;
		}
		return 0xFFFFFFFF & ((s2 << 16) + s1);
	}


	void findMatch( byte [] src, byte [] tgt, int otgt ) {
		l = -1;
		int f = (int) (adler32( tgt, otgt, otgt+S ) % sindex.length);
		while ( sindex[(int)f] != -1 
		&& ! map.get(sindex[(int)f])) {
			f = (f+1) % sindex.length;
		}
		osrc = sindex[ (int) f  ];
		if ( osrc < 0 )
			return;
			
		matchLength( tgt, otgt );
	}


	//
	// This is ugly because we set the global variables
	// osrc + l, otherwise we had to create a brand new object,
	//
	void matchLength( byte [] tgt, int otgt ) {
		int i=0;
		while ( otgt+i< tgt.length 
		&& osrc+i<src.length 
		&& tgt[i+otgt] == src[i+osrc] 
		&& map.get(osrc+i)
		) 
			i++;
			
		l = i;
		i = 1;
		while ( otgt-i > rover 
		&& osrc-i>0 
		&& tgt[otgt-i] == src[osrc-i] 
		&& map.get(osrc-i)
		) {
			l++;
			i++;
		}
		osrc = osrc + 1 - i;
	}
	
}
