package aQute.test;

import java.io.*;
import java.util.*;

import junit.framework.*;
import aQute.lib.tiny.*;

public class TestTiny extends TestCase {
	
	public void testSimple() throws Exception {
		Interpreter intp = new Interpreter();
		intp.setProperty("x","abc");
		assertEquals(new Integer("720"), intp.eval("1 * 2 * 3 * 4 * 5 * 6"));
		assertEquals(new Integer(3), intp.eval("(abcdef substring 1 4) length"));
		assertEquals(new Integer(3), intp.eval("2 + 2 - 1"));
		assertEquals(new Integer(-1), intp.eval("-1"));
		assertEquals(new Integer("3"), intp.eval("$x length"));
		assertEquals("abc", intp.eval("$x toString toString toString"));
		assertEquals("abc", intp.eval("$x"));
		assertEquals( new Integer(3), intp.eval("$x length"));
		assertEquals(new Integer("-1"), intp.eval("((((((((-1))))))))"));
		assertEquals(new Integer("-1"), intp.eval("(-1)"));
		assertEquals(new Integer("1"), intp.eval("(1)"));
		assertEquals(new Integer("1"), intp.eval("2+(-1)"));
		assertEquals(new Integer("-1"), intp.eval("-1"));
		assertEquals(new Integer("4"), intp.eval("a=4; $a"));
		assertEquals(new Integer("4"), intp.eval("4"));
		assertEquals(new Integer("4"), intp.eval("a=4"));
		assertEquals(new Integer("4"), intp.eval("a = 4"));
		
	}

	public void testAssignment() throws Exception {
		Interpreter intp = new Interpreter();
		assertEquals( new Integer("0"), intp.eval("i=0"));		
	}
	public void testNew() throws Exception {
		Interpreter intp = new Interpreter();
		assertEquals( new Integer("0"), intp.eval("new java.lang.Integer 0"));
		assertEquals( new Integer("0"), intp.eval("i = new java.lang.Integer 0; $i"));
	}

	public void testCommand() throws Exception {
		final List options = new ArrayList();
		Interpreter intp = new Interpreter();
		intp.setProperty("tst", new Object() {
			public void setOption(File option) {
				options.add(option);
			}
		});
		intp.eval("tst -option 4 -option 5 -option 6");
		assertEquals(3, options.size());
	}
	
	public void testFac() throws Exception {
		Interpreter intp = new Interpreter();
		intp.eval("function fac [a] { if { $a <= 1 } { 1 } { $a * fac $a - 1 } }");
		assertEquals(new Integer(720), intp.eval("fac 6"));
		assertEquals(new Integer(3628800), intp.eval("fac 10"));
		
	}
	
	public void testWhile() throws Exception {
		Interpreter intp = new Interpreter();
		assertEquals(new Integer(0), intp.eval("x=3; while {$x>0} {x=$x - 1}"));
	}
	
	public void testFunction() throws Exception {
		Interpreter intp = new Interpreter();
		assertEquals(new Integer(3), intp.eval("function foo [a b] { $a + $b }; foo 1 2"));
	}
	
	public void testList() throws Exception {
		Interpreter intp = new Interpreter();
		List l = (List) intp.eval("[ 1 2 3 ]");
		assertTrue( l.contains(new Integer(1)));
		assertTrue( l.contains(new Integer(2)));
		assertTrue( l.contains(new Integer(3)));
		assertEquals( 3, l.size());
	}
	
	
	public void testIf() throws Exception {
		Interpreter intp = new Interpreter();
		assertEquals(null, intp.eval("if {1>2} {1}"));
		assertEquals(new Integer(1), intp.eval("if {1<2} {1}"));
		assertEquals(new Integer(2), intp.eval("if {1>2} {1} {2}"));
		assertEquals(new Integer(1), intp.eval("if {2>1} {1} {2}"));
	}
	
	


	public void testFor() throws Exception {
		Interpreter intp = new Interpreter();
		assertEquals(new Integer("6"), intp.eval("y=3; y = $y+1; y = $y + 1; y = $y + 1; $y"));
		assertEquals(new Integer("6"), intp.eval("y=3; for {x=0} {$x<3} { x=$x+1} { y = $y+1 }; $y"));
		
	}

	public void testComparison() throws Exception {
		Interpreter intp = new Interpreter();
		assertEquals(Boolean.TRUE, intp.eval("2   !=   1"));		
		assertEquals(Boolean.FALSE, intp.eval("2 == 1"));		
		assertEquals(Boolean.TRUE, intp.eval("2 == 2"));		
		assertEquals(Boolean.FALSE, intp.eval("2 != 2"));		
		
		assertEquals(Boolean.TRUE, intp.eval("2>=1"));		
		assertEquals(Boolean.TRUE, intp.eval("2>=2"));		
		assertEquals(Boolean.TRUE, intp.eval("2>1"));		
		assertEquals(Boolean.TRUE, intp.eval("2>=1"));		
		assertEquals(Boolean.FALSE, intp.eval("2<=1"));		
		assertEquals(Boolean.TRUE, intp.eval("2<=2"));		
		assertEquals(Boolean.FALSE, intp.eval("2<1"));		
		assertEquals(Boolean.FALSE, intp.eval("2<=1"));		
		
		assertEquals(Boolean.FALSE, intp.eval("1>=2"));		
		assertEquals(Boolean.FALSE, intp.eval("1>2"));		
		assertEquals(Boolean.FALSE, intp.eval("1>=2"));		
		assertEquals(Boolean.TRUE, intp.eval("1<=2"));		
		assertEquals(Boolean.TRUE, intp.eval("1<2"));		
		assertEquals(Boolean.TRUE, intp.eval("1<=2"));		
	}
	
	public void testPrint() throws Exception {
		Interpreter intp = new Interpreter();
		intp.setProperty("x","abc");
		intp.eval("print 3");
	}
	
	
}
