/*
 * $Header: /cvs/xierpa/aQute.lib/src/aQute/bytecodes/PoolEntry.java,v 1.1 2007-01-03 17:27:52 pkriens Exp $
 * 
 * Copyright (c) The OSGi Alliance (2006). All Rights Reserved.
 * 
 * Implementation of certain elements of the OSGi Specification may be subject
 * to third party intellectual property rights, including without limitation,
 * patent rights (such a third party may or may not be a member of the OSGi
 * Alliance). The OSGi Alliance is not responsible and shall not be held
 * responsible in any manner for identifying or failing to identify any or all
 * such third party intellectual property rights.
 * 
 * This document and the information contained herein are provided on an "AS IS"
 * basis and THE OSGI ALLIANCE DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO ANY WARRANTY THAT THE USE OF THE INFORMATION
 * HEREIN WILL NOT INFRINGE ANY RIGHTS AND ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT WILL THE
 * OSGI ALLIANCE BE LIABLE FOR ANY LOSS OF PROFITS, LOSS OF BUSINESS, LOSS OF
 * USE OF DATA, INTERRUPTION OF BUSINESS, OR FOR DIRECT, INDIRECT, SPECIAL OR
 * EXEMPLARY, INCIDENTIAL, PUNITIVE OR CONSEQUENTIAL DAMAGES OF ANY KIND IN
 * CONNECTION WITH THIS DOCUMENT OR THE INFORMATION CONTAINED HEREIN, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 * 
 * All Company, brand and product names may be trademarks that are the sole
 * property of their respective owners. All rights reserved.
 */

package aQute.bytecodes;

import java.io.*;

public class PoolEntry {
	short	tag;
	int		a;
	int		b;
	Object	o;
	PoolEntry	pool[];
	
	PoolEntry(PoolEntry[] cp, DataInputStream in) throws IOException {
		pool = cp;
		tag = (short) in.readUnsignedByte();
		switch (tag) {
			case 1 : // Utf8
				o = in.readUTF();
				break;

			case 3 : // Integer
				o = new Integer(in.readInt());
				break;

			case 4 : // Float
				o = new Float(in.readFloat());
				break;
				
			case 5 : // Long
				o = new Long(in.readLong());
				break;
				
			case 6 : // Double
				o = new Double(in.readDouble());
				break;
				
			case 7 : // Class
				a = in.readUnsignedShort();
				break;

			case 8 : // String
				a = in.readUnsignedShort();
				break;

			case 9 : // Field Ref
			case 10 : // Method Ref
			case 11 : // Interface Method Ref
			case 12 : // Name and Type
				a = in.readUnsignedShort();
				b = in.readUnsignedShort();
				break;
				
			default :
				throw new IllegalArgumentException("Invalid constant pool: "
						+ tag);
		}
	}

	public String getClassName() {
		assert(tag==7);
		return pool[a].getString();
	}

	public String getString() {
		assert(tag==1);
		return (String) o;
	}

}
