/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.HashMap;
import org.apache.commons.text.similarity.CosineSimilarity;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class CosineSimilarityTest {
    @Test
    public void testCosineSimilarityReturningDoubleWhereByteValueIsZero() {
        HashMap hashMap = new HashMap();
        Assertions.assertThat((Double)CosineSimilarity.INSTANCE.cosineSimilarity(hashMap, hashMap)).isEqualTo(0.0, Assertions.within((Double)0.01));
    }

    @Test
    public void testCosineSimilarityThrowsIllegalArgumentException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> {
            HashMap map = new HashMap();
            CosineSimilarity.INSTANCE.cosineSimilarity(map, null);
        });
    }

    @Test
    public void testCosineSimilarityWithNonEmptyMap() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Integer integer = -397;
        hashMap.put("3J/$3.L", integer);
        HashMap hashMapTwo = new HashMap();
        Assertions.assertThat((Double)CosineSimilarity.INSTANCE.cosineSimilarity(hashMap, hashMapTwo)).isEqualTo(0.0, Assertions.within((Double)0.01));
    }

    @Test
    public void testCosineSimilarityWithNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> CosineSimilarity.INSTANCE.cosineSimilarity(null, null));
    }
}

