/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.Building;
import megamek.common.Entity;
import megamek.common.EquipmentMode;
import megamek.common.IGame;
import megamek.common.Report;
import megamek.common.TagInfo;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.WeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAGHandler
extends WeaponHandler {
    private static final long serialVersionUID = -967656770476044773L;

    public TAGHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected int calcDamagePerHit() {
        return 0;
    }

    @Override
    protected void handleEntityDamage(Entity entity, Vector<Report> vector, Building building, int n, int n2, int n3, int n4) {
        if (entity == null) {
            this.r = new Report(3187);
            this.r.subject = this.subjectId;
            vector.addElement(this.r);
        } else {
            int n5 = 1;
            EquipmentMode equipmentMode = this.weapon.curMode();
            if (equipmentMode != null) {
                if (equipmentMode.getName() == "1-shot") {
                    n5 = 1;
                } else if (equipmentMode.getName() == "2-shot") {
                    n5 = 2;
                } else if (equipmentMode.getName() == "3-shot") {
                    n5 = 3;
                } else if (equipmentMode.getName() == "4-shot") {
                    n5 = 4;
                }
            }
            if (n5 < 1) {
                n5 = 1;
            }
            TagInfo tagInfo = new TagInfo(this.ae.getId(), entity.getId(), n5, false);
            this.game.addTagInfo(tagInfo);
            entity.setTaggedBy(this.ae.getId());
            this.r = new Report(3188);
            this.r.subject = this.subjectId;
            vector.addElement(this.r);
        }
    }

    @Override
    protected boolean handleSpecialMiss(Entity entity, boolean bl, Building building, Vector<Report> vector) {
        int n = 1;
        EquipmentMode equipmentMode = this.weapon.curMode();
        if (equipmentMode != null) {
            if (equipmentMode.getName() == "1-shot") {
                n = 1;
            } else if (equipmentMode.getName() == "2-shot") {
                n = 2;
            } else if (equipmentMode.getName() == "3-shot") {
                n = 3;
            } else if (equipmentMode.getName() == "4-shot") {
                n = 4;
            }
        }
        TagInfo tagInfo = new TagInfo(this.ae.getId(), entity.getId(), n, true);
        this.game.addTagInfo(tagInfo);
        return false;
    }

    @Override
    public boolean cares(IGame.Phase phase) {
        return phase == IGame.Phase.PHASE_OFFBOARD;
    }
}

