/***********************************************************************
* Name:
*        dapipref.c
*
* Function:
*        Handles preference functions invoked via menu selections
*
* Environment:
*        This is a PLATFORM-INDEPENDENT source file. As such it may
*        contain no dependencies on any specific operating system
*        environment or hardware platform.
*
***********************************************************************/
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "dsmapitd.h"
#include "dsmapifp.h"
#include "dsmrc.h"
#include "dapitype.h"        /* Sample API data types.  */
#include "dapiutil.h"
#include "dapiproc.h"
/*----------------------------------------------------------------------+
| Private routines
.----------------------------------------------------------------------*/
static dsInt16_t PrefGetInput(const char *inst1,
                              const char *inst2,
                              dsUint32_t curval,
                              dsUint32_t *newval);

/*----------------------------------------------------------------------+
| Public routines
.----------------------------------------------------------------------*/

/*----------------------------------------------------------------------+
| Name:    smpapi_pref_query()
|
| Action:  Display the current preference settings.
|
| Input:   None
|
| Returns: RC_OK             - Successful
|
| Side
| Effects: None
|
| Notes:   None
+----------------------------------------------------------------------*/
dsInt16_t smpapi_pref_query(dialog *sel_dialog)
{
   printf("        Send buffer size: %u\n",pref.sz_send_buff);
   printf("         Get buffer size: %u\n",pref.sz_recv_buff);
   printf("       Verbose output is: ");
   if (pref.verbose)
      printf("On\n");
   else
      printf("Off\n");
   printf("Max items in a batch get: %u\n",pref.max_restore_items);
   printf("  Display query details?: ");
   if (pref.qry_details)
      printf("Yes\n");
   else
      printf("No\n");

   printf("      Use size estimate?: ");
      if (pref.use_est)
         printf("Yes\n");
      else
         printf("No\n");
   printf("           Echo input is: ");
   if (pref.echo_in)
      printf("On\n");
   else
      printf("Off\n");
return 0;
}

/*----------------------------------------------------------------------+
| Name:    smpapi_pref_sendbuff()
|
| Action:  Display the current send buffer setting and get a new value
|          if user inputs one.
|
| Input:   None
|
| Returns: RC_OK             - Successful
|
| Side
| Effects: None
|
| Notes:   None
+----------------------------------------------------------------------*/
dsInt16_t smpapi_pref_sendbuff(dialog *sel_dialog)
{
   PrefGetInput("Current send buffer size: ",
                "Input new value (minimum 1 byte) or Enter to quit :",
                 pref.sz_send_buff,
                &pref.sz_send_buff);
   return 0;
}

/*----------------------------------------------------------------------+
| Name:    smpapi_pref_recvbuff()
|
| Action:  Display the current recv buffer setting and get a new value
|          if user inputs one.
|
| Input:   None
|
| Returns: RC_OK             - Successful
|
| Side
| Effects: None
|
| Notes:   None
+----------------------------------------------------------------------*/
dsInt16_t smpapi_pref_recvbuff(dialog *sel_dialog)
{

   PrefGetInput("Current get buffer size: ",
                "Input new value (minimum 1 byte) or Enter to quit :",
                 pref.sz_recv_buff,
                &pref.sz_recv_buff);
   return 0;
}


/*----------------------------------------------------------------------+
| Name:    smpapi_pref_verbose()
|
| Action:  Display the current verbose setting and see if user wants
|          to change it.
|
| Input:   None
|
| Returns: RC_OK             - Successful
|
| Side
| Effects: None
|
| Notes:   None
----------------------------------------------------------------------*/
dsInt16_t smpapi_pref_verbose(dialog *sel_dialog)
{
   dsBool_t done = bFalse;
   char input_buff[1024];

   while (!done)
   {
      input_buff[0] = 0x00;

      printf("Verbose output is: ");
      if (pref.verbose)
         printf("On (Verbose)\n");
      else
         printf("Off (Quiet)\n");

      printf("Input new value (V=Verbose, Q=Quiet):\n");
      ourGetS(input_buff);

      switch (*input_buff)
      {
         case 'v' :
         case 'V' :
            pref.verbose = bTrue;
            done = bTrue;
            break;
         case 'q' :
         case 'Q' :
            pref.verbose = bFalse;
            done = bTrue;
            break;
         case 0x00 :
            done = bTrue;
            break;
         default :
            printf("Input value invalid, please retry.\n");
      }
   }
return 0;

}

/*----------------------------------------------------------------------+
| Name:    smpapi_pref_details()
|
| Action:  Display the current details setting and see if user wants
|          to change it.
|
| Input:   None
|
| Returns: RC_OK             - Successful
|
| Side
| Effects: None
|
| Notes:   None
----------------------------------------------------------------------*/
dsInt16_t smpapi_pref_details(dialog *sel_dialog)
{
   dsBool_t done = bFalse;
   char input_buff[1024];

   while (!done)
   {
      input_buff[0] = 0x00;

      printf("Query details setting is: ");
      if (pref.qry_details)
         printf("Yes\n");
      else
         printf("No\n");

      printf("Input new value (Y/N):\n");
      ourGetS(input_buff);

      switch (*input_buff)
      {
         case 'y' :
         case 'Y' :
            pref.qry_details = bTrue;
            done = bTrue;
            break;
         case 'n' :
         case 'N' :
            pref.qry_details = bFalse;
            done = bTrue;
            break;
         case 0x00 :
            done = bTrue;
            break;
         default :
            printf("Input value invalid, please retry.\n");
      }
   }
return 0;

}

/*----------------------------------------------------------------------+
| Name:    smpapi_pref_sizeest()
|
| Action:  Display the current details setting and see if user wants
|          to change it.
|
| Input:   None
|
| Returns: RC_OK             - Successful
|
| Side
| Effects: None
|
| Notes:   None
----------------------------------------------------------------------*/
dsInt16_t smpapi_pref_sizeest(dialog *sel_dialog)
{
   dsBool_t done = bFalse;
   char input_buff[1024];

   while (!done)
   {
      input_buff[0] = 0x00;

      printf("Use size estimate setting is: ");
      if (pref.use_est)
         printf("Yes\n");
      else
         printf("No\n");

      printf("Input new value (Y/N):\n");
      ourGetS(input_buff);

      switch (*input_buff)
      {
         case 'y' :
         case 'Y' :
            pref.use_est = bTrue;
            done = bTrue;
            break;
         case 'n' :
         case 'N' :
            pref.use_est = bFalse;
            done = bTrue;
            break;
         case 0x00 :
            done = bFalse;
            break;
         default :
            printf("Input value invalid, please retry.\n");
      }
   }
return 0;

}

/*----------------------------------------------------------------------+
| Name:    smpapi_pref_echoin()
|
| Action:  Display the current verbose input setting and see if user
|          wants to change it.
|
| Input:   None
|
| Returns: RC_OK             - Successful
|
| Side
| Effects: None
|
| Notes:   None
----------------------------------------------------------------------*/
dsInt16_t smpapi_pref_echoin(dialog *sel_dialog)
{
   dsBool_t done = bFalse;
   char input_buff[1024];

   while (!done)
   {
      input_buff[0] = 0x00;

      printf("Echo input is: ");
      if (pref.echo_in)
         printf("On (Verbose)\n");
      else
         printf("Off (Quiet)\n");

      printf("Input new value (V=Verbose, Q=Quiet):\n");
      ourGetS(input_buff);

      switch (*input_buff)
      {
         case 'v' :
         case 'V' :
            pref.echo_in = bTrue;
            done = bTrue;
            break;
         case 'q' :
         case 'Q' :
            pref.echo_in = bFalse;
            done = bTrue;
            break;
         case 0x00 :
            done = bTrue;
            break;
         default :
            printf("Input value invalid, please retry.\n");
      }
   }
return 0;

}


/*----------------------------------------------------------------------+
| Name:    smpapi_pref_restitem()
|
| Action:  Display the current number of items restored in a batch &
|          accept new one if entered.
|
| Input:   None
|
| Returns: RC_OK             - Successful
|
| Side
| Effects: None
|
| Notes:   None
----------------------------------------------------------------------*/
dsInt16_t smpapi_pref_restitem(dialog *sel_dialog)
{

   PrefGetInput("Current batch restore items: ",
                "Input new value (minimum 1) or Enter to quit :",
                 pref.max_restore_items,
                &pref.max_restore_items);
   return 0;
}

/*----------------------------------------------------------------------+
| Name:    smpapi_pref_exit()
|
| Action:  Routine called to exit preferences menu.  Do any cleanup needed
|          and return.
|
| Input:   None
|
| Returns: RC_OK             - Successful
|
| Side
| Effects: None
|
| Notes:   None
----------------------------------------------------------------------*/
dsInt16_t smpapi_pref_exit(dialog *sel_dialog)
{
return 0;
}


/*----------------------------------------------------------------------+
| Name:    PrefGetInput()
|
| Action:  Display the current recv buffer setting and get a new value
|          if user inputs one.
|
| Input:   None
|
| Returns: RC_OK             - Successful
|
| Side
| Effects: None
|
| Notes:   None
+----------------------------------------------------------------------*/
static dsInt16_t PrefGetInput(const char *inst1, const char *inst2,
                              dsUint32_t curval, dsUint32_t *newval)
{
   dsBool_t   done = bFalse;
   dsInt32_t  new_sz;
   char       input_buff[1024];

   while (!done)
   {
      input_buff[0] = 0x00;
      printf("%s%u\n",inst1,curval);
      printf("%s",inst2); fflush(stdout);
      ourGetS(input_buff);
      new_sz = strtol(input_buff,NULL,10);

      if (input_buff[0])
      {
         if (new_sz <= 0)
         {
            printf("Input value invalid, please retry.\n");
         }
         else
         {
            *newval = new_sz;                 /* Save new value */
            done = bTrue;                     /* Get out.       */
         }
      }
      else done = bTrue;
   }
return 0;
}

