/***********************************************************************
* Name:
*        dpsthread.c
*
* Environment:      *********************************************
*                   ** This is a platform-specific source file **
*                   ** versioned for UNIX                      **
*
*                   *********************************************
*
* Public Routines:
*
* Description:
***********************************************************************/
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>

#include "dsmapitd.h"
#include "dpsthread.h"

/*----------------------------------------------------------------------+
|  d p s M u t e x I n i t                             public function  |
|  ===================================================================  |
|  Purpose: Initalizes a mutex                                          |
|                                                                       |
+----------------------------------------------------------------------*/
int dpsMutexInit(dpsMutex_t *mutex)
{
   int rc;

   if ((rc = pthread_mutex_init(mutex, NULL)) != 0)
         printf( "Mutex init failed: %d.\n",rc);
   return rc;
}

/*----------------------------------------------------------------------+
|  d p s M u t e x D e s t r o y                       public function  |
|  ===================================================================  |
|  Purpose: Destroys a mutex                                            |
|                                                                       |
+----------------------------------------------------------------------*/
int dpsMutexDestroy(dpsMutex_t *mutex)
{
  int rc;

   if ((rc = pthread_mutex_destroy(mutex)) != 0)
         printf( "Mutex destroy failed: %d.\n",rc);
   return rc;

}

/*----------------------------------------------------------------------+
|  d p s M u t e x L o c k                             public function  |
|  ===================================================================  |
|  Purpose: Locks a mutex                                               |
+----------------------------------------------------------------------*/
int dpsMutexLock(dpsMutex_t *mutex)
{
  int rc;

   if ((rc = pthread_mutex_lock(mutex)) != 0)
         printf( "Mutex lock failed: %d.\n",rc);
   return rc;
}

/*----------------------------------------------------------------------+
|  d p s M u t e x U n l o c k                         public function  |
|  ===================================================================  |
|  Purpose: Releases a mutex                                            |
|                                                                       |
|  Returns:                                                             |
|                                                                       |
+----------------------------------------------------------------------*/
int dpsMutexUnlock(dpsMutex_t *mutex)
{
  int rc;

   if ((rc = pthread_mutex_unlock(mutex)) != 0)
         printf( "Mutex unlock failed: %d.\n",rc);
   return rc;

}
/*----------------------------------------------------------------------+
| d p s C r e a t e C o n d i t i o n                  public  function |
| ===================================================================== |
| Purpose: Initialize a condition variable                              |
|                                                                       |
|                                                                       |
| Parameters:                                                           |
|    condP     -> address of a condition                                |
|                                                                       |
| Returns:                                                              |
|                                                                       |
+----------------------------------------------------------------------*/
int dpsCreateCondition(dpsCondition_t *condP)
{
  int rc;

   if ((rc = pthread_cond_init(condP, NULL)) != 0)
         printf( "Condition init failed: %d.\n",rc);
   return rc;
}
/*----------------------------------------------------------------------+
| d p s D e s t r o y C o n d i t i o n                                 |
+----------------------------------------------------------------------*/
int dpsDestroyCondition(dpsCondition_t *condP)
{
  int rc;

   if ((rc = pthread_cond_destroy(condP)) != 0)
         printf( "Condition Destroy failed: %d.\n",rc);
   return rc;

}

/*----------------------------------------------------------------------+
| d p s W a i t C o n d i t i o n                      public  function |
| ===================================================================== |
| Purpose: Wait on    a condition variable                              |
|          Note: mutex must be held before entering, it is released     |
|                during wait, and held on exiT                          |
| Parameters:                                                           |
|    condP     -> address of a condition                                |
|    mutexP    -> mutex                                                 |
|                                                                       |
| Returns:                                                              |
|                                                                       |
+----------------------------------------------------------------------*/
int dpsWaitCondition(dpsCondition_t *condP, dpsMutex_t *mutexP)
{

  int rc;

   while (( rc = pthread_cond_wait (condP, mutexP) ))
   {
      if (rc != EINTR)
      {
         printf("Condition wait failed: error %d\n", rc);
         break;
      }
   }
  return rc;

}

/*----------------------------------------------------------------------+
| d p s S i g n a l C o n d i t i o n                  public  function |
| ===================================================================== |
| Purpose: Signal     a condition variable                              |
|                                                                       |
|                                                                       |
| Parameters:                                                           |
|    condP     -> address of a condition                                |
|                                                                       |
| Returns:                                                              |
|                                                                       |
+----------------------------------------------------------------------*/
int  dpsSignalCondition(dpsCondition_t *condP)
{
  int rc;

   if ((rc = pthread_cond_signal(condP)) != 0)
         printf( "Condition signal failed: %d.\n",rc);
   return rc;

}

/*----------------------------------------------------------------------+
| d p s T h r e a d C r e a t e                        public  function |
| ===================================================================== |
| Purpose: Creates a thread                                             |
|                                                                       |
|                                                                       |
| Parameters:                                                           |
|    func     -> address of a function                                  |
|    arg      -> address of the parameters                              |
|                                                                       |
| Returns:                                                              |
|                                                                       |
+----------------------------------------------------------------------*/
int dpsThreadCreate(void *(*func)(void*), void *arg)
{

   pthread_t thread;

   pthread_create(&thread, NULL, func, arg);

   return 0;
}

