/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.lookup.BiFunctionStringLookup;
import org.apache.commons.text.lookup.BiStringLookup;
import org.apache.commons.text.lookup.FunctionStringLookup;
import org.apache.commons.text.lookup.StringLookupFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BiFunctionStringLookupTest {
    private static final String SEPARATOR = ".";
    private final BiFunction<String, Map<String, Object>, Object> nestedMapBiFunction = (k, m) -> {
        String keyCandidate = StringUtils.substringBefore((String)k, (String)SEPARATOR);
        if (keyCandidate.isEmpty()) {
            return m.get(k);
        }
        Object value = m.get(keyCandidate);
        if (value instanceof Map) {
            return this.nestedMapBiFunction.apply(StringUtils.substringAfter((String)k, (String)SEPARATOR), (Map)value);
        }
        return value;
    };

    @Test
    public void testBiFunctionForNestedMap() {
        String subSubKey = "subsubkeyMap";
        String subSubValue = "subsubvalue";
        HashMap<String, String> subSubMap = new HashMap<String, String>();
        subSubMap.put("subsubkeyMap", "subsubvalue");
        String subKey = "subkey";
        String subKeyMap = "subkeyMap";
        String subValue = "subvalue";
        HashMap<String, Object> rootSubMap = new HashMap<String, Object>();
        rootSubMap.put("subkey", "subvalue");
        rootSubMap.put("subkeyMap", subSubMap);
        String rootKey = "keyMap";
        String rootKey2 = "key2";
        String rootValue2 = "value2";
        HashMap<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("keyMap", rootSubMap);
        rootMap.put("key2", "value2");
        BiStringLookup stringLookup = StringLookupFactory.INSTANCE.biFunctionStringLookup(this.nestedMapBiFunction);
        Assertions.assertEquals((Object)"value2", (Object)stringLookup.lookup("key2", rootMap));
        Assertions.assertEquals((Object)"subvalue", (Object)stringLookup.lookup("keyMap.subkey", rootMap));
        Assertions.assertEquals((Object)"subsubvalue", (Object)stringLookup.lookup("keyMap.subkeyMap.subsubkeyMap", rootMap));
    }

    @Test
    public void testConcurrentHashMapNull() {
        Assertions.assertNull((Object)BiFunctionStringLookup.on(new ConcurrentHashMap()).lookup(null));
    }

    @Test
    public void testHashMapNull() {
        Assertions.assertNull((Object)BiFunctionStringLookup.on(new HashMap()).lookup(null));
    }

    @Test
    public void testNullBiFunction() {
        Assertions.assertNull((Object)BiFunctionStringLookup.on((BiFunction)null).lookup(null));
    }

    @Test
    public void testOne() {
        String key = "key";
        String value = "value";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        Assertions.assertEquals((Object)"value", (Object)FunctionStringLookup.on(map).lookup("key"));
    }

    @Test
    public void testToString() {
        Assertions.assertFalse((boolean)BiFunctionStringLookup.on(new HashMap()).toString().isEmpty());
    }
}

